import os
import pandas as pd
import gradio as gr
# SNOMEDCT Download https://www.nlm.nih.gov/healthit/snomedct/us_edition.html
# LOINC Download https://loinc.org/downloads/
# ECQM for Value Set Measures and Quality Reporting: https://vsac.nlm.nih.gov/download/ecqm?rel=20220505&res=eh_only.unique_vs.20220505.txt
# SNOMED Nurse Subset https://www.nlm.nih.gov/healthit/snomedct/index.html?_gl=1*36x5pi*_ga*MTI0ODMyNjkxOS4xNjY1NTY3Mjcz*_ga_P1FPTH9PL4*MTY2Nzk4OTI1My41LjEuMTY2Nzk4OTY5Ni4wLjAuMA..

def MatchLOINC(name):
    basedir = os.path.dirname(__file__)
    pd.set_option("display.max_rows", None)
    data = pd.read_csv(f'LoincTableCore.csv')    
    swith=data.loc[data['COMPONENT'].str.contains(name, case=False, na=False)]
    return swith
    
def MatchLOINCPanelsandForms(name):
    basedir = os.path.dirname(__file__)
    data = pd.read_csv(f'PanelsAndForms.csv')     
    swith=data.loc[data['ParentName'].str.contains(name, case=False, na=False)]
    return swith
    
def MatchSNOMED(name):
    basedir = os.path.dirname(__file__)
    data = pd.read_csv(f'sct2_TextDefinition_Full-en_US1000124_20220901.txt',sep='\t')   
    swith=data.loc[data['term'].str.contains(name, case=False, na=False)]
    #swith = data[data['term'].str.match(name)]
    return swith

def MatchOMS(name):
    basedir = os.path.dirname(__file__)
    data = pd.read_csv(f'SnomedOMS.csv')   
    swith=data.loc[data['SNOMED CT'].str.contains(name, case=False, na=False)]
    #swith = data[data['SNOMED CT'].str.match(name)]
    return swith



with gr.Blocks() as demo:
    with gr.Row():
        name = gr.Textbox(label="Enter a term or word to match and find LOINC, SNOMED and OMS clinical terminologies.")


    with gr.Row():
        button1 = gr.Button("LOINC Terminology")
        button2 = gr.Button("LOINC Panels and Forms")
        button3 = gr.Button("SNOMED Clinical Terminology")
        button4 = gr.Button("SNOMED and OMS Clinical Terminology")
    
    with gr.Row():
        output1 = gr.DataFrame(label="LOINC Terminology")
    with gr.Row():
        output2 = gr.DataFrame(label="LOINC Assessment Panels")
    with gr.Row():
        output3 = gr.DataFrame(label="SNOMED Terminology")
    with gr.Row():
        output4 = gr.DataFrame(label="SNOMED and OMS Terminology")

    button1.click(fn=MatchLOINC, inputs=name, outputs=output1)
    button2.click(fn=MatchLOINCPanelsandForms, inputs=name, outputs=output2)
    button3.click(fn=MatchSNOMED, inputs=name, outputs=output3)
    button4.click(fn=MatchOMS, inputs=name, outputs=output4)

demo.launch(debug=True)