import streamlit as st
from moviepy.editor import VideoFileClip
import os

st.title('Video to GIF converter')

uploaded_file = st.file_uploader("Choose a video...", type=["mp4", "mov", "avi", "mkv"])

if uploaded_file is not None:
    with open("temp_video.mp4", "wb") as f:
        f.write(uploaded_file.getbuffer())
        
    st.success('Video uploaded successfully!')
    
    start_time = st.number_input('Enter the start time (in seconds)', min_value=0, value=0, step=1)
    duration = st.number_input('Enter the duration of the clip (in seconds)', min_value=1, value=5, step=1)
    resolution = st.number_input('Enter the height resolution (in pixels)', min_value=1, value=480, step=1)
    
    if st.button('Create GIF'):
        video = VideoFileClip("temp_video.mp4")
        clip = video.subclip(start_time, start_time + duration)
        clip_resized = clip.resize(height=resolution)
        clip_resized.write_gif("output.gif", fps=clip.fps)
        
        st.success('GIF created successfully! Check your directory for a file named "output.gif".')
        os.remove("temp_video.mp4")  # remove the temporary video file
