import streamlit as st
import os
import random

def get_gifs(directory):
    return [f for f in os.listdir(directory) if f.endswith('.gif')]
    
def showAnimatedGif(gif):
    import streamlit as st
    import base64
    #st.markdown("![Alt Text](https://media.giphy.com/media/vFKqnCdLPNOKc/giphy.gif)")
    st.write('Loading: ' + gif)
    file_ = open(gif, "rb")
    contents = file_.read()
    data_url = base64.b64encode(contents).decode("utf-8")
    file_.close()
    st.write(data_url)
    
    st.markdown(
        f'<img src="data:image/gif;base64,{data_url}" alt="gif">',
        unsafe_allow_html=True,
    )

def main():
    st.title('Animated GIFs in Streamlit')

    directory = './gifs'  # Replace with your directory of GIFs
    gif_files = get_gifs(directory)

    num_rows = len(gif_files) // 3
    if len(gif_files) % 3:
        num_rows += 1

    cols = [st.columns(3) for _ in range(num_rows)]
    
    for i in range(num_rows):
        for j in range(3):
            idx = i*3 + j
            if idx < len(gif_files):
                #showAnimatedGif(os.path.join(directory, gif_files[idx]))
                cols[i][j].image(os.path.join(directory, gif_files[idx]), width=200)

    if st.button('Randomize'):
        random.shuffle(gif_files)
        for i in range(num_rows):
            for j in range(3):
                idx = i*3 + j
                if idx < len(gif_files):
                    cols[i][j].image(os.path.join(directory, gif_files[idx]), width=200)

if __name__ == "__main__":
    main()
