import gradio as gr
import os

context = "This could be any large text corpus to use as subject matter to ask questions about.  You can load it as well from text file to isolate it from code changes like in the next line"

with open('Context.txt', 'r') as file:
        context = file.read()

question = "What should be documented in a care plan?"

API_KEY = os.environ.get("HF_TOKEN")
gr.Interface.load(
             "huggingface/deepset/roberta-base-squad2",
             api_key=API_KEY,
             theme="default",
             css=".footer{display:none !important}",
             inputs=[gr.inputs.Textbox(lines=12, default=context, label="Context paragraph"), gr.inputs.Textbox(lines=3, default=question, label="Question")],
             outputs=[gr.outputs.Textbox(label="Answer"), gr.outputs.Textbox(label="Score")],
             title=None,
             description="Provide your own paragraph and ask any question about the text. How well does the model answer?").launch()