import streamlit as st
import pandas as pd
import traceback
import sys

from st_aggrid import AgGrid
from st_aggrid.grid_options_builder import GridOptionsBuilder
from st_aggrid.shared import JsCode
from download import download_button
from st_aggrid import GridUpdateMode, DataReturnMode

# Page config is set once with icon title and display style.  Wide mode since we want screen real estate for wide CSV files
st.set_page_config(page_icon="📝", page_title="📝CSV Data Analyzer📊", layout="wide")

# Style
def _max_width_():
    max_width_str = f"max-width: 1800px;"
    st.markdown(
        f"""
    <style>
    .reportview-container .main .block-container{{
        {max_width_str}
    }}
    </style>    
    """,
        unsafe_allow_html=True,
    )
    
# Title Bar with Images and Icons
col1, col2, col3 = st.columns([1,6,1])
with col1:
    st.image("https://cdnb.artstation.com/p/assets/images/images/054/910/875/large/aaron-wacker-cyberpunk-computer-brain-design.jpg?1665656558",width=128,)
with col2:
    st.title("📝 CSV Data Analyzer 📊")
with col3:
    st.image("https://cdna.artstation.com/p/assets/images/images/054/910/878/large/aaron-wacker-cyberpunk-computer-devices-iot.jpg?1665656564",width=128,)
    
# Upload
c29, c30, c31 = st.columns([1, 6, 1])
with c30:
    uploaded_file = st.file_uploader("", key="1", help="To activate 'wide mode', go to the menu > Settings > turn on 'wide mode'",)
    if uploaded_file is not None:
        file_container = st.expander("Check your uploaded .csv")
        #try:
        shows = pd.read_csv(uploaded_file)
        #except:
        #    print(sys.exc_info()[2])
            
        uploaded_file.seek(0)
        file_container.write(shows)
    else:
        st.info(f"""⬆️Upload a 📝.CSV file.  Examples: [Chatbot](https://huggingface.co/datasets/awacke1/Carddata.csv)  [Mindfulness](https://huggingface.co/datasets/awacke1/MindfulStory.csv)  [Wikipedia](https://huggingface.co/datasets/awacke1/WikipediaSearch)""")
        st.stop()

# DisplayGrid
gb = GridOptionsBuilder.from_dataframe(shows)
gb.configure_default_column(enablePivot=True, enableValue=True, enableRowGroup=True)
gb.configure_selection(selection_mode="multiple", use_checkbox=True)
gb.configure_side_bar()
gridOptions = gb.build()
st.success(f"""💡 Tip! Hold shift key when selecting rows to select multiple rows at once.""")
response = AgGrid(
    shows,
    gridOptions=gridOptions,
    enable_enterprise_modules=True,
    update_mode=GridUpdateMode.MODEL_CHANGED,
    data_return_mode=DataReturnMode.FILTERED_AND_SORTED,
    fit_columns_on_grid_load=False,
)

# Filters
df = pd.DataFrame(response["selected_rows"])
st.subheader("Filtered data will appear below 📊 ")
st.text("")
st.table(df)
st.text("")

# Download
c29, c30, c31 = st.columns([1, 1, 2])
with c29:
    CSVButton = download_button(df,"Dataset.csv","Download CSV file",)
with c30:
    CSVButton = download_button(df,"Dataset.txt","Download TXT file",)