# this is the custome function to return pre-process the image to size (150 150 3)

import numpy as np
from tensorflow.keras.preprocessing import image 
from PIL import Image
import gradio as gr
from keras.models import load_model

def custom_Image_preprocessing(image_data, target_size=(150, 150)):
    img = image.array_to_img(image_data, data_format='channels_last')
    img = img.resize(target_size)  # Resize the image if needed
    img_arr = image.img_to_array(img)
    img_arr = img_arr * 1./255
    img_arr = np.expand_dims(img_arr, axis=0)
    return img_arr

# function to predict the custome image

def image_predict(image_path):
    model = load_model("Second_model.h5")
    image_preprocess = custom_Image_preprocessing(image_path)
    result = model.predict(image_preprocess)
    if ( result <= 0.5  ):
        return 'Negative',round(result[0][0]*100,2),'%'
    else:
        return 'Positive',round(result[0][0]*100,2),'%'


# Define Gradio interface
input_component =  gr.components.Image(label = "Upload the X-Ray")
output_component = gr.components.Textbox(label = "Result")
interface = gr.Interface(fn=image_predict, inputs=input_component, outputs=output_component,title = "Lung Cancer x-Ray Classification",description = "This web app provides predictions based on X-Ray images and predict either the X-ray contains sympotms of lung cancer or not ")
interface.launch()

