from dataclasses import dataclass
from enum import Enum
import glob
import json
import os
from typing import Dict, List

from ..utils_display import AutoEvalColumn

@dataclass
class ModelInfo:
    name: str
    symbol: str # emoji

model_type_symbols = {
    "LLM": "🟢",
    "ImageLLM": "🔶",
    "VideoLLM": "⭕",
    "Other": "🟦",
}

class ModelType(Enum):
    PT = ModelInfo(name="LLM", symbol="🟢")
    FT = ModelInfo(name="ImageLLM", symbol="🔶")
    IFT = ModelInfo(name="VideoLLM", symbol="⭕")
    RL = ModelInfo(name="Other", symbol="🟦")

    def to_str(self, separator = " "):
        return f"{self.value.symbol}{separator}{self.value.name}" 

