"""
Adapted from the SEED-Bench Leaderboard by AILab-CVC
Source: https://huggingface.co/spaces/AILab-CVC/SEED-Bench_Leaderboard
"""

__all__ = ['block', 'make_clickable_model', 'make_clickable_user', 'get_submissions']

import gradio as gr
import pandas as pd
import json
import pdb
import tempfile

from constants import *
from src.auto_leaderboard.model_metadata_type import ModelType

global data_component, filter_component


def upload_file(files):
    file_paths = [file.name for file in files]
    return file_paths

def get_baseline_df():
    df = pd.read_csv(CSV_DIR)
    df = df.sort_values(by="Final Sum Score", ascending=False)
    present_columns = MODEL_INFO + checkbox_group.value
    df = df[present_columns]
    print(df)
    return df

def get_all_df():
    df = pd.read_csv(CSV_DIR)
    df = df.sort_values(by="Final Sum Score", ascending=False)
    print(df)
    return df

block = gr.Blocks()


with block:
    gr.Markdown(
        LEADERBORAD_INTRODUCTION
    )
    with gr.Tabs(elem_classes="tab-buttons") as tabs:
        with gr.TabItem("🏅 EvalCrafter Benchmark", elem_id="evalcrafter-benchmark-tab-table", id=0):
    
            gr.Markdown(
                TABLE_INTRODUCTION
            )

            # selection for column part:
            checkbox_group = gr.CheckboxGroup(
                choices=TASK_INFO_v2,
                value=AVG_INFO,
                label="Select options",
                interactive=True,
            )

            # 创建数据帧组件
            # pdb.set_trace()
            data_component = gr.components.Dataframe(
                value=get_baseline_df, 
                headers=COLUMN_NAMES,
                type="pandas", 
                datatype=DATA_TITILE_TYPE,
                interactive=False,
                visible=True,
                )
    
            def on_checkbox_group_change(selected_columns):
                # pdb.set_trace()
                selected_columns = [item for item in TASK_INFO_v2 if item in selected_columns]
                present_columns = MODEL_INFO + selected_columns
                updated_data = get_all_df()[present_columns]
                updated_data = updated_data.sort_values(by=present_columns[3], ascending=False)
                updated_headers = present_columns
                update_datatype = [DATA_TITILE_TYPE[COLUMN_NAMES.index(x)] for x in updated_headers]

                # pdb.set_trace()
                filter_component = gr.components.Dataframe(
                    value=updated_data, 
                    headers=updated_headers,
                    type="pandas", 
                    datatype=update_datatype,
                    interactive=False,
                    visible=True,
                    )
                # pdb.set_trace()
                return filter_component.value

            # 将复选框组关联到处理函数
            checkbox_group.change(fn=on_checkbox_group_change, inputs=checkbox_group, outputs=data_component)

    
        # table 2
        with gr.TabItem("📝 About", elem_id="evalcrafter-benchmark-tab-table", id=2):
            gr.Markdown(LEADERBORAD_INFO, elem_classes="markdown-text")
    

    with gr.Row():
        data_run = gr.Button("Refresh")
        data_run.click(
            get_baseline_df, outputs=data_component
        )

    gr.Markdown(r"""
        Please cite this paper if you find it useful ♥️:

        ```bibtex
        @inproceedings{Liu2023EvalCrafterBA,
        title={EvalCrafter: Benchmarking and Evaluating Large Video Generation Models},
        author={Yaofang Liu and Xiaodong Cun and Xuebo Liu and Xintao Wang and Yong Zhang and Haoxin Chen and Yang Liu and Tieyong Zeng and Raymond Chan and Ying Shan},
        year={2023},
        url={https://api.semanticscholar.org/CorpusID:264172222}
        }
        ```
        """)
    # block.load(get_baseline_df, outputs=data_title)

block.launch(share=False)