import os
import time
import py3Dmol
import gradio as gr


def display_pdb_by_pdb(pdb):
    # function to display pdb in py3dmol

    view = py3Dmol.view(width=500, height=500)
    view.addModel(pdb, "pdb")
    view.setStyle({'cartoon': {'color': 'spectrum'}})
    # view.setStyle({'model': -1}, {"cartoon": {'colorscheme':{'prop':'b','gradient':'roygb','min':0,'max':1}}})#'linear', 'min': 0, 'max': 1, 'colors': ["#ff9ef0","#a903fc",]}}}) 
    view.zoomTo()
    output = view._make_html().replace("'", '"')
    x = f"""<!DOCTYPE html><html></center> {output} </center></html>"""  # do not use ' in this input
    
    return f"""<iframe height="500px" width="100%"  name="result" allow="midi; geolocation; microphone; camera;
                            display-capture; encrypted-media;" sandbox="allow-modals allow-forms
                            allow-scripts allow-same-origin allow-popups
                            allow-top-navigation-by-user-activation allow-downloads" allowfullscreen=""
                            allowpaymentrequest="" frameborder="0" srcdoc='{x}'></iframe>"""


def show_gif():
    path = 'output'
    pdb_files = sorted(os.listdir(path), key=lambda x: int(x.split('_')[1]))
    num = len(pdb_files)
    i = 0
    while True:
        if i >= num: break
        time.sleep(0.5)
        p = os.path.join(path, pdb_files[i])
        with open(p,'r') as f:
            f_pdb = f.readlines()
        
        i = (i + 1) % num
        yield display_pdb_by_pdb(''.join(f_pdb)), pdb_files[i].split('_')[1]


if __name__ == "__main__":
    title = "Artificial Intelligence Generated Protein"

    css = "footer {visibility: hidden}"

    with gr.Blocks(title=title, css=css) as demo:
        output_viewer = gr.HTML()
        with gr.Row():
            gif = gr.HTML()
        it = gr.Textbox(label="Iteration")
        btn3 = gr.Button("Generate")
        btn3.click(show_gif, [], [gif, it])
    
    demo.queue()
    demo.launch(show_api=False, server_name="0.0.0.0")
    # demo.launch(show_api=False, share=True)