---
title: README.md
sdk: static
emoji: 🏃
colorFrom: blue
colorTo: yellow
---

# Classroom Examples for Today:

# HF Features to Check Out First - Boost your Speed:
1. HF_TOKEN create - Why?  Hit quota on free usage and see errors - Solve w this.  Also this lets spaces read/write as you.
2. Model Easy Button with Gradio
  1. https://huggingface.co/spaces/awacke1/Model-Easy-Button1-ZeroShotImageClassifier-Openai-clip-vit-large-patch14
  2. https://huggingface.co/spaces/awacke1/Easy-Button-Zero-Shot-Text-Classifier-facebook-bart-large-mnli
  3. https://huggingface.co/spaces/awacke1/Model-Easy-Button-Generative-Images-runwayml-stable-diffusion-v1-5
  4. https://huggingface.co/spaces/awacke1/Model-Easy-Button-Generative-Text-bigscience-bloom
  5. Check out API Link at Bottom - Gradio auto generates API for you along with usage.
3. Spaces Embed Button
   1. Bring all four together now into a dashboard!  
4. Space Duplicate Button

# Examples 03_16_2023:
1. HTML5 - Build AI Dashboards with HTML5 Spaces. Spaces Context Menu.  Mediapipe.  https://huggingface.co/spaces/awacke1/AI.Dashboard.HEDIS.Terminology.Vocabulary.Codes
2. ChatGPT - Demonstrate three modes including GPT-4 which started this week. https://chat.openai.com/chat
3. Wikipedia Crowdsource Human Feedback (HF) and Headless URL: https://awacke1-streamlitwikipediachat.hf.space  https://huggingface.co/spaces/awacke1/StreamlitWikipediaChat
4. Cognitive Memory - AI Human Feedback (HF), Wikichat, Tweet Sentiment Dash: https://huggingface.co/spaces/awacke1/AI.Dashboard.Wiki.Chat.Cognitive.HTML5
5. Twitter Sentiment Graph Example:  https://awacke1-twitter-sentiment-live-realtime.hf.space/  Modify to split URL w ChatGPT?
6. ASR Comparitive Review:
   1. Multilingual Models: jonatasgrosman/wav2vec2-large-xlsr-53-english   Space: https://huggingface.co/spaces/awacke1/ASR-High-Accuracy-Test
   2. Speech to Text and Back to Speech in Voice Models: https://huggingface.co/spaces/awacke1/TTS-STT-Blocks  Model: https://huggingface.co/facebook/wav2vec2-base-960h 
   3. Gradio Live Mode: https://huggingface.co/spaces/awacke1/2-LiveASR  Models: facebook/blenderbot-400M-distill   nvidia/stt_en_conformer_transducer_xlarge
7. Bloom Example:
   1. Step By Step w Bloom: https://huggingface.co/spaces/EuroPython2022/Step-By-Step-With-Bloom
8. ChatGPT with Key Example: https://huggingface.co/spaces/awacke1/chatgpt-demo
   1. Get or revoke your keys here:  https://platform.openai.com/account/api-keys
   2. Example fake:  tsk-H2W4lEeT4Aonxe2tQnUzT3BlbkFJq1cMwMANfYc0ftXwrJSo12345t

# Components for Dash - Demo button to Embed Space to get IFRAME code:
https://huggingface.co/spaces/awacke1/Health.Assessments.Summarizer
HEDIS Dash:
1. HEDIS Related Dashboard with CT: https://huggingface.co/spaces/awacke1/AI.Dashboard.HEDIS

# 👋 Two easy ways to turbo boost your AI learning journey! 💻
# 🌐 AI Pair Programming 
## Open 2 Browsers to:
1. __🌐 ChatGPT__ [URL](https://chat.openai.com/chat) or [URL2](https://platform.openai.com/playground) and 
2. __🌐 Huggingface__ [URL](https://huggingface.co/awacke1)  in separate browser windows.

# 🎥 YouTube University Method:

## 🎥 2023 AI/ML Advanced Learning Playlists:
1. [2023 Streamlit Pro Tips for AI UI UX for Data Science, Engineering, and Mathematics](https://www.youtube.com/playlist?list=PLHgX2IExbFou3cP19hHO9Xb-cN8uwr5RM)
2. [2023 Fun, New and Interesting AI, Videos, and AI/ML Techniques](https://www.youtube.com/playlist?list=PLHgX2IExbFotoMt32SrT3Xynt5BXTGnEP)
3. [2023 Best Minds in AGI AI Gamification and Large Language Models](https://www.youtube.com/playlist?list=PLHgX2IExbFotmFeBTpyje1uI22n0GAkXT)
4. [2023 State of the Art for Vision Image Classification, Text Classification and Regression, Extractive Question Answering and Tabular Classification](https://www.youtube.com/playlist?list=PLHgX2IExbFotPcPu6pauNHOoZTTbnAQ2F)
5. [2023 QA Models and Long Form Question Answering NLP](https://www.youtube.com/playlist?list=PLHgX2IExbFovrkkx8HMTLNgYdjCMNYmX_)

# Cloud Patterns - Dataset Architecture Patterns for Cloud Optimal Datasets:
1. Azure Blob/DataLake	adlfs: https://huggingface.co/docs/datasets/filesystems
2. AWS: Amazon S3	s3fs: https://s3fs.readthedocs.io/en/latest/
3. Google Cloud Storage	gcsfs: https://gcsfs.readthedocs.io/en/latest/
4. Google Drive: Google Drive	gdrivefs: https://github.com/intake/gdrivefs

Apache BEAM: https://huggingface.co/docs/datasets/beam
Datasets: https://huggingface.co/docs/datasets/index

# Datasets Spaces - High Performance Cloud Dataset Patterns
1. Health Care AI Datasets: https://huggingface.co/spaces/awacke1/Health-Care-AI-and-Datasets
2. Dataset Analyzer: https://huggingface.co/spaces/awacke1/DatasetAnalyzer
3. Shared Memory with Github LFS: https://huggingface.co/spaces/awacke1/Memory-Shared
4. CSV Dataset Analyzer: https://huggingface.co/spaces/awacke1/CSVDatasetAnalyzer
5. Pandas Profiler Report for EDA Datasets: https://huggingface.co/spaces/awacke1/WikipediaProfilerTestforDatasets
6. Datasets High Performance IMDB Patterns for AI:  https://huggingface.co/spaces/awacke1/SaveAndReloadDataset

# ChatGPT Prompts Datasets
1. https://huggingface.co/datasets/fka/awesome-chatgpt-prompts
2. https://github.com/f/awesome-chatgpt-prompts
3. Example with role based behavior:  I want you to act as a stand-up comedian. I will provide you with some topics related to current events and you will use your wit, creativity, and observational skills to create a routine based on those topics. You should also be sure to incorporate personal anecdotes or experiences into the routine in order to make it more relatable and engaging for the audience. My first request is "I want a humorous story and jokes to talk about the funny things about AI development and executive presentation videos"

# Language Models 🗣️
🏆 Bloom sets new record for most performant and efficient AI model in science! 🌸

### Comparison of Large Language Models
| Model Name        | Model Size (in Parameters) |
| ----------------- | -------------------------- |
| BigScience-tr11-176B | 176 billion |
| GPT-3             | 175 billion               |
| OpenAI's DALL-E 2.0 | 500 million               |
| NVIDIA's Megatron | 8.3 billion               |
| Transformer-XL    | 250 million               |
| XLNet             | 210 million               |

## ChatGPT Datasets 📚
- WebText
- Common Crawl
- BooksCorpus
- English Wikipedia
- Toronto Books Corpus
- OpenWebText
- 
## ChatGPT Datasets - Details 📚
- **WebText:** A dataset of web pages crawled from domains on the Alexa top 5,000 list. This dataset was used to pretrain GPT-2.
  - [WebText: A Large-Scale Unsupervised Text Corpus by Radford et al.](https://paperswithcode.com/dataset/webtext)
- **Common Crawl:** A dataset of web pages from a variety of domains, which is updated regularly. This dataset was used to pretrain GPT-3.
  - [Language Models are Few-Shot Learners](https://paperswithcode.com/dataset/common-crawl) by Brown et al.
- **BooksCorpus:** A dataset of over 11,000 books from a variety of genres.
  - [Scalable Methods for 8 Billion Token Language Modeling](https://paperswithcode.com/dataset/bookcorpus) by Zhu et al.
- **English Wikipedia:** A dump of the English-language Wikipedia as of 2018, with articles from 2001-2017.
  - [Improving Language Understanding by Generative Pre-Training](https://huggingface.co/spaces/awacke1/WikipediaUltimateAISearch?logs=build) Space for Wikipedia Search
- **Toronto Books Corpus:** A dataset of over 7,000 books from a variety of genres, collected by the University of Toronto.
  - [Massively Multilingual Sentence Embeddings for Zero-Shot Cross-Lingual Transfer and Beyond](https://paperswithcode.com/dataset/bookcorpus) by Schwenk and Douze.
- **OpenWebText:** A dataset of web pages that were filtered to remove content that was likely to be low-quality or spammy. This dataset was used to pretrain GPT-3.
  - [Language Models are Few-Shot Learners](https://paperswithcode.com/dataset/openwebtext) by Brown et al.
    
## Big Science Model 🚀
- 📜 Papers:
  1. BLOOM: A 176B-Parameter Open-Access Multilingual Language Model [Paper](https://arxiv.org/abs/2211.05100)
  2. Megatron-LM: Training Multi-Billion Parameter Language Models Using Model Parallelism [Paper](https://arxiv.org/abs/1909.08053)
  3. 8-bit Optimizers via Block-wise Quantization [Paper](https://arxiv.org/abs/2110.02861)
  4. Train Short, Test Long: Attention with Linear Biases Enables Input Length Extrapolation [Paper](https://arxiv.org/abs/2108.12409)
  5. [Other papers related to Big Science](https://huggingface.co/models?other=doi:10.57967/hf/0003)
  6. [217 other models optimized for use with Bloom](https://huggingface.co/models?other=bloom)
 
- 📚 Datasets:
  
**Datasets:**
1. - **Universal Dependencies:** A collection of annotated corpora for natural language processing in a range of languages, with a focus on dependency parsing.
  - [Universal Dependencies official website.](https://universaldependencies.org/)
2. - **WMT 2014:** The fourth edition of the Workshop on Statistical Machine Translation, featuring shared tasks on translating between English and various other languages.
  - [WMT14 website.](http://www.statmt.org/wmt14/)
3. - **The Pile:** An English language corpus of diverse text, sourced from various places on the internet.
  - [The Pile official website.](https://pile.eleuther.ai/)
4. - **HumanEval:** A dataset of English sentences, annotated with human judgments on a range of linguistic qualities.
  - [HumanEval: An Evaluation Benchmark for Language Understanding](https://github.com/google-research-datasets/humaneval) by Gabriel Ilharco, Daniel Loureiro, Pedro Rodriguez, and Afonso Mendes.
5. - **FLORES-101:** A dataset of parallel sentences in 101 languages, designed for multilingual machine translation.
  - [FLORES-101: A Massively Multilingual Parallel Corpus for Language Understanding](https://flores101.opennmt.net/) by Aman Madaan, Shruti Rijhwani, Raghav Gupta, and Mitesh M. Khapra.
6. - **CrowS-Pairs:** A dataset of sentence pairs, designed for evaluating the plausibility of generated text.
  - [CrowS-Pairs: A Challenge Dataset for Plausible Plausibility Judgments](https://github.com/stanford-cogsci/crows-pairs) by Andrea Madotto, Zhaojiang Lin, Chien-Sheng Wu, Pascale Fung, and Caiming Xiong.
7. - **WikiLingua:** A dataset of parallel sentences in 75 languages, sourced from Wikipedia.
  - [WikiLingua: A New Benchmark Dataset for Cross-Lingual Wikification](https://arxiv.org/abs/2105.08031) by Jiarui Yao, Yanqiao Zhu, Ruihan Bao, Guosheng Lin, Lidong Bing, and Bei Shi.
8. - **MTEB:** A dataset of English sentences, annotated with their entailment relationships with respect to other sentences.
  - [Multi-Task Evaluation Benchmark for Natural Language Inference](https://github.com/google-research-datasets/mteb) by Michał Lukasik, Marcin Junczys-Dowmunt, and Houda Bouamor.
9. - **xP3:** A dataset of English sentences, annotated with their paraphrase relationships with respect to other sentences.
  - [xP3: A Large-Scale Evaluation Benchmark for Paraphrase Identification in Context](https://github.com/nyu-dl/xp3) by Aniket Didolkar, James Mayfield, Markus Saers, and Jason Baldridge.
10. - **DiaBLa:** A dataset of English dialogue, annotated with dialogue acts.
  - [A Large-Scale Corpus for Conversation Disentanglement](https://github.com/HLTCHKUST/DiaBLA) by Samuel Broscheit, António Branco, and André F. T. Martins.
    
- 📚 Dataset Papers with Code
  1. [Universal Dependencies](https://paperswithcode.com/dataset/universal-dependencies)
  2. [WMT 2014](https://paperswithcode.com/dataset/wmt-2014)
  3. [The Pile](https://paperswithcode.com/dataset/the-pile)
  4. [HumanEval](https://paperswithcode.com/dataset/humaneval)
  5. [FLORES-101](https://paperswithcode.com/dataset/flores-101)
  6. [CrowS-Pairs](https://paperswithcode.com/dataset/crows-pairs)
  7. [WikiLingua](https://paperswithcode.com/dataset/wikilingua)
  8. [MTEB](https://paperswithcode.com/dataset/mteb)
  9. [xP3](https://paperswithcode.com/dataset/xp3)
  10. [DiaBLa](https://paperswithcode.com/dataset/diabla)
      
# Deep RL ML Strategy 🧠
The AI strategies are:
- Language Model Preparation using Human Augmented with Supervised Fine Tuning 🤖
- Reward Model Training with Prompts Dataset Multi-Model Generate Data to Rank 🎁
- Fine Tuning with Reinforcement Reward and Distance Distribution Regret Score 🎯
- Proximal Policy Optimization Fine Tuning 🤝
- Variations - Preference Model Pretraining 🤔
- Use Ranking Datasets Sentiment - Thumbs Up/Down, Distribution 📊
- Online Version Getting Feedback 💬
- OpenAI - InstructGPT - Humans generate LM Training Text 🔍
- DeepMind - Advantage Actor Critic Sparrow, GopherCite 🦜
- Reward Model Human Prefence Feedback 🏆

  
For more information on specific techniques and implementations, check out the following resources:
- OpenAI's paper on [GPT-3](https://arxiv.org/abs/2005.14165) which details their Language Model Preparation approach
- DeepMind's paper on [SAC](https://arxiv.org/abs/1801.01290) which describes the Advantage Actor Critic algorithm
- OpenAI's paper on [Reward Learning](https://arxiv.org/abs/1810.06580) which explains their approach to training Reward Models
- OpenAI's blog post on [GPT-3's fine-tuning process](https://openai.com/blog/fine-tuning-gpt-3/)