import streamlit as st
import plotly.graph_objects as go

# List of top six prior auth conditions
conditions = [
    {
        "diagnosis": "Diagnosis 1",
        "observations": "Observations 1",
        "CCD": "CCD 1",
        "CCD_procedures": "CCD Procedures 1"
    },
    # Add more conditions here
]

# MSK hip and knee surgery list dictionary
surgery_data = [
    {
        "CPTCode": "CPT Code 1",
        "CPTDescription": "MSK Hip Surgery",
        "ICD10Code": "ICD10 Code 1",
        "ICD10Description": "ICD10 Description 1",
        "Emoji": "💉",
        "Description": "Hip Surgery",
        "Cost": 10
    },
    {
        "CPTCode": "CPT Code 2",
        "CPTDescription": "MSK Knee Surgery",
        "ICD10Code": "ICD10 Code 2",
        "ICD10Description": "ICD10 Description 2",
        "Emoji": "💊",
        "Description": "Knee Surgery",
        "Cost": 15
    }
]

# Sort the surgery data by descending cost
surgery_data.sort(key=lambda x: x["Cost"], reverse=True)

# Function to create heatmap circle plot
def create_heatmap_circle_plot(surgery_data):
    fig = go.Figure()

    for surgery in surgery_data:
        fig.add_trace(go.Scatter(
            x=[surgery["CPTCode"]],
            y=[surgery["Cost"]],
            mode='markers',
            marker=dict(
                size=20,
                color=[surgery["Cost"]],
                colorscale='Viridis',
                showscale=True
            ),
            text=surgery["CPTDescription"],
            hovertemplate='<b>%{text}</b><br><i>CPT Code</i>: %{x}<br><i>Cost</i>: %{y}'))

    fig.update_layout(title='Heatmap Circle Plot of Surgery Types',
                      xaxis_title='CPT Codes',
                      yaxis_title='Cost (in billions)')

    return fig

# Streamlit app
st.title("Top Prior Auth Conditions")
st.header("MSK Hip and Knee Surgery")
st.write(surgery_data)

st.header("Heatmap Circle Plot")
fig = create_heatmap_circle_plot(surgery_data)
st.plotly_chart(fig)
