import streamlit as st
st.markdown("""

# 🏥 CCDA (Consolidated Clinical Document Architecture) 📄
The CCD is a document standard developed by Health Level Seven International (HL7) for the exchange of clinical information. 🔄 It is a universally accepted format for sharing clinical data across different electronic health record (EHR) systems. 🌐

## 📚 CCD Standard Templates 📋
The CCD standard includes templates for different types of clinical documents, like:
- 📤 Discharge summaries
- 🗒️ Progress notes
- 📄 Clinical summaries
These templates are based on existing document standards like the Continuity of Care Record (CCR). ✅

# FHIR Map to CCD
| CCD Templates | Emoji | FHIR Resources |
|---------------|-------|----------------|
| Patient Demographics | 🏥 | [Patient](https://www.hl7.org/fhir/patient.html) |
| Encounters | 👩‍⚕️ | [Encounter](https://www.hl7.org/fhir/encounter.html) |
| Procedures | 🚑 | [Procedure](https://www.hl7.org/fhir/procedure.html) |
| Laboratory Results | 🔬 | [Observation](https://www.hl7.org/fhir/observation.html) |
| Vital Signs | 📈 | [Observation](https://www.hl7.org/fhir/observation.html) |
| Clinical Notes | 📝 | [ClinicalImpression](https://www.hl7.org/fhir/clinicalimpression.html), [Composition](https://www.hl7.org/fhir/composition.html) |
| Medications | 💊 | [MedicationStatement](https://www.hl7.org/fhir/medicationstatement.html), [MedicationRequest](https://www.hl7.org/fhir/medicationrequest.html) |
| Immunizations | 📅 | [Immunization](https://www.hl7.org/fhir/immunization.html) |


# CCD Documents - Standard Templates

## 1. 🏥 Patient Demographics
| Attribute | Description |
|-----------|-------------|
| Patient ID | Unique identifier for the patient |
| Name | Full name of the patient |
| Date of Birth | Birth date of the patient |
| Sex | Gender of the patient |
| Address | Residential address of the patient |

## 2. 💊 Medications
| Attribute | Description |
|-----------|-------------|
| Medication Name | Name of the medication |
| Dosage | Dosage of the medication |
| Frequency | How often the medication is taken |
| Start Date | When the medication was started |
| End Date | When the medication was stopped |

## 3. 👩‍⚕️ Encounters
| Attribute | Description |
|-----------|-------------|
| Encounter ID | Unique identifier for the encounter |
| Encounter Type | Type of encounter (e.g., office visit, hospitalization) |
| Start Date/Time | When the encounter began |
| End Date/Time | When the encounter ended |
| Encounter Provider | Healthcare provider during the encounter |

## 4. 🔬 Laboratory Results
| Attribute | Description |
|-----------|-------------|
| Test Name | Name of the lab test |
| Date/Time | When the lab test was performed |
| Result | Result of the lab test |
| Normal Range | Normal range for the lab test result |

## 5. 🚑 Procedures
| Attribute | Description |
|-----------|-------------|
| Procedure Name | Name of the procedure |
| Date/Time | When the procedure was performed |
| Performing Provider | Healthcare provider who performed the procedure |

## 6. 📅 Immunizations
| Attribute | Description |
|-----------|-------------|
| Vaccine Name | Name of the vaccine |
| Administration Date | When the vaccine was administered |
| Administering Provider | Healthcare provider who administered the vaccine |

## 7. 📈 Vital Signs
| Attribute | Description |
|-----------|-------------|
| Vital Sign Type | Type of vital sign (e.g., blood pressure, temperature) |
| Date/Time | When the vital sign was measured |
| Value | Value of the vital sign |
| Unit | Unit of the vital sign value |


## 8. 📝 Clinical Notes
| Attribute | Description |
|-----------|-------------|
| Note Type | Type of clinical note (e.g., progress note, discharge summary) |
| Note Date | When the note was written |
| Note Author | Healthcare provider who wrote the note |
| Note Content | Content of the note |

# Messages for ADT, ORM, SIU, EDI, Procedures, Observations

## ADT (Admit/Discharge/Transfer) messages
| Patient ID | Name | Admission Date/Time | Discharge Date/Time | Clinical Encounter |
|------------|------|---------------------|---------------------|--------------------|
| 001        | John Doe | 2023-05-01 10:00 | 2023-05-10 10:00 | Heart Surgery |


## ORM (Order Entry) messages
| Order ID | Order Date/Time | Order Status | Relevant Clinical Data |
|----------|-----------------|--------------|------------------------|
| 1001     | 2023-05-01 11:00 | Completed | Lab Test: Blood Sugar Level |

## SIU (Scheduling Information Update) messages
| Patient Name | Appointment Date/Time | Provider Name | Relevant Clinical Information |
|--------------|-----------------------|---------------|-------------------------------|
| John Doe     | 2023-05-15 10:00 | Dr. Smith | Follow-up: Heart Surgery |

## EDI (Electronic Data Interchange)
| Patient Information | Clinical Data | Billing Information |
|---------------------|---------------|---------------------|
| John Doe, Male, 55  | Heart Surgery | $5000 |

## Procedures
| Procedure Type | Date/Time of Procedure | Relevant Clinical Data or Reports |
|----------------|------------------------|-----------------------------------|
| Heart Surgery  | 2023-05-01 12:00 | Surgery Successful |

## Observations
| Observation Type | Date/Time of Observation | Relevant Clinical Data or Reports |
|------------------|--------------------------|-----------------------------------|
| Blood Pressure   | 2023-05-10 09:00 | 120/80 mmHg |

## 🔄 Translation to CCD Format 🗂️
To translate different healthcare documents to the CCD format, follow these guidelines:
1. **ADT (Admit/Discharge/Transfer) messages** 🏥
   - Patient registration, admission, transfer, and discharge
   - Include patient demographic information, admission and discharge date/time, and clinical encounter information
2. **ORM (Order Entry) messages** 💊
   - Contains requests for labs, procedures, or medication
   - Include the order request, order date/time, order status, and any relevant clinical data
3. **SIU (Scheduling Information Update) messages** 📆
   - Used for scheduling appointments and updating appointment status
   - Include the patient name, appointment date/time, provider name, and any relevant clinical information
4. **EDI (Electronic Data Interchange)** 💻
   - A standardized format for transmitting healthcare data
   - Include patient information, clinical data, and billing information
5. **Procedures** 🚑
   - Any procedures or surgeries performed on a patient
   - Include the procedure type, date/time of the procedure, and any relevant clinical data or reports
6. **Observations** 🔬
   - Any relevant clinical observations or measurements
   - Include the observation type, date/time of the observation, and any relevant clinical data or reports
In summary, the CCD is a standardized format for exchanging clinical information. To translate different healthcare documents to the CCD format, follow the guidelines above. ✨

""")