import streamlit as st
import itertools
from nltk.corpus import wordnet

def get_synonyms(word):
    synonyms = set()
    for syn in wordnet.synsets(word):
        for lemma in syn.lemmas():
            synonyms.add(lemma.name())
    return list(synonyms)

def generate_words(letters, length=None):
    permutations = set()
    for i in range(1, len(letters) + 1):
        for p in itertools.permutations(letters, i):
            word = "".join(p)
            if length is None or len(word) == length:
                permutations.add(word)
    return permutations

st.title("Scrabble Helper")

letters = st.text_input("Enter the letters you have:")
word_length = st.number_input("Enter the word length (optional):", min_value=0, value=0, step=1)

if letters:
    st.header("Generated Words")
    words = generate_words(letters, length=word_length if word_length > 0 else None)
    st.write(words)

    st.header("Thesaurus Lookup")
    selected_word = st.selectbox("Select a word to look up synonyms:", [""] + sorted(words))
    if selected_word:
        synonyms = get_synonyms(selected_word)
        st.write(synonyms)
