import streamlit as st
import streamlit.components.v1 as components
import networkx as nx
import matplotlib.pyplot as plt
from pyvis.network import Network
import got 
import numpy as np
import pandas as pd
import time
import re
import graphviz as graphviz
import pydeck as pdk

from st_click_detector import click_detector

st.graphviz_chart('''
    digraph {
Income ->  AbleToBuyOnlyNecessities
Income ->  DifficultyBuyingNecessities
Income ->  DifficultyWithMoneyManagement
Income ->  LowNoIncome
Income ->  UninsuredMedicalExpenses
            }
''')

st.graphviz_chart('''
    digraph {
Income ->  Continuityof  ->  Care
Income ->  Durable  ->  Medical  ->  Equipment
Income ->  Finances
Income ->  LegalSystem
Income ->  Medical  ->  Dental  ->  Care
Income ->  Medication  ->  Coordination  ->  Ordering
Income ->  Other  ->  Community  ->  Resources
Income ->  SocialWork  ->  Counseling  ->  Care
Income ->  Supplies
            }
''')

st.graphviz_chart('''
    digraph {
MentalHealth ->  Apprehension  ->  Undefined  ->  Fear  ->  Anxious
MentalHealth ->  Attempts  ->  Suicide  ->  Homicide
MentalHealth ->  Difficulty  ->  Managing  ->  Anger
MentalHealth ->  Difficulty  ->  Managing  ->  Stress
MentalHealth ->  Expresses  ->  Suicidal  ->  Homicidal  ->  Thoughts
MentalHealth ->  False  ->  Beliefs  ->  Delusions
MentalHealth ->  False  ->  Perceptions  ->  Hallucinations  ->  Illusions
MentalHealth ->  FlatAffect  ->  LackofEmotion
MentalHealth ->  Irritable  ->  Agitated  ->  Aggressive
MentalHealth ->  LossofInterest  ->  Involvementin  ->  ActivitiesSelfCare
MentalHealth ->  MoodSwings
MentalHealth ->  Narrowedto  ->  Scattered  ->  Attention  ->  Focus
MentalHealth ->  Purposeless  ->  Compulsive  ->  RepetitiveActivity
MentalHealth ->  Sadness  ->  Hopelessness  ->  Decreased  ->  SelfEsteem
MentalHealth ->  Somatic  ->  Complaints  ->  Fatigue
            }
''')

st.graphviz_chart('''
    digraph {
MentalHealth ->  Anger  ->  Management
MentalHealth ->  Behavioral  ->  Health  ->  Care
MentalHealth ->  Communication
MentalHealth ->  Continuityof  ->  Care
MentalHealth ->  Coping  ->  Skills
MentalHealth ->  Dietary  ->  Management
MentalHealth ->  Discipline
MentalHealth ->  EndofLife  ->  Care
MentalHealth ->  Interaction
MentalHealth ->  LegalSystem
MentalHealth ->  Medical  ->  Dental  ->  Care
MentalHealth ->  Medication  ->  ActionSideEffects
MentalHealth ->  Medication  ->  Administration
MentalHealth ->  Medication  ->  CoordinationOrdering
MentalHealth ->  Nursing  ->  Care
MentalHealth ->  Nutritionist  ->  Care
MentalHealth ->  Other  ->  Community  ->  Resources
MentalHealth ->  Relaxation  ->  Breathing  ->  Techniques
MentalHealth ->  Rest  ->  Sleep
MentalHealth ->  Safety
MentalHealth ->  Screening  ->  Procedures
MentalHealth ->  SignsSymptoms  ->  MentalEmotional
MentalHealth ->  SignsSymptoms  ->  Physical
MentalHealth ->  SocialWork  ->  Counseling  ->  Care
MentalHealth ->  Stress  ->  Management
MentalHealth ->  Support  ->  Group
MentalHealth ->  Support  ->  System
MentalHealth ->  Wellness
            }
''')


st.graphviz_chart('''
    digraph {
Respiration ->  Abnormal  ->  BreathSoundsCrackles
Respiration ->  Abnormal  ->  IrregularBreathPatterns
Respiration ->  Abnormal  ->  RespiratoryLaboratoryResults
Respiration ->  Abnormal  ->  Sputum
Respiration ->  Cough
Respiration ->  Noisy  ->  RespirationswheezingRalesRhonchi
Respiration ->  Rhinorrhea  ->  NasalCongestion
Respiration ->  UnabletoBreathe  ->  Independently
            }
''')

st.graphviz_chart('''
    digraph {
Respiration ->  Anatomy  ->  Physiology
Respiration ->  Continuityof  ->  Care
Respiration ->  Coping  ->  Skills
Respiration ->  Dietary  ->  Management
Respiration ->  Durable  ->  Medical  ->  Equipment
Respiration ->  Education
Respiration ->  EndofLife  ->  Care
Respiration ->  Environment
Respiration ->  Exercises
Respiration ->  Infection  ->  Precautions
Respiration ->  Laboratory  ->  Findings
Respiration ->  Medical  ->  Dental  ->  Care
Respiration ->  Medication  ->  Action  ->  SideEffects
Respiration ->  Medication  ->  Administration
Respiration ->  Medication  ->  Prescription
Respiration ->  Medication  ->  SetUp
Respiration ->  Mobility  ->  Transfers
Respiration ->  Nursing  ->  Care
Respiration ->  Positioning
Respiration ->  Relaxation  ->  Breathing  ->  Techniques
Respiration ->  Respiratory  ->  Care
Respiration ->  Respiratory  ->  Therapy  ->  Care
Respiration ->  Safety
Respiration ->  Screening  ->  Procedures
Respiration ->  SignsSymptoms  ->  MentalEmotional
Respiration ->  SignsSymptoms  ->  Physical
Respiration ->  Specimen  ->  Collection
Respiration ->  Supplies
Respiration ->  Support  ->  Group
Respiration ->  Support  ->  System
Respiration ->  Wellness
            }
''')


st.graphviz_chart('''
    digraph {
Circulation ->  Abnormal  ->  BloodPressureReading
Circulation ->  Abnormal  ->  CardiacLaboratoryResults
Circulation ->  Abnormal  ->  Clotting
Circulation ->  Abnormal  ->  HeartSoundsMurmurs
Circulation ->  Anginal  ->  Pain
Circulation ->  Cramping  ->  Pain  ->  ofExtremities
Circulation ->  Decreased  ->  Pulses
Circulation ->  Discoloration  ->  ofSkinCyanosis
Circulation ->  EdemaSwelling  ->  inlegsarmsfeet
Circulation ->  ExcessivelyRapid  ->  HeartRate
Circulation ->  IrregularHeartRate
Circulation ->  SyncopalEpisodes  ->  Fainting  ->  Dizziness
Circulation ->  TemperatureChange  ->  inAffectedArea
Circulation ->  Varicosities
            }
''')

st.graphviz_chart('''
    digraph {
Circulation ->  Anatomy  ->  Physiology
Circulation ->  Cardiac  ->  Care
Circulation ->  Continuityof  ->  Care
Circulation ->  Coping  ->  Skills
Circulation ->  Dietary  ->  Management
Circulation ->  Durable  ->  Medical  ->  Equipment
Circulation ->  Exercises
Circulation ->  Finances
Circulation ->  Infection  ->  Precautions
Circulation ->  Laboratory  ->  Findings
Circulation ->  Medical  ->  Dental  ->  Care
Circulation ->  Medication  ->  Action  ->  SideEffects
Circulation ->  Medication  ->  Administration
Circulation ->  Medication  ->  SetUp
Circulation ->  Mobility  ->  Transfers
Circulation ->  Nursing  ->  Care
Circulation ->  Personal  ->  Hygiene
Circulation ->  Relaxation  ->  Breathing  ->  Techniques
Circulation ->  Safety
Circulation ->  Screening  ->  Procedures
Circulation ->  SignsSymptoms  ->  MentalEmotional
Circulation ->  SignsSymptoms  ->  Physical
Circulation ->  Support  ->  Group
Circulation ->  Support  ->  System
Circulation ->  Wellness
            }
''')

df = pd.read_csv("testfile.csv")
@st.cache
def convert_df(df):
   return df.to_csv().encode('utf-8')
csv = convert_df(df)
st.download_button(
   "Press to Download",
   csv,
   "testfile.csv",
   "text/csv",
   key='download-csv'
)


st.title('Streamlit Visualization')
dataframe = pd.DataFrame(np.random.randn(10, 20),
  columns = ('col %d' % i
    for i in range(20)))
st.write(dataframe)

dataframe = pd.DataFrame(np.random.randn(10, 5),
  columns = ('col %d' % i
    for i in range(5)))
dataframe
st.write('This is a line_chart.')
st.line_chart(dataframe)

st.write('This is a area_chart.')
st.area_chart(dataframe)

st.write('This is a bar_chart.')
st.bar_chart(dataframe)

st.write('Map data')
data_of_map = pd.DataFrame(
  np.random.randn(1000, 2) / [60, 60] + [36.66, -121.6],
  columns = ['latitude', 'longitude'])
st.map(data_of_map)


st.title('Pyvis VisJS DOTlang Legend')

Network(notebook=True)
# make Network show itself with repr_html

def net_repr_html(self):
  nodes, edges, height, width, options = self.get_network_data()
  html = self.template.render(height=height, width=width, nodes=nodes, edges=edges, options=options)
  return html

Network._repr_html_ = net_repr_html

st.sidebar.title('Choose your favorite Graph')
option=st.sidebar.selectbox('select graph',('Simple','Karate', 'GOT'))
physics=st.sidebar.checkbox('add physics interactivity?')
got.simple_func(physics)

if option=='Simple':
  HtmlFile = open("test.html", 'r', encoding='utf-8')
  source_code = HtmlFile.read() 
  components.html(source_code, height = 900,width=900)

got.got_func(physics)

if option=='GOT':
  HtmlFile = open("gameofthrones.html", 'r', encoding='utf-8')
  source_code = HtmlFile.read() 
  components.html(source_code, height = 1200,width=1000)

got.karate_func(physics)

if option=='Karate':
  HtmlFile = open("karate.html", 'r', encoding='utf-8')
  source_code = HtmlFile.read() 
  components.html(source_code, height = 1200,width=1000)