import streamlit as st


st.markdown("""

## FHIR - CT - Graph

# FHIR:
https://huggingface.co/spaces/awacke1/Clinical-Terminology-FHIR-Assessment
https://huggingface.co/spaces/awacke1/SMART-FHIR-Assessment-Observation-SDKs
https://huggingface.co/spaces/awacke1/SMART-FHIR-Kits-SDC-HL7
https://huggingface.co/spaces/awacke1/SMART-FHIR-Assessment-Blood-Pressure
https://huggingface.co/spaces/awacke1/SMART-FHIR-Assessment-Exercise

# Clinical Terminology:
https://huggingface.co/spaces/awacke1/Ontology-Gradio
https://huggingface.co/spaces/awacke1/Biomed-NLP-AI-Clinical-Terminology
https://huggingface.co/spaces/awacke1/ClinicalTerminologyNER-Refactored
https://huggingface.co/spaces/awacke1/ClinicalTerminologyAISearch
https://huggingface.co/spaces/awacke1/ClinicalTerminologyAISearch1215

# Graph, Clinical Terminology, FHIR Apps and Services:
https://huggingface.co/spaces/awacke1/Git-GPG-Git-Actions-01-GraphViz
https://huggingface.co/spaces/awacke1/Dice-Roll-Treemap-Plotly
https://huggingface.co/spaces/awacke1/GraphVis3
https://huggingface.co/spaces/awacke1/GraphViz-Demo
https://huggingface.co/spaces/awacke1/StreamlitGraphViz
https://huggingface.co/spaces/awacke1/CardGameActivity-GraphViz

# CP Matplotlib, NetworkX, Streamlit, PyVis, st-click0detector, graphviz:
https://huggingface.co/spaces/awacke1/CPVisGraph

# OMS and LOCUS:
https://huggingface.co/spaces/awacke1/NLPGraphOMSandLOCUS

# Technical Architecture - Open Source Graph ML Libraries:
NetworkX: https://networkx.org/
PyTorch GNN: https://github.com/microsoft/ptgnn
Jraph: https://github.com/deepmind/jraph
Spektral: https://graphneural.network/
Graph Nets: https://github.com/deepmind/graph_nets
Deep Graph Library (DGL): https://github.com/dmlc
PyTorch Geometric: https://github.com/pyg-team/pytorch_geometric

# Provider Graph - Maps of Hospitals

https://huggingface.co/spaces/awacke1/MN.Map.Hospitals.Top.Five
![image](https://user-images.githubusercontent.com/30595158/226150906-65fcdb27-b234-4500-8cd8-c6b88d1afa05.png)



# Graph, Clinical Terminology, FHIR Apps and Services:

CP Matplotlib, NetworkX, Streamlit, PyVis, st-click0detector, graphviz:
https://huggingface.co/spaces/awacke1/CPVisGraph

OMS and LOCUS:
https://huggingface.co/spaces/awacke1/NLPGraphOMSandLOCUS

https://huggingface.co/spaces/awacke1/Git-GPG-Git-Actions-01-GraphViz
https://huggingface.co/spaces/awacke1/Dice-Roll-Treemap-Plotly
https://huggingface.co/spaces/awacke1/GraphVis3
https://huggingface.co/spaces/awacke1/GraphViz-Demo
https://huggingface.co/spaces/awacke1/StreamlitGraphViz
https://huggingface.co/spaces/awacke1/CardGameActivity-GraphViz

Technical Architecture - Open Source Graph ML Libraries:

NetworkX: https://networkx.org/
PyTorch GNN: https://github.com/microsoft/ptgnn
Jraph: https://github.com/deepmind/jraph
Spektral: https://graphneural.network/
Graph Nets: https://github.com/deepmind/graph_nets
Deep Graph Library (DGL): https://github.com/dmlc
PyTorch Geometric: https://github.com/pyg-team/pytorch_geometric



# Clinical Terminology:
# FHIR:
https://huggingface.co/spaces/awacke1/Clinical-Terminology-FHIR-Assessment
https://huggingface.co/spaces/awacke1/SMART-FHIR-Assessment-Observation-SDKs
https://huggingface.co/spaces/awacke1/SMART-FHIR-Kits-SDC-HL7
https://huggingface.co/spaces/awacke1/SMART-FHIR-Assessment-Blood-Pressure
https://huggingface.co/spaces/awacke1/SMART-FHIR-Assessment-Exercise


# Clinical Terminology:
https://huggingface.co/spaces/awacke1/Ontology-Gradio
https://huggingface.co/spaces/awacke1/Biomed-NLP-AI-Clinical-Terminology
https://huggingface.co/spaces/awacke1/ClinicalTerminologyNER-Refactored
https://huggingface.co/spaces/awacke1/ClinicalTerminologyAISearch
https://huggingface.co/spaces/awacke1/ClinicalTerminologyAISearch1215




# Saturday Evening:
https://huggingface.co/spaces/awacke1/MN.Map.Hospitals.Top.Five
![image](https://user-images.githubusercontent.com/30595158/226150906-65fcdb27-b234-4500-8cd8-c6b88d1afa05.png)


# Iceland Myths - Places to See - https://huggingface.co/spaces/awacke1/Maps.Markers.Honor.Iceland
![image](https://user-images.githubusercontent.com/30595158/226151615-71d82400-b849-419e-833c-e8632676bc49.png)

Ásbyrgi: Thor, trying to prove his strength, challenged Sleipnir to a race. Odin agreed, but secretly fed Sleipnir his favorite snack, lightning bolts. With each step, Sleipnir left a massive print, and thus, Ásbyrgi was formed.

![image](https://user-images.githubusercontent.com/30595158/226151903-2298f479-f829-48bb-83e5-546677da85ac.png)



# Saturday
write a streamlit python program that uses functions and user interface elements of a textbox, a dial, a four direction button array for up down left right and display a folium map with the data in python list dictionaries with these values: Aurora Spottings, Notifications on Nerthern Lights, Northern lights map location cities and countries for Iceland on a map written with folium for latitude and longitude of top ten places to view Northern Lights.  Cite References as urls.

# Maps

Space							|				URL
-------------------------------------------------------------------------------------------------------------------------------------------
awacke1/VizLib-TopLargeHospitalsNewJersey-03-09-2023 | https://huggingface.co/spaces/awacke1/VizLib-TopLargeHospitalsNewJersey-03-09-2023
awacke1/Bird-Species-Migration-Month-Map	|	https://huggingface.co/spaces/awacke1/Bird-Species-Migration-Month-Map
⚗️🧠🔬🧬 Clinical Terminology Auto Mapper AI 👩‍⚕️🩺⚕️🙋	|	https://huggingface.co/spaces/awacke1/SNOMED-LOINC-eCQM	
awacke1/Visualization-Plotly-Sunbursts-Treemaps-and-WebGL	|	https://huggingface.co/spaces/awacke1/Visualization-Plotly-Sunbursts-Treemaps-and-WebGL
awacke1/HTML5-Aframe-3D-Maps	|	https://huggingface.co/spaces/awacke1/HTML5-Aframe-3D-Maps
awacke1/HTML5-Aframe-3dMap-Flight	|	https://huggingface.co/spaces/awacke1/HTML5-Aframe-3dMap-Flight

Figures:
![image](https://user-images.githubusercontent.com/30595158/226116055-25b8c900-bc10-472d-8b5f-61c7b8b5452b.png)



# Top Ten Board Games
## Map-Making-Strategy
https://huggingface.co/spaces/awacke1/Top-Ten-Board-Games-Map-Making-Strategy



# MediaPipe
### A cross language SDK for AI that is real time, 3d, camera responsive, and on any device for nearly any language
#### Vision
#### Natural Language
#### Audio

Mediapipe has fast and flexible AI/ML pipelines.
Examples with Javascript Links!

1. Image Classifier: https://mediapipe-studio.webapps.google.com/demo/image_classifier
2. Object Detector: https://mediapipe-studio.webapps.google.com/demo/object_detector
3. Text Classification: https://mediapipe-studio.webapps.google.com/demo/text_classifier
4. Gesture Recognizer: https://mediapipe-studio.webapps.google.com/demo/gesture_recognizer
5. Hand Landmark Detection: https://mediapipe-studio.webapps.google.com/demo/hand_landmarker
6. Audio Classifier: https://mediapipe-studio.webapps.google.com/demo/audio_classifier


Get started with just Javascript!!
Getting Started: https://google.github.io/mediapipe/getting_started/javascript.html

Javascript Solutions - Ready to Demo:
1. Face Mesh: https://codepen.io/mediapipe/full/KKgVaPJ
2. Face Detection: https://codepen.io/mediapipe/full/dyOzvZM
3. Hands: https://codepen.io/mediapipe/full/RwGWYJw
4. Face, Hands, Body: https://codepen.io/mediapipe/full/LYRRYEw
5. Objectron: https://codepen.io/mediapipe/full/BaWvzdY
6. Full Skeletal Pose: https://codepen.io/mediapipe/full/jOMbvxw
7. Self Segmentation From Background: https://codepen.io/mediapipe/full/wvJyQpq

Demonstration in Action with Screenshots:

Self Segmentation From Background:
![image](https://user-images.githubusercontent.com/30595158/225767564-786928a3-7c91-4df1-babb-0cc4c2b71460.png)

Full Skeletal Pose:
![image](https://user-images.githubusercontent.com/30595158/225767721-6f088349-3f56-41b3-85d4-98f2456dc165.png)

Hands - Both in 3D Projection even hidden surface vertices - Mahalo:
![image](https://user-images.githubusercontent.com/30595158/225767970-0e1000e8-72a8-4276-a6f0-ccfcd3ac6d72.png)

Holistic - Face, Hands, Body:
![image](https://user-images.githubusercontent.com/30595158/225768092-2cb4a144-7033-46b1-a476-3e0ec376eb36.png)

Face Detection:
![image](https://user-images.githubusercontent.com/30595158/225768256-c97c0f62-6ef9-4c7e-aa41-8eaf4f344a3d.png)

Face Mesh Real Time - 30 Frames per second!
![image](https://user-images.githubusercontent.com/30595158/225768360-c64197ff-919f-47a9-8cc0-c6d5e73e5853.png)



# ASR Voice and Virtual Assistants With Avatars
1. https://huggingface.co/spaces/awacke1/ASR-openai-whisper-large
2. https://huggingface.co/spaces/awacke1/ASR-voidful-wav2vec2-xlsr-multilingual-56
3. https://huggingface.co/spaces/awacke1/ASR-nvidia-stt_en_conformer_ctc_large
4. https://huggingface.co/spaces/awacke1/ASR-facebook-hubert-large-ls960-ft
5. https://huggingface.co/spaces/awacke1/ASR-openai-whisper-tiny.en
6. https://huggingface.co/spaces/awacke1/ASR-openai-whisper-tiny
7. https://huggingface.co/spaces/awacke1/ASR-openai-whisper-medium
8. https://huggingface.co/spaces/awacke1/ASR-nvidia-stt_en_conformer_transducer_xlarge
9. https://huggingface.co/spaces/awacke1/ASR-openai-whisper-base
10. https://huggingface.co/spaces/awacke1/ASR-facebook-wav2vec2-large-960h-lv60-self
11. https://huggingface.co/spaces/awacke1/ASR-facebook-wav2vec2-base-960h
12. https://huggingface.co/spaces/awacke1/ASR-High-Accuracy-Test
13. https://huggingface.co/spaces/awacke1/ASRGenerateStory
14. https://huggingface.co/spaces/awacke1/TTS-STT-Blocks
15. https://huggingface.co/spaces/awacke1/2-LiveASR
16. https://huggingface.co/spaces/awacke1/CloneAnyVoice
17. https://huggingface.co/spaces/awacke1/ASR-SOTA-NvidiaSTTMozilla
18. https://huggingface.co/spaces/awacke1/ASRSpeechRecognition1
19. https://huggingface.co/spaces/awacke1/1110-ASRLiveExample
20. https://huggingface.co/spaces/awacke1/Z1-ASRLiveSpeechRecognition-GR
21. https://huggingface.co/spaces/awacke1/PrivateASRWithMemory
22. https://huggingface.co/spaces/awacke1/TimerASRLive

# Best Voice Apps - HF:
1. https://huggingface.co/spaces/BilalSardar/Voice-Cloning
2. https://huggingface.co/spaces/RamAnanth1/chatGPT_voice
3. https://huggingface.co/spaces/Voicemod/speech-synthesis-demo
4. https://huggingface.co/spaces/ysharma/Voice-to-Youtube
5. https://huggingface.co/spaces/ramkamal2000/voice-conversion-yourtts
6. https://huggingface.co/spaces/RamAnanth1/co_chat_voice
7. https://huggingface.co/spaces/ysharma/Voice-to-jokes
8. https://huggingface.co/spaces/jayesh95/Voice-QA



# Supervised Learning (SL) for ML and Reinforcement Learning with Human Feedback (RLHF):

For human imitation we use reinforcement learning for fine tuning since feedback based on rewards shapes the quality of output where an agent completes a task and then observes a result.  SL works on ranks not responses so is good for modifying elements at the token level however RLHF is trained to estimate the quality of the response with cumulative rewards for coherent conversation.  RLHF considers context and coherence of entire conversation.  Supervised learning is used to teach the model initially where the model learns basic structure and content.  In the RLHF stage the model is refined with responses that represent improved accuracy.





# Mermaid Model for Core NLP Tasks:

```mermaid
graph LR;
    A[Reader]-->B[Classifier];
    A-->C[Retriever];
    A-->D[Summarizer];
    B-->E[Ranker];
    B-->F[Query Classifier];
    D-->G[Generator];
    F-->H[Question Generator];
    H-->G;
    I[File Converter]-->J[Preprocessor];
    J-->A;
    I-->C;
    K[Snowflake]-->B;
    L[Oracle]-->B;
    M[Pandas CSV]-->A;
    N[Index]-->C;
    N-->E;
    O[Query with Filters]-->F;
    P[Evaluation]-->E;
    P-->F;
    Q[Retraining]-->B;
    Q-->E;
    R[Annotation]-->B;
```

# Core NLP Task Model for QA

Tasks:
1. Reader
2. Summarizer
3. Classifier
4. Retriever
5. Ranker
6. Query Classifier
7. Question Generator
8. Generator

Connectors:
1. File Converter
2. Preprocessor
3. Snowflake
4. Oracle
5. Pandas CSV

Supported Workflow:
1. Index
2. Query with Filters
3. Evaluation
4. Retraining
5. Annotation

# QA Model Spaces:

QA use cases include QA, Semantic Document and FAQ Search.

1. Streamlit Question Answering w Hugging Face: https://huggingface.co/spaces/awacke1/Question-answering
2. Seq2Seq:
	- https://huggingface.co/spaces/awacke1/4-Seq2SeqQAT5
	- https://huggingface.co/spaces/awacke1/AW-04-GR-Seq-2-Seq-QA-Auto-Gen
	- 
3. BioGPT: https://huggingface.co/spaces/awacke1/microsoft-BioGPT-Large-PubMedQA
4. NLP QA Context: https://huggingface.co/spaces/awacke1/NLPContextQATransformersRobertaBaseSquad2
	- https://huggingface.co/spaces/awacke1/SOTA-Plan
5.  https://huggingface.co/spaces/awacke1/Question-answering
6.  QA MLM: https://huggingface.co/spaces/awacke1/SOTA-MedEntity

# 🤖 QA Models and Datasets:

- Reader model extracts answers from text using QA pairs. SQuAD is the primary dataset.
- Transformers (huggingface) has research momentum and solves real business problems.

## 💻 Process:

1. Best practices for QA systems: https://www.youtube.com/playlist?list=PLHgX2IExbFotW6WgDZ-cMzpDBUNKCMBbF
2. Optimize Question/Answer Heads for SQuAD.
3. QA search to ask questions to textual kb.
4. Return text sections as answers.
5. Organize text collection.
6. Find similar documents to given input.
7. Perform semantic and comprehensive word matching.
8. Match incoming questions to FAQ KB dataset.

## 📋 Tasks:

1. Visual, 
2. Document, and 
3. Table QA.
4. Zero Shot Classification.
5. Translation.
6. Conversational/Chat.
7. Text2Text Generation.
8. ASR/TTS.

# Mermaid model

```mermaid
graph LR;
    A[Reader model]-->B[SQuAD];
    C[Transformers from Huggingface]-->D[Real Business Problems];
    E[Best practices for QA systems]-->F[Optimize Question/Answer Heads for SQuAD];
    G[QA search]-->H[Textual KB];
    H-->I[Return text sections as answers];
    J[Organize text collection]-->K[Find similar documents to given input];
    K-->I;
    L[Perform semantic and comprehensive word matching]-->I;
    M[Match incoming questions to FAQ KB dataset]-->I;
    N[Visual QA]-->O[Document QA];
    N-->P[Table QA];
    Q[Zero Shot Classification]-->I;
    R[Translation]-->I;
    S[Conversational/Chat]-->I;
    T[Text2Text Generation]-->I;
    U[ASR/TTS]-->I;

```

# Top 50 Assessments in Physical and Mental Health

Below are the top 50 mental and physical health assessments.
1. **Patient Health Questionnaire (PHQ-9)** 🧠 - Major depressive disorder (ICD-10: F32)
2. **Generalized Anxiety Disorder 7-item Scale (GAD-7)** 😰 - Generalized anxiety disorder (ICD-10: F41.1)
3. **Hamilton Rating Scale for Depression (HRSD)** 🧠 - Major depressive disorder (ICD-10: F32)
4. **World Health Organization Disability Assessment Schedule 2.0 (WHODAS 2.0)** 🧠💪 - Physical and mental disability (ICD-10: Z73.1)
5. **Short Form-36 Health Survey (SF-36)** 💪🧠 - Health-related quality of life (CPT: 99499)
6. **Health Assessment Questionnaire (HAQ)** 💪 - Functional status assessment (CPT: 97750)
7. **EuroQol-5D (EQ-5D)** 💪🧠 - Health-related quality of life (LOINC: 83792-6)
8. **Geriatric Depression Scale (GDS)** 🧑‍🦳🧠 - Depression in older adults (ICD-10: F32.1)
9. **Mini-Mental State Examination (MMSE)** 🧑‍🦳💭 - Cognitive impairment (ICD-10: F06.7)
10. **Pain Catastrophizing Scale (PCS)** 💔 - Chronic pain (LOINC: 86351-6)
11. **Oswestry Disability Index (ODI)** 💪💔 - Back pain (CPT: 97750)
12. **Fibromyalgia Impact Questionnaire (FIQ)** 💔😩 - Fibromyalgia (SNOMED: 316962002)
13. **Beck Depression Inventory (BDI)** 🧠 - Depression (ICD-10: F32)
14. **Posttraumatic Stress Disorder Checklist (PCL)** 😰😞 - Posttraumatic stress disorder (ICD-10: F43.1)
15. **Alcohol Use Disorders Identification Test (AUDIT)** 🍻 - Alcohol use disorder (ICD-10: F10)
16. **Drug Abuse Screening Test (DAST)** 💊 - Substance use disorder (ICD-10: F19)
17. **Eating Attitudes Test (EAT)** 🍴 - Eating disorders (ICD-10: F50)
18. **Adolescent Eating Disorder Examination (ADE)** 🍴👩‍🦰 - Eating disorders in adolescents (ICD-10: F50)
19. **Child Behavior Checklist (CBCL)** 👧🧒 - Child behavior problems (ICD-10: F90)
20. **Autism Spectrum Quotient (AQ)** 🧑‍🦱 - Autism spectrum disorder (ICD-10: F84.0)
21. **Columbia-Suicide Severity Rating Scale (C-SSRS)** 🩸 - Suicide risk (ICD-10: Z65.8)
22. **Perceived Stress Scale (PSS)** 😩 - Stress (LOINC: 75217-3)
23. **Satisfaction with Life Scale (SWLS)** 😊 - Life satisfaction (LOINC: 69406-9)
24. **Health Belief Model Scale (HBM)** 💊💉 - Health beliefs (LOINC: 88018)
25. **Multidimensional Health Locus of Control Scale (MHLC)** 💊💉 - Health locus of control (LOINC: 87561-7)
26. **Life Orientation Test-Revised (LOT-R)** 😃 - Optimism (LOINC: 75315-5)
27. **State-Trait Anxiety Inventory (STAI)** 😰 - Anxiety (LOINC: 71092-3)
28. **Multidimensional Scale of Perceived Social Support (MSPSS)** 👥 - Social support (LOINC: 86649-4)
29. **Job Content Questionnaire (JCQ)** 💼 - Job stress (LOINC: 76554-9)
30. **Burnout Measure (BO)** 🔥 - Burnout (LOINC: 89049-8)
31. **Family Assessment Device (FAD)** 👨‍👩‍👧 - Family functioning (LOINC: 84113-2)
32. **Perceived Control Scale (PCS)** 💪 - Perceived control (LOINC: 86447-0)
33. **General Self-Efficacy Scale (GSES)** 💪 - Self-efficacy (LOINC: 76563-0)
34. **Coping Strategies Inventory (CSI)** 😓 - Coping strategies (LOINC: 89057-1)
35. **Acceptance and Action Questionnaire (AAQ-II)** 🧘 - Acceptance and commitment therapy (LOINC: 88027-2)
36. **Attention Deficit Hyperactivity Disorder Self-Report Scale (ASRS)** 👧🧒 - ADHD (ICD-10: F90)
37. **Impact of Event Scale-Revised (IES-R)** 😔😞 - Trauma (LOINC: 86237-7)
38. **Insomnia Severity Index (ISI)** 💤 - Insomnia (LOINC: 82451-5)
39. **Social Phobia Inventory (SPIN)** 😰 - Social anxiety disorder (ICD-10: F40.1)
40. **Panic Disorder Severity Scale (PDSS)** 😰 - Panic disorder (ICD-10: F41.0)
41. **Yale-Brown Obsessive Compulsive Scale (Y-BOCS)** 🤔 - Obsessive-compulsive disorder (ICD-10: F42)
42. **Social Interaction Anxiety Scale (SIAS)** 😰 - Social anxiety disorder (ICD-10: F40.1)
43. **Generalized Anxiety Disorder Scale (GADS)** 😰 - Generalized anxiety disorder (ICD-10: F41.1)
44. **Postpartum Depression Screening Scale (PDSS)** 🤱🧠 - Postpartum depression (ICD-10: F53.0)
45. **Child and Adolescent Symptom Inventory (CASI)** 👧🧒🧠 - Child and adolescent mental health (ICD-10: F90)
46. **Strengths and Difficulties Questionnaire (SDQ)** 👧🧒🧠 - Child and adolescent mental health (ICD-10: F90)
47. **Kessler Psychological Distress Scale (K10)** 🧠 - Psychological distress (LOINC: 76550-6)
48. **World Health Organization Quality of Life Scale (WHOQOL)** 💪🧠 - Quality of life (LOINC: 88055-2)
49. **Multidimensional Pain Inventory (MPI)** 💔 - Chronic pain (LOINC: 71808-8)
50. **Cornell Scale for Depression in Dementia (CSDD)** 👴👵🧠 - Depression in dementia patients (ICD-10: F03.90)


# SMART/FHIR/SDC Survey-Assess-Plan

These SMART/FHIR/SDC compatible Surveys demonstrate how to build and conducct surveys with EMR/EHR Compliance Standards

1. Smart FHIR Connect and Test BMI Calculator: https://huggingface.co/spaces/awacke1/SMART-FHIR-Assessment-BMI
2. Smart FHIR Kits SDC HL7: https://huggingface.co/spaces/awacke1/SMART-FHIR-Kits-SDC-HL7
3. Smart FHIR Assessment Exercise: https://huggingface.co/spaces/awacke1/SMART-FHIR-Assessment-Exercise
4. Smart FHIR Assessment Blood Pressure: https://huggingface.co/spaces/awacke1/SMART-FHIR-Assessment-Blood-Pressure
5. Smart FHIR - Observations-Assessments-Rules-Referrals-Providers-Programs-Fulfillment-Alerrts-Notes-SDOH: https://huggingface.co/spaces/awacke1/SMART-FHIR-Assessment-Observation-SDKs


# Graphs Survey-Assess-Plan-Goals

These top 5 graph examples introduce visual ideas to use to survey, assess, plan and reach goals.

1. Graph OMS and LOCUS Standards and Quality Metrics: https://huggingface.co/spaces/awacke1/NLPGraphOMSandLOCUS
2. Graph Pain and High Medium Low Confidence: https://huggingface.co/spaces/awacke1/VISNLP-Graph
3. Graph Action Mechanics: https://huggingface.co/spaces/awacke1/CardGameActivity-GraphViz
4. Graph - OMS, MH, Charts, Maps, DOT lang for Pyvis VisJS: https://huggingface.co/spaces/awacke1/CPVisGraph
5. Graph - Plan and Assess: https://huggingface.co/spaces/awacke1/Git-GPG-Git-Actions-01-GraphViz

# ICD10, CPT, LOINC, SNOMED, HCPCS, OMS Codes for Top Health Conditions and Treatment Preferences Assessment

Assess Topic| Assess Metric | Code Emoji | Code Topic | Code Type  |  Code	
------------|---------------|------------|------------|------------|-----------
Childhood Immunization| % of children immunized by age two |🧒💉 | Clinical Code| ICD10 | Z28.2
Breast Cancer Screening| % of women with mammogram in past 2 yrs |🩺🎀 | Clinical Code| CPT| 77067
Colorectal Cancer Screening| % of adults screened for colorectal cancer| 🩺💩 | Clinical Code| CPT| 82274
Comprehensive Diabetes Care| % of diabetic patients who had all recommended tests| 🩺🩹 | Clinical Code| LOINC| 4548-4
Controlling High Blood Pressure| % of patients with controlled blood pressure| 🩺💊 | Clinical Code| ICD10|I10
Medication Management for Asthma| % of asthma patients with proper meds| 💊🌬️ | Clinical Code| SNOMED|195967001
Follow-up After Mental Illness Hospitalization| % of patients with follow-up care| 🩺🏥 | Clinical Code| HCPCS|G0181
Prenatal & Postpartum Care| % of pregnant women with proper care |🤰🩺 | Clinical Code| ICD10|Z34
Comprehensive Eye Exam| % of diabetic patients with eye exam |🩺👀 | Clinical Code| CPT| 92014
Childhood Weight Assessment| % of children with BMI assessment |🧒📏 | Clinical Code| ICD10| Z00.121
Chlamydia Screening in Women| % of sexually active women screened| 🩺👩 | Clinical Code| CPT|87491
Avoidance of Antibiotic Treatment for Acute Bronchitis| % of patients without antibiotics |🩺💊 | Clinical Code| ICD10|J20.9
Osteoporosis Management in Women|% of women with bone density test |🩺💪 | Clinical Code| CPT|77080
Use of High-Risk Medications in the Elderly| % of elderly with safe meds |💊👴👵 | Clinical Code| HCPCS |G9612
Diabetes Screening for Schizophrenia or Bipolar Disorder| % of patients with mental illness screened |🧠🩺 | Clinical Code| SNOMED| 169609005
All-Cause Readmissions| % of patients readmitted within 30 days |🩺🏥 | Clinical Code| ICD10| Z51.5
Antidepressant Medication Management| % of depressed patients with proper meds & follow-up |🩺🧠 | Clinical Code| CPT|96127
Follow-up Care for Children Prescribed ADHD Medication|% of children with follow-up care |🩺🧒 | Clinical Code| ICD10|F90
Imaging Studies for Low Back Pain| % of patients without imaging studies|🩺📊 | Clinical Code| ICD10|M54.5
Spirometry Testing for COPD|% of COPD patients with spirometry testing |🩺🫁 | Clinical Code|CPT|94010


""")