import gradio as gr
from spleeter.separator import Separator
from spleeter.audio.adapter import AudioAdapter
import spleeter.utils.logging as logging
import parselmouth
import numpy as np
import matplotlib.pyplot as plt
import seaborn as sns
import time
from matplotlib import rcParams
from you_get import common


#主程序
def main(audio,bg_time,ed_time):
    #分离音频
    vocals=spleeter(audio,bg_time,ed_time)
    #音高标记
    plt=pitch_mark(vocals)
    #返回音高标记图像
    return [plt,vocals]

#时间检查
def time_check(bg_time,ed_time):
    #当两者都为整数且ed_time>bg_time时返回True
    if bg_time.isdigit() and ed_time.isdigit():
        if int(ed_time)>int(bg_time):
            return True
    return False

#音频分离
def spleeter(audio,bg_time,ed_time):
    #分离音频并保存
    separator = Separator('spleeter:2stems')
    if time_check(bg_time,ed_time):
        waveform=AudioAdapter.default().load_tf_waveform(audio,offset=int(bg_time), duration=int(ed_time)-int(bg_time))['waveform']
    else:
        waveform=AudioAdapter.default().load_tf_waveform(audio)['waveform']
    vocals = separator.separate(waveform)['vocals']
    #返回Tuple,格式[sample_rate, numpy array] 
    return (44100,vocals)

#音高标记
#计算标准音高和频率
def frequency(pitch):
    return 16.35 * 2 ** (pitch /12 )
def generate_array(min_pitch, max_pitch):
    array = []
    names = ["C", "C#", "D", "D#", 
             "E", "F", "F#", 
             'G', 'G#', 'A', 'A#', 'B']

    for pitch in range(120):
        freq = frequency(pitch)
        name = names[pitch % 12] + str(pitch // 12)
        if frequency(pitch+1) > min_pitch and frequency(pitch-1) < max_pitch:
            array.append([name, freq])
    return array

def pitch_mark(wav):
    config = {
    "font.family":'serif',
    "font.size": 8
    }
    sns.set()
    rcParams.update(config)

    wav = wav[1][:, 0] 
    snd = parselmouth.Sound(wav)
    pitch = snd.to_pitch(pitch_floor=50, pitch_ceiling=3000)
    plt.figure(figsize=(15,8),dpi=144)

    pitch_values = pitch.selected_array['frequency']
    #异常值修改为0
    pitch_values[pitch_values>np.nanpercentile(pitch_values, 99)] = np.nan
    pitch_values[pitch_values<np.nanpercentile(pitch_values, 1)] = np.nan
    pitch_values[pitch_values==0] = np.nan

    min_pitch = np.nanmin(pitch_values)
    max_pitch = np.nanmax(pitch_values)

    #绘制音高散点

    plt.plot(pitch.xs(), pitch_values, 'o', markersize=3, color='w')
    plt.plot(pitch.xs(), pitch_values, 'o', markersize=1.5)

    #绘制标准音高
    array = generate_array(min_pitch, max_pitch)
    for name, freq in array:
        plt.axhline(y=freq, color='blue', ls='-', lw=0.5)
        plt.text(snd.xmax, freq, name, fontsize=8, ha='right', va='center', alpha=0.6)
    plt.ylim(min_pitch-20, max_pitch+20)
    plt.xlabel('Time [s]')
    plt.xlim([snd.xmin, snd.xmax])
    #时间戳生成唯一文件名
    timestamp = int(time.time())
    plt.savefig(str(timestamp)+'.png')
    return str(timestamp)+'.png'
#u-get
def uget(url):
    file_name=(int)(time.time())
    common.output_filename = file_name
    common.any_download(url,output_dir='.',merge=True)
    return str(file_name)+'.mp4'
#css
css="""
#main{
    background-color: #ffffff;
    opacity: 0.8;
    background-image:  repeating-linear-gradient(45deg, #edffe1 25%, transparent 25%, transparent 75%, #edffe1 75%, #edffe1), repeating-linear-gradient(45deg, #edffe1 25%, #ffffff 25%, #ffffff 75%, #edffe1 75%, #edffe1);
    background-position: 0 0, 40px 40px;
    background-size: 80px 80px
}
#box{
    margin-top: 45px;
}
"""

#gradio
with gr.Blocks(css=css) as app:
    gr.HTML("""<h1 style="display: inline-block;">音准测试</h1>
<h3 style="display: inline-block;margin-left: 10px;">🛠一个音准测量工具</h3>
<div style="font-size: 12.5px;border: 1px dotted aqua;border-radius: 12px;padding: 5px;padding-left: 20px;background-color: aliceblue;">
    <div>
        <p>📒使用说明</p>
        <ol style="padding-left: 20px">
            <li>在下方上传音频/视频文件，或使用在线视频链接，输入需要分析的音频</li>
            <li>点击“音准测试”按钮，生成音高图，右侧同时输出提取人声后的音频</li>
            <li>输入开始和结束时间可以截取部分音频分析</li>
        </ol>
    </div>
    <div>
        <p>📝注意:10s音频分析时间不会超过30s，如卡住不动或出现error请尝试刷新</p>
    </div>
</div>
            """)
    with gr.Row():
        with gr.Column():
            with gr.Tabs():
                with gr.Tab("音频文件"):
                    audio = gr.Audio(type="filepath", label="音频文件")
                    btn_a=gr.Button("🎵音准测试")
                with gr.Tab("视频文件"):
                    video = gr.Video(type="filepath", label="视频文件")
                    btn_b=gr.Button("🎦音准测试")
                
        with gr.Column():
            with gr.Box(elem_id="box"):
                gr.HTML("""<p style="padding:0 px;margin:0 px;margin-top:10 px;font-size: 12.5px;color: gray;">📅开始时间和结束时间,直接输入数字，单位为s，不填默认为全长  <b>建议长度为10秒</b></p>""")
                with gr.Row():
                    bg_time = gr.Textbox(type="text",label="开始时间")
                    ed_time = gr.Textbox(type="text",label="结束时间")
            with gr.Box():
                audio_output = gr.Audio(type="numpy", label="提取结果")
    output_img=gr.Image(type="filepath", label="音准匹配图")
    btn_a.click(main, [audio,bg_time,ed_time], [output_img,audio_output])
    btn_b.click(main, [video,bg_time,ed_time], [output_img,audio_output])
    gr.HTML("""
    <div align=center >
        <p style="font-size: 10px;color:gray">😃Credit:人声提取：<a href="https://github.com/deezer/spleeter">Spleeter</a> 音高标注：<a href="https://github.com/YannickJadoul/Parselmouth">Parselmouth</a>
            网络视频获取：<a href="https://github.com/soimort/you-get">You-get</a> 方法来源：<a href="https://space.bilibili.com/245645656">码农高天</a>
        </p>
        <div align=center><img id="visitor-badge" alt="visitor badge" src="https://visitor-badge.laobi.icu/badge?page_id=AGITM/ToneCorrectionRecognition" /></div>
    </div>""")

app.launch()