import gradio as gr
import requests
import random
import json
def response(message, history, model, prompt_type):
  url="https://afischer1985-OpenHermes-2-GGUF-API.hf.space/v1/completions"
  endstr="<|im_end|>"
  print(model)
  if(model=="WizardLM-13B"): 
      url="https://wizardlm-13b-v1-2-q4-0-gguf.hf.space/v1/completions"  
      if(prompt_type=="Default"): prompt_type="Vicuna"
  if(model=="SauerkrautLM-7B"): 
      url="https://SauerkrautLM-GGUF-API.hf.space/v1/completions"  
      if(prompt_type=="Default"): prompt_type="Vicuna (German)"
  if(model=="OpenHermes2-7B"): 
      url="https://AFischer1985-CollectiveCognition-GGUF-API.hf.space/v1/completions"
      if(prompt_type=="Default"): prompt_type="ChatML"
  if(model=="CollectiveCognition-7B"): 
      url="https://AFischer1985-CollectiveCognition-GGUF-API.hf.space/v1/completions"  
      if(prompt_type=="Default"): prompt_type="ChatML" 
  print(prompt_type)
  if(prompt_type=="ChatML"):
      body={"prompt":"<|im_start|>system\nYou are a helpful AI-Assistant.<|im_end|>\n<|im_start|>user\n"+message+"<|im_end|>\n<|im_start|>assistant","max_tokens":1000,"stop":"<|im_end|>","stream":True}
  if(prompt_type=="ChatML (German)"):
      body={"prompt":"<|im_start|>system\nDu bist ein KI-basiertes deutschsprachiges Assistenzsystem.<|im_end|>\n<|im_start|>user"+message+"<|im_end|>\n<|im_start|>assistant","max_tokens":1000,"stop":"<|im_end|>","stream":True}
  if(prompt_type=="Alpaca"):
      body={"prompt":"###Instruction:\n"+message+"\n\n###Resonse:\n","max_tokens":1000,"stop":"###","stream":True}
  if(prompt_type=="Vicuna"):
      body={"prompt":"A chat between a curious user and an artificial intelligence assistant. The assistant gives helpful, detailed, and polite answers to the user's questions. USER: "+message+" ASSISTANT:","max_tokens":1000,"stop":"USER:","stream":True}
  if(prompt_type=="Vicuna (German)"):
      body={"prompt":"Ein Chat zwischen einem Benutzer und einem KI-Assistenten. Der KI-Assistent gibt hilfreiche, detaillierte und höfliche Antworten.\nUser: "+message+"\nAssistant: ","max_tokens":1000,"stop":"User:","stream":True}
  response=""
  buffer=""
  print(str(body))
  print("User: "+message+"\nAI: ")
  for text in requests.post(url, json=body, stream=True):  
    #print("*** Raw String: "+str(text)+"\n***\n")
    text=text.decode('utf-8')
    if(text.startswith(": ping -")==False):buffer=str(buffer)+str(text)
    #if(text.startswith(": ping -")): print("\n*** PIacNG!\n***\n")
    #print("\n*** Buffer: "+str(buffer)+"\n***\n") 
    buffer=buffer.split('"finish_reason"')
    if(len(buffer)==1):
      buffer="".join(buffer)
      pass
    if(len(buffer)==2):
      part=buffer[0]+'"finish_reason": null}]}'  
      if(part.startswith("data: ")):part=part.replace("data: ", "")
      try: 
        part = str(json.loads(part)["choices"][0]["text"])
        print(part, end="", flush=True)
        response=response+part
        buffer="" # reset buffer
      except:
        pass
    yield response 

gr.ChatInterface(response,additional_inputs=[gr.Dropdown(["CollectiveCognition-7B", "OpenHermes2-7B"],value="OpenHermes2-7B",label="Model"),gr.Dropdown(["Default", "ChatML","ChatML (German)","Vicuna","Vicuna (German)","Alpaca"],value="Default",label="Prompt Type")]).queue().launch(share=True) 