#!/usr/bin/env python
# coding: utf-8

import subprocess

# Define the command you want to run
command = 'pip install --no-cache-dir gradio==3.26.0'

# Use subprocess to run the command
try:
    subprocess.check_call(command, shell=True)
    print("Installation successful!")
except subprocess.CalledProcessError as e:
    print(f"Installation failed with error: {e}")

import pandas as pd
import numpy as np
import tensorflow as tf
from tensorflow.keras.preprocessing.text import Tokenizer
from sklearn.preprocessing import OneHotEncoder
import gradio as gr
from gradio import components

print("\n\n\n****************************>>>>>>>>>  GRADIO VERSION: ",gr.__version__,"\n\n\n")

model = tf.keras.models.load_model("NCM_DEMO.H5", compile=False)

ncm_table = pd.read_csv("https://raw.githubusercontent.com/mfilipak/AFRAC_IA/main/DATASET/TABELA_NCM.CSV", index_col="CODIGO")
valid_ncms = sorted(ncm_table[ncm_table.index > 1000000].index)
ncmst = np.array(valid_ncms)
ncmst = ncmst.reshape([-1,1])
ohe = OneHotEncoder()
ohe.fit(ncmst)

tk = Tokenizer(num_words=None, char_level=True, oov_token='UNK')
tk.word_index = {'UNK': 1, ' ': 2, 'a': 3, 'o': 4, 'e': 5, 'r': 6, 'i': 7, 'c': 8, 'l': 9, 's': 10, 't': 11, 'n': 12, 'm': 13, '0': 14, 'p': 15, 'g': 16, 'd': 17, 'u': 18, 'b': 19, '1': 20, 'f': 21, 'h': 22, '2': 23, '5': 24, 'v': 25, '3': 26, 'k': 27, '4': 28, '.': 29, 'x': 30, '6': 31, '8': 32, '-': 33, '7': 34, '9': 35, 'j': 36, 'z': 37, '/': 38, 'y': 39, 'q': 40, 'w': 41, ',': 42, ':': 43, '(': 44, ')': 45, '_': 46, '#': 47, '+': 48, '*': 49, '%': 50, '"': 51, "'": 52, 'ç': 53, '&': 54, 'ã': 55, ';': 56, ']': 57, '[': 58, '$': 59, 'á': 60, '\\': 61, '|': 62, 'é': 63, 'º': 64, 'ó': 65, '!': 66, '=': 67, 'í': 68, 'ê': 69, '?': 70, '>': 71, '@': 72, '¿': 73, '°': 74, 'ú': 75, '\xa0': 76, 'ô': 77, 'â': 78, '`': 79, 'à': 80, 'õ': 81, 'ï': 82, 'ª': 83, '²': 84, '{': 85, '<': 86, '~': 87, 'è': 88, '§': 89, 'ø': 90, 'ñ': 91, '³': 92, 'û': 93, 'ù': 94, '\xad': 95, '}': 96, '\x81': 97, 'ä': 98, 'ü': 99, '¶': 100, '^': 101, '€': 102, '¹': 103, 'µ': 104, '®': 105, '¡': 106}

def PredictNCM(txt):
    x = [txt[:120].lower() ]

    print(txt)

    X = np.array(tk.texts_to_sequences([_+(120-len(_))*" " for _ in x]))
    pred = model.predict(X, verbose=0)[0]
    aux = np.argsort(pred)[::-1][:5]
    return {f"{int(valid_ncms[i]):08}":float(pred[i]) for i in aux}, ncm_table.loc[valid_ncms[aux[0]],"DESCRICAO"]


demo = gr.Interface(fn=PredictNCM, outputs=[components.Label(label="NCMs"), components.Textbox(label="Descrição do NCM")], title='AFRAC NOTA CERTA', 
                    inputs=components.Textbox(label="DESCRIÇÃO"),
                   examples=["Coca-Cola PET 2l","Pepsi 500ml", "Guaraná Antarctica 2l", "Ração Bocão Premium","Mentos Kiss Morango", "Bombom Sonho de Valsa"])
demo.launch()
#display(demo.launch(share=True))
#demo.close()

