from collections import Counter
import gradio as gr
from sklearn.cluster import KMeans
from matplotlib import colors
import matplotlib.pyplot as plt
import numpy as np
import cv2
import imageio
import cv2
from skimage.color import rgb2lab, deltaE_cie76
from collections import Counter
import os 
import scipy.ndimage as ndi
#from google.colab.patches import cv2_imshow
def figplota(xvalues):
  fig = plt.figure()
  plt.plot(xvalues, figure=fig)
  plt.xlabel("Pixels")
  plt.ylabel("Intensity Value")
  plt.title("Histogram of pixel intensities distribution")
  return fig
def figplotpie(xvalues,yvalues,zvalues):
  fig = plt.figure()
  plt.pie(xvalues, labels = yvalues, colors = zvalues)
  plt.title("Pie chart of top 10 HEX colors")
  return fig
def figplotb(xvalues,yvalues):
  fig = plt.figure()
  if len(xvalues)>len(yvalues):
    plt.stem(xvalues[:len(yvalues)],(((yvalues))))
  else:
    plt.stem(xvalues,(((yvalues[:len(xvalues)]))))
  plt.xlabel("Wavelength (nm) ")
  plt.ylabel("Intensity Value")
  plt.title("Intensity")
  return fig
def RGB_HEX(color):
  return "#{:02x}{:02x}{:02x}".format(int(color[0]), int(color[1]), int(color[2])) 
def get_colors(image, number_of_colors, show_chart):
    reshaped_image = cv2.resize(image, (600, 400))
    reshaped_image = reshaped_image.reshape(reshaped_image.shape[0]*reshaped_image.shape[1], 3)
    clf = KMeans(n_clusters = number_of_colors)
    labels = clf.fit_predict(reshaped_image)
    counts = Counter(labels)
    counts = dict(sorted(counts.items()))
    center_colors = clf.cluster_centers_
    ordered_colors = [center_colors[i] for i in counts.keys()]
    hex_colors = [RGB_HEX(ordered_colors[i]) for i in counts.keys()]
    rgb_colors = [ordered_colors[i] for i in counts.keys()]
    if (show_chart):
        plt.figure(figsize = (8, 6))
        plt.pie(counts.values(), labels = hex_colors, colors = hex_colors)
    return rgb_colors
def perc(imageinput,cl):
  image =  cv2.imread(imageinput)

  targetcolor = list(cl)
  diff = 20
  boundaries = [([targetcolor[2], targetcolor[1]-diff, targetcolor[0]-diff],
            [targetcolor[2]+diff, targetcolor[1]+diff, targetcolor[0]+diff])]
  scalePercent = 0.3

  width = int(image.shape[1] * scalePercent)
  height = int(image.shape[0] * scalePercent)
  newSize = (width, height)
  image = cv2.resize(image, newSize, None, None, None, cv2.INTER_AREA)
  for (lower, upper) in boundaries:
      lower = np.array(lower, dtype=np.uint8)
      upper = np.array(upper, dtype=np.uint8)
      mask = cv2.inRange(image, lower, upper)
      output = cv2.bitwise_and(image, image, mask=mask)
      ratio_targetcolor = cv2.countNonZero(mask)/(image.size/3)
      colorPercent = (ratio_targetcolor * 100) / scalePercent

  return colorPercent,output
def quant(imageinput,imageinput2):

  
  image =  cv2.imread(imageinput)

  hist=ndi.histogram(image, min=0,max=255,bins=256)
  hist.shape
  plt.plot(hist)
  plt.show()


  BGR2RGB = cv2.cvtColor(image, cv2.COLOR_BGR2RGB)
  gray = cv2.cvtColor(BGR2RGB, cv2.COLOR_RGB2GRAY)
  hsv = cv2.cvtColor(image, cv2.COLOR_RGB2HSV)
  R=np.mean(image[ : , : , 0])
  G=np.mean(image[ : , : , 1])
  B=np.mean(image[ : , : , 2])
 

  xy=get_colors(BGR2RGB, 10, True)
  import colorsys
  d=xy[0]
  HSVc=colorsys.rgb_to_hsv(round(d[0]), round(d[1]), round(d[2])) #intensity
  intensity =str("Intensity of Dominant Color in control sample is: " + str(HSVc[2]))
  wavel=str("Highest wavelength of Dominant Color in control sample is: " + str(650 - 250 / 270 * HSVc[0]))
  image2 =cv2.imread(imageinput2)


  hist2=ndi.histogram(image2, min=0,max=255,bins=256)
  hist2.shape
  plt.plot(hist2)
  plt.show()


  BGR2RGB2 = cv2.cvtColor(image2, cv2.COLOR_BGR2RGB)
  gray2 = cv2.cvtColor(BGR2RGB2, cv2.COLOR_RGB2GRAY)
  hsv2 = cv2.cvtColor(image2, cv2.COLOR_RGB2HSV)
  R2=np.mean(image2[ : , : , 0])
  G2=np.mean(image2[ : , : , 1])
  B2=np.mean(image2[ : , : , 2])
  xy2=get_colors(BGR2RGB2, 10, True)
  reshaped_image = cv2.resize(BGR2RGB, (600, 400))
  reshaped_image = reshaped_image.reshape(reshaped_image.shape[0]*reshaped_image.shape[1], 3)
  clf = KMeans(n_clusters = 10)
  labels = clf.fit_predict(reshaped_image)
  counts = Counter(labels)
  counts = dict(sorted(counts.items()))
  center_colors = clf.cluster_centers_
  ordered_colors = [center_colors[i] for i in counts.keys()]
  hex_colors = [RGB_HEX(ordered_colors[i]) for i in counts.keys()]
  rgb_colors = [ordered_colors[i] for i in counts.keys()]
  plt.figure(figsize = (8, 6))
  plt.pie(counts.values(), labels = hex_colors, colors = hex_colors)
  reshaped_image2 = cv2.resize(BGR2RGB2, (600, 400))
  reshaped_image2 = reshaped_image2.reshape(reshaped_image2.shape[0]*reshaped_image2.shape[1], 3)
  clf = KMeans(n_clusters = 10)
  labels2 = clf.fit_predict(reshaped_image2)
  counts2 = Counter(labels2)
  counts2 = dict(sorted(counts2.items()))
  center_colors2 = clf.cluster_centers_
  ordered_colors2 = [center_colors2[i] for i in counts2.keys()]
  hex_colors2 = [RGB_HEX(ordered_colors2[i]) for i in counts2.keys()]
  rgb_colors2 = [ordered_colors2[i] for i in counts2.keys()]
  plt.figure(figsize = (8, 6))
  plt.pie(counts2.values(), labels = hex_colors2, colors = hex_colors2)
  import colorsys
  d2=xy2[0]
  HSVc2=colorsys.rgb_to_hsv(round(d2[0]), round(d2[1]), round(d2[2])) #intensity
  intensity2 =str("Intensity of Dominant Color in test sample is:" + str(HSVc2[2]))
  wavel2=str("Highest wavelength of Dominant Color in test sample is:" + str(650 - 250 / 270 * HSVc2[0]))
  o=[]
  for i in range(1,len(xy)+1):
    o.append(perc(imageinput,xy[i-1])[0])
  g=o.index((max(o)))
  o2=[]
  for i in range(1,len(xy2)+1):
    o2.append(perc(imageinput2,xy2[i-1])[0])
  g2=o2.index((max(o2)))
  hsvv = cv2.cvtColor(perc(imageinput,(xy[g]))[1], cv2.COLOR_RGB2HSV)
  hsvv2 = cv2.cvtColor(perc(imageinput2,(xy2[g2]))[1], cv2.COLOR_RGB2HSV)
  HUE= hsvv[ : , : , 0] #hsv
  value= hsvv[ : , : , 2]
  valueq=[]
  for i in range(0,value.shape[0]):
    for j in range(1,value[i].shape[0]):
      valueq.append(value[i,j])
  Qt=[i for i in valueq]
  valueh=[]
  for i in range(0,HUE.shape[0]):
    for j in range(1,HUE[i].shape[0]):
      valueh.append(HUE[i,j])
  hh=[i for i in valueh]
  wv=[]
  wv=[650 - 250 / 270 * i for i in hh]
  #wv=np.reshape(wv, (2, 3))
  wv=list(dict.fromkeys(wv))
  Q=list(dict.fromkeys(Qt))
  import matplotlib as mpl
  mpl.rcParams['agg.path.chunksize'] = 10000
  from scipy.signal import savgol_filter
  Q = [i for i in Q if i != 0]
  mn=min(Q)
  mx=max(Q)
  Q=[((i-mn)/(mx-mn)) for i in Q]
  if len(wv)>len(Q):
    plt.stem(wv[:len(Q)],(((Q))))
  else:
    plt.stem(wv,(((Q[:len(wv)]))))
  plt.xlabel("Wavelength (nm) ")
  plt.ylabel("Intensity Value")
  plt.title("Intensity")
  #plt.ylim([-1, 1])
  #plt.xlim([-1, 600])
  plt.show()

  HUE2= hsvv2[ : , : , 0] #hsv
  value2= hsvv2[ : , : , 2]
  valueq2=[]
  for i in range(0,value2.shape[0]):
    for j in range(1,value2[i].shape[0]):
      valueq2.append(value2[i,j])
  Qt2=[i for i in valueq2]



  valueh2=[]
  for i in range(0,HUE2.shape[0]):
    for j in range(1,HUE2[i].shape[0]):
      valueh2.append(HUE2[i,j])
  hh2=[i for i in valueh2]

  wv2=[]
  wv2=[650 - 250 / 270 * i for i in hh2]
  #wv=np.reshape(wv, (2, 3))
  wv2=list(dict.fromkeys(wv2))
  Q2=list(dict.fromkeys(Qt2))



  #from outliers import is_outlier
  #filtered = wv[~is_outlier(wv)]
  Q2 = [i for i in Q2 if i != 0]
  #norm2 = np.linalg.norm(Q2)
  #Q2 = Q2/norm2
  mn=min(Q2)
  mx=max(Q2)
  Q2=[((i-mn)/(mx-mn)) for i in Q2]

  if len(wv2)>len(Q2):
    plt.stem(wv2[:len(Q2)],(((Q2))))
  else:
    plt.stem(wv2,(((Q2[:len(wv2)]))))
  plt.xlabel("Wavelength (nm) ")
  plt.ylabel("Intensity Value")
  plt.title("Intensity")
  plt.show()
  colorperc=str("Dominant Color percentage in control sample is: " +str(perc(imageinput,xy[g])[0]))
  colorperc2=str("Dominant Color percentage in test sample is: " +str(perc(imageinput2,xy2[g2])[0]))
  ratio = float(cv2.meanStdDev(np.array(wv2))[0] / cv2.meanStdDev(np.array(wv))[0])
  colorperc3=str("Percentage of control sample Dominant Color within test image is: " +str(perc(imageinput2,xy[g])[0])+" and test wavelength range covers "+str(ratio)+" of control's wavelength coverage")
  
  return (colorperc),colorperc2,colorperc3,(intensity),(intensity2),wavel,wavel2,figplota(hist),figplota(hist2),figplotb(wv,Q),figplotb(wv2,Q2) ,  figplotpie(counts.values(), hex_colors, hex_colors), figplotpie(counts2.values(),  hex_colors2,  hex_colors2)
iface  = gr.Interface(quant, inputs=[gr.Image(type="filepath"),gr.Image(type="filepath")],  outputs=["text","text","text","text","text","text","text","plot","plot","plot","plot","plot","plot"],debug=True)
iface.launch(debug=True)