import gradio as gr
import requests

def interact_with_server(prompt):
    server_url = "http://xzyorb.servemp3.com:80"
    response = requests.post(server_url, data={"prompt": prompt})
    response_text = response.text
    
    # Split the response text into individual messages
    conversation_messages = response_text.split("\n")
    num_messages = len(conversation_messages)
    
    return response_text, num_messages

def print_session_data(data):
    response_text, num_messages = data
    session = gr.capture_session()
    ip_address = session["ip"]
    user_agent = session["user_agent"]
    
    print("IP Address:", ip_address)
    print("User Agent:", user_agent)
    print("Number of Messages:", num_messages)

iface = gr.Interface(
    fn=interact_with_server,
    inputs=gr.inputs.Textbox(),
    outputs=[gr.outputs.HTML(), gr.outputs.Label()],  # Use Label for displaying the number of messages
    capture_session=True  # Automatically captures IP address and user agent
)

iface.launch(print_session_data)  # Pass the function to print session data to the launch method
