import gradio as gr
alias = "Sentiment Analysis on product reviews"
description = "Add a product review you can find on the internet. The model is trained on multiple languages so you can also test for that!"
name = "models/nlptown/bert-base-multilingual-uncased-sentiment"
examples = [
                ['''We vinden het aanbod heel lekker maar ...
                    We vinden het aanbod heel lekker.
                    Wat we wel heel erg spijtig vinden dat is dat er bij zoveel gerechten nog eens een supplement wordt gevraagd.
                    Jullie prijzen stijgen al regelmatig!
                    Jullie geven ook wel cadeaus maar nooit voor de gebruikers. Geef ons ook eens af en toe een bonus i.p.v. te proberen méér klanten te krijgen!
'               '''],
                ['''Slechte kwaliteit
                    De maaltijden zijn veel te Nederlands getint, groenten zijn niet vers als ze geleverd worden, vlees is van slechte en goedkope kwaliteit, broodjes die bijgeleverd worden zijn niet lekker.. structuur van een spons..
                    Ik hoop dat ik zonder probleem het contract kan stopzetten…'''
                ],
            ]
gr.Interface.load(name=name,
                  alias=alias,
                  description=description,
                  examples=examples).launch()