import os
import openai
import PyPDF2
import gradio as gr
import docx

class CourseGenarator:
    def __init__(self):
        openai.api_key = os.getenv("OPENAI_API_KEY")

    def extract_text_from_file(self,file_path):
        # Get the file extension
        file_extension = os.path.splitext(file_path)[1]

        if file_extension == '.pdf':
            with open(file_path, 'rb') as file:
                # Create a PDF file reader object
                reader = PyPDF2.PdfFileReader(file)

                # Create an empty string to hold the extracted text
                extracted_text = ""

                # Loop through each page in the PDF and extract the text
                for page_number in range(reader.getNumPages()):
                    page = reader.getPage(page_number)
                    extracted_text += page.extractText()
            return extracted_text

        elif file_extension == '.txt':
            with open(file_path, 'r') as file:
                # Just read the entire contents of the text file
                return file.read()

        elif file_extension == '.docx':
              doc = docx.Document(file_path)
              text = []
              for paragraph in doc.paragraphs:
                  text.append(paragraph.text)
              return '\n'.join(text)

        else:
            return "Unsupported file type"

    def response(self,resume_path):
        resume_path = resume_path.name
        resume = self.extract_text_from_file(resume_path)


        # Define the prompt or input for the model
        prompt = f"""Analyze the resume to write the summary for following resume delimitted by triple backticks.
                     ```{resume}```
                  """

        # Generate a response from the GPT-3 model
        response = openai.Completion.create(
            engine='text-davinci-003',
            prompt=prompt,
            max_tokens=200,
            temperature=0,
            n=1,
            stop=None,
        )

        # Extract the generated text from the API response
        generated_text = response.choices[0].text.strip()

        return generated_text

    def gradio_interface(self):
      with gr.Blocks(css="style.css",theme=gr.themes.Soft()) as app:
            with gr.Row(elem_id="col-container"):
              with gr.Column():
                gr.HTML("<br>")
                gr.HTML(
                    """<h1 style="text-align:center; color:"white">ADOPLE AI Resume Summarizer</h1> """
                )
              with gr.Column():
                resume = gr.File(label="Resume",elem_classes="heightfit")

              with gr.Column():
                analyse = gr.Button("Analyze")

              with gr.Column():
                result = gr.Textbox(label="Summarized",lines=8)

            analyse.click(self.response, [resume], result)
            print(result)

      app.launch()

ques = CourseGenarator()
ques.gradio_interface()