import gradio as gr
import PyPDF2
import os
import openai
import re
import plotly.graph_objects as go

class ResumeAnalyser:
  def __init__(self):
      pass
  def extract_text_from_file(self,file_path):
      # Get the file extension
      file_extension = os.path.splitext(file_path)[1]

      if file_extension == '.pdf':
          with open(file_path, 'rb') as file:
              # Create a PDF file reader object
              reader = PyPDF2.PdfFileReader(file)

              # Create an empty string to hold the extracted text
              extracted_text = ""

              # Loop through each page in the PDF and extract the text
              for page_number in range(reader.getNumPages()):
                  page = reader.getPage(page_number)
                  extracted_text += page.extractText()
          return extracted_text

      elif file_extension == '.txt':
          with open(file_path, 'r') as file:
              # Just read the entire contents of the text file
              return file.read()

      else:
          return "Unsupported file type"

  def responce_from_ai(self,textjd, textcv):
      resume = self.extract_text_from_file(textjd)
      job_description = self.extract_text_from_file(textcv)

      response = openai.Completion.create(
          engine="text-davinci-003",
          prompt=f"""
  Given the job description and the resume, assess the matching percentage to 100 and if 100 percentage not matched mention the remaining percentage with reason. **Job Description:**{job_description}**Resume:**{resume}
  **Detailed Analysis:**
                  the result should be in this format:
                  Matched Percentage: [matching percentage].
                  Reason            : [Mention Reason and keys from job_description and resume get this matched percentage.].
                  Skills To Improve : [Mention the skills How to improve and get 100 percentage job description matching].
                  Keywords          : [matched key words from {job_description} and {resume}].
                  """,
          temperature=0,
          max_tokens=100,
          n=1,
          stop=None,
      )
      generated_text = response.choices[0].text.strip()
      print(generated_text)
      return generated_text


  def matching_percentage(self,job_description_path, resume_path):
      job_description_path = job_description_path.name
      resume_path = resume_path.name

      generated_text = self.responce_from_ai(job_description_path, resume_path)

      result = generated_text

      lines = result.split('\n')
        
      matched_percentage = None
      matched_percentage_txt = None
      reason = None
      skills_to_improve = None
      keywords = None
    
      for line in lines:
          if line.startswith('Matched Percentage:'):
              match = re.search(r"Matched Percentage: (\d+)%", line)
              if match:
                  matched_percentage = int(match.group(1))
                  matched_percentage_txt = (f"Matched Percentage: {matched_percentage}%")
          elif line.startswith('Reason'):
              reason = line.split(':')[1].strip()
          elif line.startswith('Skills To Improve'):
              skills_to_improve = line.split(':')[1].strip()
          elif line.startswith('Keywords'):
              keywords = line.split(':')[1].strip()


      # Extract the matched percentage using regular expression
      # match1 = re.search(r"Matched Percentage: (\d+)%", matched_percentage)
      # matched_Percentage = int(match1.group(1))

      # Creating a pie chart with plotly
      labels = ['Matched', 'Remaining']
      values = [matched_percentage, 100 - matched_percentage]

      fig = go.Figure(data=[go.Pie(labels=labels, values=values)])
      # fig.update_layout(title='Matched Percentage')


      return matched_percentage_txt,reason, skills_to_improve, keywords,fig


  def gradio_interface(self):
      with gr.Blocks(css="style.css",theme=gr.themes.Soft()) as app:
            #gr.HTML("""<img class="center" align="center" src="https://drive.google.com/file/d/1Suir2UMmryGveM8P0LFO768WpCtJ8jBg/view?usp=sharing" alt="Image" width="210" height="210">""")
            gr.HTML("""<h1 style="color:#100C08;text-align:center;font-size:6vw;">ADOPLE AI</h1>""")
            with gr.Row():
              with gr.Column(elem_id="col-container"):
                gr.HTML(
                    """<br style="color:white;">"""
                    )
                gr.HTML(
                    """<h2 style="text-align:center; color:"white">ADOPLE AI Resume Analyzer</h2> """
                )
                gr.HTML("<br>")
            with gr.Row():
              with gr.Column(scale=0.45, min_width=150, ):
                jobDescription = gr.File(label="Job Description")
              with gr.Column(scale=0.45, min_width=150):
                resume = gr.File(label="Resume")
              with gr.Column(scale=0.10, min_width=150):
                analyse = gr.Button("Analyse")
            with gr.Row():
              with gr.Column(scale=1.0, min_width=150):
                perncentage = gr.Textbox(label="Matching Percentage",lines=8)
              with gr.Column(scale=1.0, min_width=150):
                reason = gr.Textbox(label="Matching Reason",lines=8)
              with gr.Column(scale=1.0, min_width=150):
                skills = gr.Textbox(label="Skills To Improve",lines=8)
              with gr.Column(scale=1.0, min_width=150):
                keywords = gr.Textbox(label="Matched Keywords",lines=8)
            with gr.Row():
              with gr.Column(scale=1.0, min_width=150):
                pychart = gr.Plot(label="Matching Percentage Chart")
            analyse.click(self.matching_percentage, [jobDescription, resume], [perncentage,reason,skills,keywords,pychart])

      app.launch()

resume=ResumeAnalyser()
resume.gradio_interface()