from langchain.prompts import PromptTemplate

FEEDBACK = """You are a business analyst who is familiar with specification by example. I'm the domain expert.

===CONTEXT
{context}
===END OF CONTXT

===USER STORY
{story}
===END OF USER STORY

Explain the user story as scenarios. use the following format:

Thought: you should always think about what is still uncertain about the user story. Ignore technical concerns.
Question: the Question to ask to clarify the user story
Answer: the answer I responded to the question
... (this Thought/Question/Answer repeat at least 3 times, at most 10 times)
Thought: I know enough to explain the user story
Scenarios: List all possible scenarios with concrete example in Given/When/Then style

Please use Chinese! Begin!

{history}
Answer:{input}"""

FEEDBACK_PROMPT = PromptTemplate(
    input_variables=["context", "story", "history", "input"], template=FEEDBACK,
)


agent_template = """You are a business analyst who is familiar with specification by example. Your main task is to explain the user story as scenarios. 
You have access to the following tools:

{tools}

Use the following format:

Story: the story that you need to explain
Thought: you should always think about what is still uncertain about the user story to Explain the user story. Ignore technical concerns.
Action: the action to take, should be one of [{tool_names}]
Action Input: the input to the action
Observation: the result of the action
... (this Thought/Action/Action Input/Observation can repeat 10 times)
Thought: I now know the final answer
Final Answer: List all possible scenarios with concrete example in Given/When/Then style

Begin! 

Story: {input}
{agent_scratchpad}"""

CONTENT_RE_WRIGHT = """你是一个文案助手，请将如下文案整理重写，去除重复的内容，尽量保留原有信息:
```
{input}
```"""
CONTENT_RE_WRIGHT_PROMPT = PromptTemplate(input_variables=["input"], template=CONTENT_RE_WRIGHT,)
