from langchain import LLMChain, PromptTemplate
from langchain.agents import tool
from agents.tools.smart_domain.common import getPrefix

from models import llm
from agents.tools.smart_domain.entity import entity_architecture, entity_test_strategy, entity_tech_stack
from agents.tools.smart_domain.association import association_architecture, association_test_strategy, association_teck_stack




domain_task = """Your task is to generate the domain layer tests and product code."""
domain_teck_stack = """Java17、reactor、lombok、Junit5、reactor test、Mockito"""
domain_architecture = f"""the domain layer inclue 2 componets:
* {entity_architecture}
* {association_architecture}"""

domain_test_strategy = f"""{entity_test_strategy}
{association_test_strategy}"""



DOMAIN_LAYER = getPrefix(domain_task, domain_teck_stack, domain_architecture, domain_test_strategy) + """

Use the following format:
request: the request that you need to fulfill

Entity:
```
the Entity code that you write to fulfill the request, follow TechStack and Architecture
```

Association:
```
the Association code that you write to fulfill the request, follow TechStack and Architecture
```

Test:
```
the test code that you write to fulfill the request, follow TechStack Architecture and TestStrategy
```

request: {input}"""



DOMAIN_LAYER_PROMPT = PromptTemplate(input_variables=["input"], template=DOMAIN_LAYER,)

domainLayerChain = LLMChain(llm = llm(temperature=0.1), prompt=DOMAIN_LAYER_PROMPT)


@tool("Generate Domain Layer Code", return_direct=True)
def domainLayerCodeGenerator(input: str) -> str:
    '''useful for when you need to generate domain layer code'''
    response = domainLayerChain.run(input)
    return response