from langchain.prompts import PromptTemplate
from agents.tools.smart_domain.common import getPrefix
from langchain.chains import LLMChain
from langchain.agents import tool
from models import llm

db_entity_tech_stack = """Java17、reactor、lombok、Junit5、reactor test、Mockito、 Spring Data Reactive Couchbase、Couchbase"""

db_entity_architecture = """
* DbEntity: This component is use to define data structure that save to DB.
---eaxmple code:
    @Document 
    public class FeatureDb {{
        @Version
        private long version;

        @Id
        @GeneratedValue(strategy = GenerationStrategy.UNIQUE)
        private String id;
        
        private String featureKey;

        private Feature.FeatureDescription description;
    }}
---end of eaxmple code
* Repository: This component is use to define the interface to access DB.
    ---eaxmple code:
        public interface FeatureDbRepository extends ReactiveCrudRepository<FeatureDb, String> {{
            Mono<FeatureDb> findByFeatureKey(String featureKey);
        }}
    ---end of eaxmple code
"""

db_entity_test_strategy = """For the DbEntity And Repository, we can write component test to test the actual implementation of database operations, test class should extends RepositoryTestBase to use Testcontainers ability.
---eaxmple code: 
    class FeatureDbRepositoryTest extends RepositoryTestBase {{
        @Autowired
        FeatureDbRepository repository;

        @BeforeEach
        void setUp() {{
            repository.deleteAll().block();
        }}

        @AfterEach
        void tearDown() {{
            repository.deleteAll().block();
        }}

        @Test
        void should_save_Feature_success() {{
            var featureKey = "featureKey1";
            repository.save(FeatureTestUtil.createFeatureDb(featureKey))
                    .as(StepVerifier::create)
                    .expectNextCount(1)
                    .verifyComplete();
        }}

        @Test
        void should_add_same_featureKey_fail() {{
            var featureKey = "featureKey1";
            repository.save(FeatureTestUtil.createFeatureDb(featureKey)).block();

            repository.save(FeatureTestUtil.createFeatureDb(featureKey))
                    .as(StepVerifier::create)
                    .expectError()
                    .verify();
        }}
    }}
---end of eaxmple code
"""

db_entity_task = """Your task is to generate the DbEntity and Repository tests and product code."""

DB_ENTITY = getPrefix(db_entity_task, db_entity_tech_stack, db_entity_architecture, db_entity_test_strategy) + """

Use the following format:
request: the request that you need to fulfill

Entity:
```
the Entity code that you write to fulfill the request, follow TechStack and Architecture
```

Test:
```
the test code that you write to fulfill the request, follow TechStack Architecture and TestStrategy
```

request: {input}"""

DB_ENTITY_PROMPT = PromptTemplate(input_variables=["input"], template=DB_ENTITY,)

db_entity_Repository_chain = LLMChain(llm = llm(temperature=0.1), prompt=DB_ENTITY_PROMPT)


@tool("Generate DBEntity and Repository Code", return_direct=True)
def dbEntityRepositoryCodeGenerator(input: str) -> str:
    '''useful for when you need to generate DBEntity and Repository code'''
    response = db_entity_Repository_chain.run(input)
    return response