from langchain import LLMChain, PromptTemplate
from langchain.agents import tool

from agents.tools.smart_domain.common import getPrefix
from models import llm


association_architecture = """
Association: This component is use to define association between entities, which can represents the concept of a collection of entity, so it can include same business logic of entity collection. 
---eaxmple code: 
    public interface Features {{
        Flux<Feature> findAll();

        Mono<Long> size();

        Flux<Feature> subCollection(long from, long to);

        Mono<Feature> findById(FeatureId id);

        Mono<Feature> save(Feature feature);

        Mono<Void> update(FeatureId id, FeatureDescription description);

        Mono<Void> delete(FeatureId id);

        Mono<Void> publish(FeatureId id);

        Mono<Void> disable(FeatureId id);
    }}
---end of eaxmple code
"""

association_test_strategy = """
For the Association，do not write tests because it is has no impletation.
"""

association_teck_stack = """Java17、reactor、lombok、Junit5、reactor test、Mockito"""

association_task = """Your task is to generate the Association of domain layer tests and product code."""

ASSOCIATION = getPrefix(association_task, association_teck_stack, association_architecture, association_test_strategy) + """

Use the following format:
request: the request （whitch may include Enity existed in the domain layer）that you need to fulfill, 

Association:
```
the Association code that you write to fulfill the request, follow TechStack and Architecture
```

request: {input}"""

ASSOCIATION_PROMPT = PromptTemplate(input_variables=["input"], template=ASSOCIATION,)

asociationChain = LLMChain(llm = llm(temperature=0.1), prompt=ASSOCIATION_PROMPT)


@tool("Generate Association Code", return_direct=True)
def associationCodeGenerator(input: str) -> str:
    '''useful for when you need to generate asociation code'''
    response = asociationChain.run(input)
    return response