from langchain import LLMChain, PromptTemplate
from langchain.agents import tool

from models import llm


API_LAYER = """You are a software developer. Your task is to generate the api layer tests and product code.

===TechStack
Java17、reactor、lombok、Junit5、reactor test、Mockito、 Spring WebFlux、Spring Boot Test
===END OF TechStack

===Architecture
the api layer inclue 2 componets:
* DTO: This component is use to define data structure that api request and response.
* Controller: This component is use to define the interface to access api.
    ---eaxmple code:
        @RestController
        @RequiredArgsConstructor
        @RequestMapping("/features")
        public class FeatureController {{
            private final Features features;

            @GetMapping()
            public Flux<Feature> findAll() {{
                return features.getAll();
            }}

            @PostMapping()
            public Mono<Feature> add(@RequestBody Feature feature) {{
                return features.add(feature);
            }}
        }}
    ---end of eaxmple code
===END OF Architecture

===TestStrategy
For the Controller and DTO, we can write component test to test the actual implementation of api operations, test class rely on Association interface use WebFluxTest and WebTestClient ability.
    ---eaxmple code: 
        @ExtendWith(SpringExtension.class)
        @WebFluxTest(value = FeatureFlagApi.class, properties = "spring.main.lazy-initialization=true")
        @ContextConfiguration(classes = TestConfiguration.class)
        class FeatureControllerTest extends ControllerTestBase {{
            @Autowired
            WebTestClient webClient;

            @MockBean
            Features features;

            @Test
            void should_getAll_success_when_no_records() {{
                when(features.getAll(Mockito.any())).thenReturn(Flux.empty());

                webClient.get()
                        .uri("/features")
                        .exchange()
                        .expectStatus()
                        .isOk()
                        .expectBodyList(FeatureFlagResponse.class)
                        .hasSize(0);
            }}
        }}      
    ---end of eaxmple code
===END OF TestStrategy

Use the following format:
request: the request that you need to fulfill include Entity and Association of domain layer

DTO:
```
the DTO code that you write to fulfill the request, follow TechStack and Architecture
```

Controller:
```
the Controller code that you write to fulfill the request, follow TechStack and Architecture
```

Test:
```
the test code that you write to fulfill the request, follow TechStack Architecture and TestStrategy
```

request: {input}"""

API_LAYER_PROMPT = PromptTemplate(input_variables=["input"], template=API_LAYER,)


apiChain = LLMChain(llm = llm(temperature=0.1), prompt=API_LAYER_PROMPT)


@tool("Generate API Layer Code", return_direct=True)
def apiLayerCodeGenerator(input: str) -> str:
    '''useful for when you need to generate API layer code'''
    response = apiChain.run(input)
    return response