from langchain.tools import ShellTool
from langchain.agents import tool
from langchain.chains import LLMChain
from langchain.prompts import PromptTemplate

from models import llm


generate_python_code = """
Please write Shell script to fulfill the following requirement:

---
{input}
---

Only output the code section with code block.
"""

generate_python_code_promopt = PromptTemplate(input_variables=["input"], template=generate_python_code,)

generate_code_chain = LLMChain(llm = llm(temperature=0.1), prompt=generate_python_code_promopt, output_key="code")

shell_tool = ShellTool()

@tool("Generate and Excute Shell Code ", return_direct=True)
def generate_and_excute_shell_code(input: str) -> str:
    '''useful for when you need to generate python code and excute it'''
    command = generate_code_chain.run(input)
    print(command)
    code_content = command
    if('```python' in command): 
        start = command.find('```python') + len('```python')
        end = command.rfind('```')
        code_content = command[start:end].strip()
    elif("```" in command): 
        start = command.find('```') + len('```')
        end = command.rfind('```')
        code_content = command[start:end].strip()
    result = shell_tool.run(code_content)
    return f"""
code:
```
{code_content}
```

execute result:
---
{result}
---
    """


shell_tool = ShellTool()
shell_tool.description = shell_tool.description + f"args {shell_tool.args}".replace("{", "{{").replace("}", "}}")