import gradio as gr
import PIL

from tensorflow.keras.models import load_model
#import segmentation_models as sm
#import efficientnet.keras as efn
import matplotlib.pyplot as plt
import tensorflow as tf
import numpy as np
import cv2

lr=1e-5

#iou_score = [sm.metrics.IOUScore(threshold=0.5)]

def iou_loss(y_true, y_pred):
      y_true = tf.reshape(y_true, [-1])
      y_pred = tf.reshape(y_pred, [-1])
      intersection = tf.reduce_sum(tf.cast(y_true, tf.float32) * tf.cast(y_pred, tf.float32))
      score = (intersection + 1.) / (tf.reduce_sum(tf.cast(y_true, tf.float32)) +
      tf.reduce_sum(tf.cast(y_pred, tf.float32)) - intersection + 1.)
      return 1 - score

def mean_iou(y_true, y_pred):
      y_pred = tf.round(tf.cast(y_pred, tf.int32))
      intersect = tf.reduce_sum(tf.cast(y_true, tf.float32) * tf.cast(y_pred, tf.float32), axis=[1])
      union = tf.reduce_sum(tf.cast(y_true, tf.float32),axis=[1]) + tf.reduce_sum(tf.cast(y_pred, tf.float32),axis=[1])
      smooth = tf.ones(tf.shape(intersect))
      return tf.reduce_mean((intersect + smooth) / (union - intersect + smooth))

model1 = load_model('UNET[Scratch].h5', compile=False)

model1.compile(optimizer = tf.keras.optimizers.Adam(lr),
              loss=iou_loss, metrics=[mean_iou],)

class_names = ['urban_land', 'agriculture_land', 'rangeland', 'forest_land', 'water','barren_land','unknown']

def Unet(img):
  img_1=img.reshape(-1, 256, 256, 3)
  prediction=model1.predict(img_1).flatten()
  return {class_names[i]: float(prediction[i]) for i in range(7)}
iface1 = gr.Interface(fn=Unet, inputs = gr.inputs.Image(shape = (256, 256)),	outputs = gr.outputs.Label(num_top_classes=7), title="Unet",
                     description="""Segmenting land from an image using a deep learning model.
                    This application aims to provide a user-friendly interface for segmenting land areas in images.
                    Firstly we get an intermediate output as a segmented image of the land cover, which is later converted into the percentage of the respective land classes.
                    Overall, we aim to make land segmentation accessible to a wide range of users and facilitating further analysis and decision-making based on the segmented land regions.""")

'''
def fpn(img):
  img_2=img.reshape(-1,256, 256, 3)
  prediction=model2.predict(img_2).flatten()
  return {class_names[i]: float(prediction[i]) for i in range(7)}
iface2 = gr.Interface(fn=fpn, inputs = gr.inputs.Image(shape = (256, 256)),	outputs = gr.outputs.Label(num_top_classes=7), title="FPN",)

# Combine both interfaces into a single Parallel interface
gr.Parallel(iface1, iface2, title="Land Segmentation: Unet vs FPN",
            description="""Segmenting land from an image using a deep learning model.
            This application aims to provide a user-friendly interface for segmenting land areas in images.
            Firstly we get an intermediate output as a segmented image of the land cover, which is later converted into the percentage of the respective land classes.
            Overall, we aim to make land segmentation accessible to a wide range of users and facilitating further analysis and decision-making based on the segmented land regions.""",
            ).launch(share=True, debug=True, auth=("admin", "pass1234"))
'''
iface1.launch(inline=False)