import os
import gradio as gr
from PIL import Image


os.system('wget https://github.com/FanChiMao/SRMNet-thesis/releases/download/v0.0/Deblurring_motionblur.pth -P experiments/pretrained_models')
os.system('wget https://github.com/FanChiMao/SRMNet-thesis/releases/download/v0.0/Dehaze_realworld.pth -P experiments/pretrained_models')
os.system('wget https://github.com/FanChiMao/SRMNet-thesis/releases/download/v0.0/Denoise_gaussian.pth -P experiments/pretrained_models')
os.system('wget https://github.com/FanChiMao/SRMNet-thesis/releases/download/v0.0/Denoise_realworld.pth -P experiments/pretrained_models')
os.system('wget https://github.com/FanChiMao/SRMNet-thesis/releases/download/v0.0/Deraining_raindrop.pth -P experiments/pretrained_models')
os.system('wget https://github.com/FanChiMao/SRMNet-thesis/releases/download/v0.0/Deraining_rainstreak.pth -P experiments/pretrained_models')
os.system('wget https://github.com/FanChiMao/SRMNet-thesis/releases/download/v0.0/LLEnhancement.pth -P experiments/pretrained_models')
os.system('wget https://github.com/FanChiMao/SRMNet-thesis/releases/download/v0.0/Retouching.pth -P experiments/pretrained_models')

def inference(img, model):
    os.system('mkdir test')
    img.save("test/1.png", "PNG")
    
    if model == 'Denoising (gaussian)':
        os.system('python main_test_SRMNet.py --input_dir test --task Denoise_gaussian')
    elif model == 'Denoising (real-world)':
        os.system('python main_test_SRMNet.py --input_dir test --task Denoise_realworld')
    elif model == 'Deblurring (motion-blur)':
        os.system('python main_test_SRMNet.py --input_dir test --task Deblurring_motionblur')
    elif model == 'Dehazing (dense haze)':
        os.system('python main_test_SRMNet.py --input_dir test --task Dehaze_realworld')
    elif model == 'Deraining (rainstreak)':
        os.system('python main_test_SRMNet.py --input_dir test --task Deraining_rainstreak')
    elif model == 'Deraining (raindrop)':
        os.system('python main_test_SRMNet.py --input_dir test --task Deraining_raindrop')
    elif model == 'Low-light Enhancement':
        os.system('python main_test_SRMNet.py --input_dir test --task LLEnhancement')
    elif model == 'Retouching':
        os.system('python main_test_SRMNet.py --input_dir test --task Retouching')
        
    return 'result/1.png'


title = "[NCHU thesis] Image Restoration by Selective Residual Block on Improved Hierarchical Encoder-Decoder Networks"
description = ""
article = "<p style='text-align: center'><a href='https://' target='_blank'>Image Restoration by Selective Residual Block on Improved Hierarchical Encoder-Decoder Networks</a> | <a href='https://github.com/FanChiMao/SRMNet-thesis' target='_blank'>Github Repo</a></p> <center><img src='https://visitor-badge.glitch.me/badge?page_id=52Hz_SRMNet_thesis' alt='visitor badge'></center>"

examples = [
['figures/noise_1.png', 'Denoising (gaussian)'], 
['figures/noise_2.png', 'Denoising (real-world)'],
['figures/blur.png', 'Deblurring (motion-blur)'],
['figures/haze.png', 'Dehazing (dense haze)'],
['figures/rainstreak.png', 'Deraining (rainstreak)'],
['figures/raindrop.png', 'Deraining (raindrop)'],
['figures/LL.png', 'Low-light Enhancement'],
['figures/nchu.png', 'Retouching'],
]
gr.Interface(
    inference,
    [gr.inputs.Image(type="pil", label="Input"), gr.inputs.Dropdown(choices=[
    'Denoising (gaussian)', 
    'Denoising (real-world)',
    'Deblurring (motion-blur)',
    'Dehazing (dense haze)',
    'Deraining (rainstreak)',
    'Deraining (raindrop)',
    'Low-light Enhancement',
    'Retouching',
    ], type="value", default='Denoising (gaussian)', label="model")],
    gr.outputs.Image(type="file", label="Output"),
    title=title,
    description=description,
    article=article,
    allow_flagging=False,
    allow_screenshot=False,
    examples=examples
).launch(debug=True)