import os
import gradio as gr
from PIL import Image


os.system('wget https://github.com/FanChiMao/HWMNet/releases/download/v0.0/LOL_enhancement_HWMNet.pth -P experiments/pretrained_models')
os.system('wget https://github.com/FanChiMao/HWMNet/releases/download/v0.0/MIT5K_enhancement_HWMNet.pth -P experiments/pretrained_models')

def inference(img, model):
    os.system('mkdir test')
    #basewidth = 256
    #wpercent = (basewidth / float(img.size[0]))
    #hsize = int((float(img.size[1]) * float(wpercent)))
    #img = img.resize((basewidth, hsize), Image.ANTIALIAS)
    img.save("test/1.png", "PNG")
    if model == 'LOL':
        os.system('python main_test_HWMNet.py --input_dir test --weights experiments/pretrained_models/LOL_enhancement_HWMNet.pth')
    elif model == 'MIT-5K':
        os.system('python main_test_HWMNet.py --input_dir test --weights experiments/pretrained_models/MIT5K_enhancement_HWMNet.pth')
        
    return 'result/1.png'


title = "Half Wavelet Attention on M-Net+ for Low-light Image Enhancement"
description = "Gradio demo for HWMNet. HWMNet has competitive performance results on two real-world low-light datasets in terms of quantitative metrics and visual quality. See the paper and project page for detailed results below. Here, we provide a demo for low-light image enhancement. To use it, simply upload your image, or click one of the examples to load them. We present 2 pretrained models, which is trained on LOL and MIT-Adobe FiveK dataset, respectively. The images in LOL dataset are darker than MIT-Adobe FiveK, so if you have the extremely dark images you could consider it. On the contrary, the MIT-Adobe FiveK's model is suitable for minor adjustment of the images' hue."
article = "<p style='text-align: center'><a href='https://ieeexplore.ieee.org/document/9897503' target='_blank'>Half Wavelet Attention on M-Net+ for Low-light Image Enhancement</a> | <a href='https://github.com/FanChiMao/HWMNet' target='_blank'>Github Repo</a></p> <center><img src='https://visitor-badge.glitch.me/badge?page_id=52Hz_HWMNet_lowlight_enhancement' alt='visitor badge'></center>"

examples = [['low-light.png', 'LOL'], ['low-light_2.png', 'MIT-5K']]
gr.Interface(
    inference,
    [gr.inputs.Image(type="pil", label="Input"), gr.inputs.Dropdown(choices=['LOL', 'MIT-5K'], type="value", default='LOL', label="model")],
    gr.outputs.Image(type="filepath", label="Output"),
    title=title,
    description=description,
    article=article,
    allow_flagging=False,
    allow_screenshot=False,
    examples=examples
).launch(debug=True)