import os
import gradio as gr
from PIL import Image
import torch

os.system(
    'wget https://github.com/FanChiMao/CMFNet/releases/download/v0.0/deraindrop_DeRainDrop_CMFNet.pth -P experiments/pretrained_models')


def inference(img):
    os.system('mkdir test')
    basewidth = 512
    wpercent = (basewidth / float(img.size[0]))
    hsize = int((float(img.size[1]) * float(wpercent)))
    img = img.resize((basewidth, hsize), Image.BILINEAR)
    img.save("test/1.png", "PNG")
    os.system(
        'python main_test_CMFNet.py --input_dir test --weights experiments/pretrained_models/deraindrop_DeRainDrop_CMFNet.pth')
    return 'results/1.png'


title = "Compound Multi-branch Feature Fusion for Image Restoration (Deraindrop)"
description = "Gradio demo for CMFNet. CMFNet achieves competitive performance on three tasks: image deblurring, image dehazing and image deraindrop. Here, we provide a demo for image deraindrop. To use it, simply upload your image, or click one of the examples to load them. Reference from: https://huggingface.co/akhaliq"
article = "<p style='text-align: center'><a href='https://' target='_blank'>Compound Multi-branch Feature Fusion for Real Image Restoration</a> | <a href='https://github.com/FanChiMao/CMFNet' target='_blank'>Github Repo</a></p> <center><img src='https://visitor-badge.glitch.me/badge?page_id=52Hz_CMFNet_deraindrop' alt='visitor badge'></center>"

examples = [['Rain.png'], ['Rain2.png'], ['Rain3.png'], ['Rain4.png'], ['Rain5.png'],]
gr.Interface(
    inference,
    [gr.inputs.Image(type="pil", label="Input")],
    gr.outputs.Image(type="filepath", label="Output"),
    title=title,
    description=description,
    article=article,
    allow_flagging=False,
    allow_screenshot=False,
    examples=examples
).launch(debug=True)