import gradio as gr
import os
from share_btn import community_icon_html, loading_icon_html, share_js

text_gen = gr.Interface.load(name="spaces/Gustavosta/MagicPrompt-Stable-Diffusion")
stable_diffusion = gr.Blocks.load(name="spaces/runwayml/stable-diffusion-v1-5")

def get_images(prompt):
    gallery_dir = stable_diffusion(prompt, fn_index=2)
    sd_output = [os.path.join(gallery_dir, image) for image in os.listdir(gallery_dir)]
    return sd_output, gr.update(visible=True), gr.update(visible=True), gr.update(visible=True)

css = '''
.animate-spin {
    animation: spin 1s linear infinite;
}
@keyframes spin {
    from {
        transform: rotate(0deg);
    }
    to {
        transform: rotate(360deg);
    }
}
a {text-decoration-line: underline;}
'''

with gr.Blocks(css=css) as demo:
    gr.HTML("""<div style="text-align: center; max-width: 700px; margin: 0 auto;">
            <div
            style="
                display: inline-flex;
                align-items: center;
                gap: 0.8rem;
                font-size: 1.75rem;
            "
            >
            <h1 style="font-weight: 900; margin-bottom: 7px; margin-top: 5px;">
                Chameleon Text2Img Generator Demo 🦎
            </h1>
            </div>
        </div>""")

    with gr.Row():

      with gr.Column():
        text_output = gr.Textbox(
                                label="Prettified text prompt", 
                                lines=4,
                                elem_id="translated"
                            )
        with gr.Row():
            diffuse_btn = gr.Button(value="Generate!")
      with gr.Column(elem_id="generated-gallery"):
        sd_output = gr.Gallery().style(grid=2, height="auto")
        with gr.Group(elem_id="share-btn-container"):
            community_icon = gr.HTML(community_icon_html, visible=False)
            loading_icon = gr.HTML(loading_icon_html, visible=False)
            share_button = gr.Button("Share to community", elem_id="share-btn", visible=False)

    diffuse_btn.click(get_images, 
                          inputs = [
                              text_output
                              ], 
                          outputs = [sd_output, community_icon, loading_icon, share_button]
                          )
    share_button.click(None, [], [], _js=share_js)



demo.launch(debug=True)