import torch
import requests
import torch.nn as nn
import torch.nn.functional as F

# urls = ("https://raw.githubusercontent.com/g8j39/GPT/main/corpus.txt",) #"https://raw.githubusercontent.com/g8j39/GPT/main/merged_file.txt","https://raw.githubusercontent.com/g8j39/GPT/main/merged_file2.txt","https://raw.githubusercontent.com/g8j39/GPT/main/merged_file3.txt") ##https://raw.githubusercontent.com/g8j39/GPT/main/corpus.txt",) , "https://raw.githubusercontent.com/g8j39/GPT/main/merged_file.txt", "https://raw.githubusercontent.com/g8j39/GPT/main/friends_corpus.txt"
# raw_text = []
# for i, url in enumerate(urls):
#   r = requests.get(url)
#   with open(f'{i}.txt', 'wb') as f:
#     f.write(r.content)
#   with open(f'{i}.txt', 'rb') as f:
#     raw_text += f.readlines()
# raw_text = ''.join([t.decode('utf') for t in raw_text])

with open('corpus.txt', 'r') as f:
    raw_text = f.read()

# Remove double spaces
#raw_text = " ".join(raw_text.split())
for char in ('=', '@', '^', '|', '\x7f'):
  raw_text += char
for char in ('¿', 'à', 'è', 'é', 'í', 'ï', 'ñ', 'ó', 'ÿ', '–', '—', '…'):
  raw_text = raw_text.replace(char,'')
raw_text+='\n'
raw_text+='\xa0'

def prepare_data(input,encoding_type):
  if encoding_type == 'single':
    chars = sorted(list(set(input)))
    n_vocab = len(chars)
    stoi = { ch:i for i,ch in enumerate(chars) }
    itos = { i:ch for i,ch in enumerate(chars) }
    encode = lambda s: [stoi[c] for c in s] # encoder: take a string, output a list of integers
    decode = lambda l: ''.join([itos[i] for i in l]) # decoder: take a list of integers, output a string
    output = torch.tensor(encode(input), dtype = torch.long)
    return output, encode, decode, n_vocab, stoi, itos

text, encode, decode, n_vocab, stoi, itos = prepare_data(raw_text,encoding_type='single')

max_iters = 10000
eval_interval = 1000
eval_iters = 100
learning_rate = 1e-3
device = 'cuda' if torch.cuda.is_available() else 'cpu'
train_split = 0.9
d_batch = 150
d_window = 140
d_embd = 500
d_mlp = 4 * d_embd
n_heads = 4 # Must divide d_embd
d_head = d_embd // n_heads
n_layers = 4
dropout = 0.1

class AttnHead(nn.Module):
  def __init__(self,mode):
    super().__init__()
    self.mode = mode
    self.key = nn.Linear(d_embd, d_head, bias=False, device=device)
    self.query = nn.Linear(d_embd, d_head, bias=False, device=device)
    self.value = nn.Linear(d_embd, d_head, bias=False, device=device)

  def forward(self,x):
    B,T,C = x.shape
    k, q, v = self.key(x), self.query(x), self.value(x)
    attn = (q @ k.transpose(1,2)) / (d_head**0.5) # (d_batch, T, T)
    # apply mask
    attn = attn.masked_fill(torch.tril(torch.ones(T,T).to(device))==0,float('-inf'))
    attn = F.softmax(attn,dim=-1)
    attn = attn @ v # (d_batch, T, d_head)
    return attn

class MultiHead(nn.Module):
  def __init__(self,mode):
    super().__init__()
    self.mode = mode
    self.heads = nn.ModuleList([AttnHead(mode) for _ in range(n_heads)])
    self.proj = nn.Linear(d_embd, d_embd)
    self.dropout = nn.Dropout(dropout)
    
  def forward(self,x):
    # apply the heads, concatenate and project
    out = torch.cat([head(x) for head in self.heads],dim=-1)
    out = self.dropout(out)
    return out

class PositionalEncoding(nn.Module):
# Create a unique vector in embedding space for each position
  def __init__(self,mode,window):
      super().__init__()
      self.mode = mode
      positions = torch.arange(window).unsqueeze(1)
      div_term = torch.exp(torch.arange(0, d_embd, 2) * (-math.log(10000.0) / d_embd)) # (d_embd/2 = 64, starts at 1 and decays)
      pe = torch.zeros(1, window, d_embd)
      pe[0, :, 0::2] = torch.sin(positions * div_term)
      pe[0, :, 1::2] = torch.cos(positions * div_term)
      self.register_buffer('pe', pe)

  def forward(self, x):
      return self.pe[:,:x.size(1)]

class Tformer(nn.Module):
  def __init__(self,mode):
    super().__init__()
    self.mode = mode
    self.multihead = MultiHead(mode)
    self.mlp = nn.Sequential(
            nn.Linear(d_embd, d_mlp),
            nn.ReLU(),
            nn.Linear(d_mlp, d_embd),
            nn.Dropout(dropout),)
    self.ln1 = nn.LayerNorm(d_embd)
    self.ln2 = nn.LayerNorm(d_embd)
  def forward(self,x,y=None):
    x = self.ln1(x)
    x = x + self.multihead(x)
    x = self.ln2(x)
    out = x + self.mlp(x)
    return out

class LLM(nn.Module):
  def __init__(self,mode='live',window=d_window):
    super().__init__()
    self.mode = mode
    self.embed = nn.Embedding(n_vocab,d_embd)
    self.pe = PositionalEncoding(mode,window)
    self.blocks = nn.Sequential(*[Tformer(mode) for _ in range(n_layers)])
    self.unembed = nn.Linear(d_embd,n_vocab)
    self.ln3 = nn.LayerNorm(d_embd)
    
  def forward(self,x,y=None):
    B, T = x.shape
    out = self.embed(x) # (d_batch, d_window, d_embd)
    out = out + self.pe(out)
    out = self.blocks(out)
    out = self.ln3(out)
    out = self.unembed(out) # (d_batch, d_window, n_vocab)
    loss = None if y==None else F.cross_entropy(out.view(-1,n_vocab), y.view(-1))
    return out, loss

@torch.inference_mode()

def generate(length=500, input_text=' '):
    encoded = torch.tensor(encode(input_text), dtype=torch.long).unsqueeze(0)  # (1,len(input_text))
    encoded = encoded.to(device)
    for _ in range(length):
        encoded_curr = encoded[:, -d_window:]
        y, _ = model(encoded_curr)  # (1, len(input_text), n_vocab)
        y = y[:, -1, :]
        y_prob = F.softmax(y, dim=-1)
        next = torch.multinomial(y_prob, num_samples=1)  # (1,1)
        encoded = torch.cat((encoded, next), dim=1)  # (1, len(input_text)+1)
    return decode(encoded.squeeze().tolist()[len(input_text):])

model = torch.load('final_finetuned_seinfeld.pt', map_location=torch.device('cpu'))
model.eval()

import gradio as gr

def generate_wrapper(input_text: str, length: int):
    return generate(length=length, input_text=input_text)

iface = gr.Interface(
    fn=generate_wrapper,
    inputs=[gr.inputs.Textbox(placeholder='Enter input text here...', label='Input text', default = 'KRAMER:'), gr.inputs.Slider(minimum=10, maximum=1000, step=10, default=100, label='Output length (characters)')],
    outputs=gr.outputs.Textbox(),
    live=False)
iface.launch()