import gradio as gr
from sentence_transformers import SentenceTransformer, util

ts_model = SentenceTransformer('sentence-transformers/all-MiniLM-L6-v2')

def similarity(*data):
  question = data[0]
  q = data[1::2]
  a = data[2::2]
  similarities = []
  for i in q:
    embedding_1= ts_model.encode(i, convert_to_tensor=True)
    embedding_2 = ts_model.encode(question, convert_to_tensor=True)

    similarities.append(float(util.pytorch_cos_sim(embedding_1, embedding_2)))
  max_similarity = max(similarities)
  max_similarity_index = similarities.index(max_similarity)

  if max_similarity <= 0.5:
        return "It seems that, I don't have a specific answer for that Question"
  else:
    return a[max_similarity_index]
        
        
gr.Interface(
    fn = similarity,
    inputs = [gr.Textbox(label = "Main Q"),gr.Textbox(label = "Q1"),gr.Textbox(label = "A1"),gr.Textbox(label = "Q2"),gr.Textbox(label = "A2")],
    outputs = "text"
).launch()