
import config 
import openai 
import sys, getopt
from datetime import datetime
import streamlit as st
import boto3

def get_chatgpt_resp(question): 
    openai.api_key = st.secrets['OPENAI_API_KEY']
    response = openai.ChatCompletion.create(
            model='gpt-3.5-turbo',
            messages=[
                    {"role":"system","content":"You are a chatbot"},
                    {"role":"system","content":question}]
    )
    result = ''
    for choice in response.choices:
        result+=choice.message.content

    return (result)

def gsearch(query, num_results):
    try:
        from googlesearch import search
    except ImportError:
        print("No module named 'google' found")
 
    # Google Search and return 10 links
    search_links = []
    for j in search(query, tld="com", num=num_results, stop=num_results, pause=2):
        search_links.append(j)
    return(search_links)
    
    
def chatgpt_prompt(pname, search_links):
    all_links = '\n'.join(map(str,search_links))
    prompt_text = "You are a expert KYC analyst. I need help to identify if there is any adverse news about {}\
       in the following links. \n {}. \n. In the reply include a 20 word summary of the text in each link and if you find any adverse\
           news (Yes or No)".format(pname, all_links)
    return(prompt_text)

def generate_kyc_output(query, search_links, chat_response, start_time):
    rep_txt = ''

    rep_txt += 'Summary of Google Search for {} \n'.format(query)
    rep_txt += '\n'
    rep_txt += "Report generated on {} \n".format(datetime.now())
    #rep_txt += "----------------------------------------------------- \n"
    rep_txt += '\n'
    rep_txt += "Top Google Search Links "
    rep_txt += '\n'
    rep_txt += '\n'.join(map(str,search_links))
    #rep_txt += "\n----------------------------------------------------- \n"
    rep_txt += '\n'
    rep_txt+= "\n Summary of searches and adverse news findings \n"
    #rep_txt += "----------------------------------------------------- \n"
    rep_txt += chat_response 
    rep_txt += '\n'
    
    end_time = datetime.now()
    exec_time = (end_time - start_time).total_seconds() 
    rep_txt += "Execution runtime {} seconds \n".format(exec_time)
    rep_txt += '\n'

    return(rep_txt)

def save_to_s3(search_text,date_time):
    s3 = boto3.resource(
    's3',
    region_name='us-east-1',
    aws_access_key_id=st.secrets['AWS_ACCESS_KEY_ID'],
    aws_secret_access_key=st.secrets['AWS_ACCESS_KEY']
    )
    fname = ("{}.txt").format(date_time)
    object = s3.Object('adverse-news-search', fname)
    object.put(Body=search_text)

def main(argv):
    try:
        opts, args = getopt.getopt(argv,"i:", ["person="])
    except getopt.GetoptError:
            print ('Usage: python app.py --person=<person name>')
            sys.exit(2)
    for opt, arg in opts:
        if opt == '--person':
            pname = arg
    # Google search for the person name and get the first 20 query links 
    search_links = gsearch(pname)

    # Construct the prompt 
    prompt_text = chatgpt_prompt(pname, search_links)

    #get ChatGPT response 
    resp = get_chatgpt_resp(prompt_text)
    
    # Create PDF with links and summary 
    #rep_txt= generate_kyc_output(pname, search_links, resp)

    #print(rep_txt)


if __name__ == "__main__":
    main(sys.argv[1:])