import streamlit as st
import openai 
import sys, getopt
from datetime import datetime
from streamlit.components.v1 import html
import boto3

from main import chatgpt_prompt, get_chatgpt_resp, generate_kyc_output, gsearch, save_to_s3

# Function to perform the search
# This is a placeholder function, replace it with your actual search implementation
def perform_search(pname, keywords, num_results):
    # record current timestamp
    start_time = datetime.now()
    
    # Google search for the person name and get the first 20 query links 
    query = pname + " " + keywords
    search_links = gsearch(query, num_results)

    # Construct the prompt 
    prompt_text = chatgpt_prompt(pname, search_links)
    #get ChatGPT response 
    resp = get_chatgpt_resp(prompt_text)
    # Create PDF with links and summary 
    rep_txt= generate_kyc_output(query, search_links, resp, start_time)
    return (rep_txt)

main_tab, help_tab, rel_tab = st.tabs(["Run the Bot", "FAQ", "Release Plan"])

with main_tab: 
    # Streamlit app
    st.title("Adverse News Detection Assistant")

    # Input fields
    names_txt = st.text_input("Enter party name (or multiple names separated by ,)")
    plc_text = "laundering OR terrorist OR fraud OR corrupt OR criminal OR investigation OR prosecute OR evasion OR bribe OR sanction"
    keywords = st.text_input("Enter other search words:", value=plc_text)

    st.sidebar.markdown("## Controls")
    st.sidebar.markdown("Choose your **search** *parameters*")
    num_results = st.sidebar.slider("Choose the number of search results:", 5, 30, 20, 5)
    st.sidebar.markdown("## Model")
    st.sidebar.markdown("GPT v3.5")
    st.sidebar.markdown("## App")
    st.sidebar.markdown("v0.4")

    col1, col2 = st.columns(2)
    with col1:
        adv_nw = st.radio(
        "Did you find adverse news when you performed this search manually",
        ('Yes', 'No', 'Dont Know'), index=2)
    with col2:
        #st.markdown("Touch time (manual) in mins")
        man_tt = st.number_input('Touch time (manual) in mins', value=0, step=1)
        #st.markdown("Touch time (with bot) in mins")
        bot_tt = st.number_input('Touch time (with bot) in mins', value=0, step=1)

    # Search button
    if st.button("Search"):
        names = names_txt.split(",")
        #print(len(names))
        metrics_ent = (adv_nw != "Dont Know") and (man_tt > 0) and (bot_tt > 0) 
        # Perform the search and display the results
        if names and metrics_ent:
            search_results = ""
            for name in names:
                #print("trying for name {} \n".format(name))
                search_results += perform_search(name, keywords, num_results)

            html(f"<pre>{search_results}</pre>", height=200, scrolling=True)
            st.download_button('Download Report',search_results)
            try:
                date_time = datetime.now()
                save_to_s3(search_results,date_time )
                print ("Completed processing for {} names: {} at {} \n".format(len(names), names_txt, str(date_time)))
            except: 
                print ("Completed processing with S3 write error for {} names: {} at {} \n".format(len(names),names_txt, str(date_time)))
        else:
            st.error("Please enter party name, adverse news selection (Yes or No) and Touch Time before searching.")

with help_tab:
    st.title("FAQ")
    
    st.markdown("Q. How do I get a count of number of adverse news?")
    st.markdown("A. This functionality isnt implemented yet. A workaround is to manually count the number of links with adverse news")

    st.markdown("Q. How do I summarise all the adverse news?")
    st.markdown("A. This functionality isnt implemented yet. A workaround is to aggregate the summary of all adverse news items manually, and get a sumary from ChatGPT (chat.openai.com")

    st.markdown("Q. Can I search in other lauguages?")
    st.markdown("A. This functionality isnt implemented yet. We are planning to test this feature out with Chinese first")

    st.markdown("Q. Can I search without the other search words?")
    st.markdown("A. Just enter a blank space in the text space and search")

with rel_tab: 
    st.markdown(f""" 
            | NO. | Issue / Enhancement                                                                                                                       | Rel | Status    |
            |-----|--------------------------------------------------------------------------------------------------------------------------------------------|-----|-----------| 
            | 1   | Capture productivity and adverse news metrics from the user                                                                                | 0.4 | Completed | 
            | 2   | Save productivity and adverse news metrics in a DB                                                                                         | 0.4 | TBD       |  
            | 3   | Convert bot output to structured JSON  - Count of adverse news  - Summary of all adverse news  - Identification of links with adverse news | 0.6 | TBD       | 
            | 4   | Offer alternate solution path with web text scraping and                                                                                   | 0.6 | TBD       | 
            | 5   | Create a page on metrics report                                                                                                            | 0.5 | TBD       |""")
