import gradio as gr
import pickle

# Load the decision tree model from the pickle file
with open('best_tree.pkl', 'rb') as file:
    model = pickle.load(file)

# Define the predict function
def predict(latitude, longitude, housing_median_age, total_rooms, total_bedrooms, population, households, median_income):
    # Prepare the input features
    features = [[longitude, latitude, housing_median_age, total_rooms, total_bedrooms, population, households, median_income]]
    
    # Make predictions using the loaded model
    prediction = model.predict(features)
    
    # Return the predicted output
    return prediction[0]

# Create the input interface using Gradio
inputs = [
    gr.inputs.Number(label="Longitude"),
    gr.inputs.Number(label="Latitude"),
    gr.inputs.Number(label="Housing Median Age"),
    gr.inputs.Number(label="Total Rooms"),
    gr.inputs.Number(label="Total Bedrooms"),
    gr.inputs.Number(label="Population"),
    gr.inputs.Number(label="Households"),
    gr.inputs.Number(label="Median Income")
]

# Create the output interface using Gradio
output = gr.outputs.Label(num_top_classes=1)

# Define example data for demonstration
examples = [
    [37.88, -122.23, 41, 880, 129, 322, 126, 8.3252],
    [37.84, -122.27, 48, 1922, 409, 1026, 335, 1.7969],
    [37.83, -122.26, 52, 1656, 420, 718, 382, 2.6768]
]

# Create the Gradio interface
interface = gr.Interface(fn=predict, inputs=inputs, outputs=output, title="Decision Tree Predictor", examples=examples).launch()