import gradio as gr
from fastai.vision.all import *

def greet(name):
    return "Hello " + name + "!!"

learn = load_learner('export.pkl')

def pre(image):
  pilim= PILImageBW.create(image)
  t = learn.dls.test_dl([pilim], rm_type_tfms=None, num_workers=0)
  p,_,d= learn.get_preds(dl=t,with_decoded=True)
  return p.argmax().item()

title = "Hand written Digit Classifier"
description = " A Basic CNN trained on MNSIT Dataset using Pytorch and Fast.ai. It achieved an accuracy of 99.2 %.<br> This is my first app so i could not properly convert the image from the sketchpad to a proper 28*28 pixel image as in MNSIT database. Hence, please try to draw the digits big and in center for best accuracy. "

iface = gr.Interface(fn=pre, inputs="sketchpad", outputs="text",title=title,description=description)
iface.launch()