import gradio as gr
from fastai.text.all import *

def greet(name):
    return "Hello " + name + "!!"

sample_reviews = ["""Top Gun (1986) made Tom Cruise a star, and now 36 years later he jumps back in role of Pete Mitchell AKA Maverick almost like he never left.Maverick never seems let his age slow him down, and still is cocky has ever, and is ordered to train a bunch of young pilots for a deadly mission, but sees a little bit of himself in them, and must get them working together has a team.
Tom Cruise is great has Maverick, who is coming to terms with the past. Miles Teller and Glen Powell are also great, and not to mention Jennifer Connelly. But the flying scenes are what makes this movie, you feel like your flying with them. Feels has real has ever. A terrific sequel 36 years worth the wait."""
,"""Brahmastra is good to watch for 3d only if you are in for visual treat attempted by Bollywood but that's all I have to say.In terms of storyline it lacks what Karthikeya 2 was able to achieve with its storyline and narration.
Songs are good too but I am really amazed when I see that director took so long but the storyline after interval went boring.
My verdict that Bollywood needs to come out of Love story mode and present more logical and reasoning along with joyful moments depiction in their movie.
Movie is ok for 1 time watch for the visual treat whoch Ayan mukherji tried and for the efforts."""]


title = "IMDB Reviews Sentiment Classifier"

description = """A movie review sentiment classifier using the ULMFit ( A transfer learning approach ) on the AWD_LSTM Architecture, Achieved an accuracy of 94.7 %

  Github : https://github.com/ferno9/IMDB_SentimentAnalysis"""

learn = load_learner('export_sentiment_imdb.pkl')
classes = ["Negative","Positive"]
def predict(review):
    _,_,preds = learn.predict(review)

    return {classes[i] : float(preds[i]) for i in range(len(classes))}


iface = gr.Interface(fn=predict, inputs=gr.inputs.Textbox(), outputs=gr.outputs.Label(),examples=sample_reviews,title=title,description = description)
iface.launch()