import gradio as gr

viewer_html = """
<div id="loading" style="display:flex;justify-content:center;align-items:center">
<p style="padding:0.2rem 1rem 0 0;color:#c1c1c1; font-size:1rem">loading SMILES editor</p>
<svg version="1.1" id="L4" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
  viewBox="0 0 100 100" enable-background="new 0 0 0 0" xml:space="preserve" width="5rem">
  <circle fill="#FF7C00" stroke="none" cx="6" cy="50" r="6">
    <animate
      attributeName="opacity"
      dur="1s"
      values="0;1;0"
      repeatCount="indefinite"
      begin="0.1"/>    
  </circle>
  <circle fill="#FF7C00" stroke="none" cx="26" cy="50" r="6">
    <animate
      attributeName="opacity"
      dur="1s"
      values="0;1;0"
      repeatCount="indefinite" 
      begin="0.2"/>       
  </circle>
  <circle fill="#FF7C00" stroke="none" cx="46" cy="50" r="6">
    <animate
      attributeName="opacity"
      dur="1s"
      values="0;1;0"
      repeatCount="indefinite" 
      begin="0.3"/>     
  </circle>
</svg>
 </div>
    <div id="root"></div>
"""


load_js = """
async () => {
var loadingDiv = document.getElementById('loading');
  loadingDiv.style.display = 'flex';

//load css
 let url = "https://huggingface.co/datasets/simonduerr/ketcher-2.7.2/raw/main/static/css/main.6a646761.css"
fetch(url)
  .then(res => res.text())
  .then(text => {
    const style = document.createElement('style');
    style.textContent = text
    document.head.appendChild(style);

  });
//load ketcher  
url = "https://huggingface.co/datasets/simonduerr/ketcher-2.7.2/resolve/main/static/js/main.5445f351.js"
fetch(url)
  .then(res => res.text())
  .then(text => {
    const script = document.createElement('script');
    //script.type = "module"
    script.src = URL.createObjectURL(new Blob([text], { type: 'application/javascript' }));
    document.head.appendChild(script);
    loadingDiv.style.display = 'none';
  });
 

}
"""

# add your logic here, hidden_state contains the SMILES string returned from Editor
def run(hidden_state):
    return f"{hidden_state}"

get_js = """
async () => {
  return ketcher.getSmiles().then(function(smiFile){return smiFile})
  }
"""



with gr.Blocks() as blocks:
    gr.Markdown("""
        # Gradio Molecule entry with Ketcher
    """)
    html = gr.HTML(viewer_html)
    #do not change this part
    hidden_state = gr.Textbox(visible=False)
    # we need a hidden textbox that can be used to first trigger the JS callback 
    # and then onchange of the textbox, we can run the python function
    out = gr.Textbox("", label="SMILES")
    btn = gr.Button("Get SMILES")
    # trigger JS callback and written to hidden textbox
    btn.click(fn=None,
                     inputs=[],
                     outputs=[hidden_state],
                     _js=get_js)
    # run python function on change of hidden textbox, add your logic to run function
    hidden_state.change(fn=run, inputs=[hidden_state], outputs=[out])
    # load JS on load of the page
    blocks.load(None, None, None, _js=load_js)

blocks.launch()
