import gradio as gr
from inference import infer
import numpy as np

spkdict=np.arange(175).tolist()
spkdict=['speaker'+str(spk) for spk in spkdict]

app = gr.Blocks()
with app:
    with gr.Tabs():
        with gr.TabItem("Basic"):
            gr.Markdown(value="""
            本模型为基于soft-vc和vits的AI声线转换模型。\n
            模型混合了aishell3（174说话人，共约80+h）和opencpop（1说话人，5+h）数据集训练，用A100单卡在60batchsize下训练了350左右epoch得到的。\n
            模型对于通常的说话语音转换效果良好，唱歌的话需要在目标说话人音域范围内才能有较好效果。由于aishell3数据占比过大，训练epoch不足，opencpop说话人的高音部分质量不佳。\n
            模型中各说话人的适宜中心音域分别为：\n
            aishell3(0-173号) 女性说话：A3,男性说话：C3\n
            opencpop(174号)   女性唱歌：C4-G4（超过C5基本失真）\n
            如果转换通常说话音频，需要参考上面范围调key至目标说话人中心音域附近(如男性说话转为女性说话，key=8，反过来为-8(4-16这个区间基本都可以试试))\n
            如果源音频为部分虚拟主播音频，通常音调会高于正常女性说话范围，可达到F4-A4左右，请适当降调\n
            对于说话人的详细信息(如性别、年龄等)，可以在文件目录的spkdic_new.json中查看\n
            \n
            若合成效果不佳请首先考虑如下因素加以改善：\n
            1.音域范围是否合适，可参考上文调整调key的参数，或更换说话人进行尝试\n
            2.源音频是否存在杂音/bgm，请尽量使用干净的音源进行合成，录音时保持室内安静\n
            3.源音频是否存在混响。较强的混响会显著干扰合成效果，导致ai念错字/音调识别错误等\n
            4.再合成一次试试，每次合成会有部分随机性因素参与，微小的声调问题可能重新合成一次就不存在了。\n
            5.部分对源音频的消伴奏/降噪处理会对合成效果有较大影响，虽然人听不出差别，但是对ai识别的频谱有影响。
            """)
            sid = gr.Dropdown(label="说话人",choices=spkdict, value='speaker0')
            vc_audio = gr.Audio(label="上传音频,建议小于2分钟",type='filepath')
            vc_record = gr.Audio(source="microphone", label="或者录制你的声音", type="filepath")
            vc_transform = gr.Number(label="调key（按照十二平均律确定的半音，一整个8度就是12）",value=0)
            vc_submit = gr.Button("转换", variant="primary")
            vc_output1 = gr.Textbox(label="Output Message")
            vc_output2 = gr.Audio(label="Output Audio")
        vc_submit.click(infer, [vc_audio,vc_record,sid, vc_transform], [vc_output1, vc_output2])

    app.launch()