import gradio as gr

import git

git.Git().clone("https://github.com/Jesse-zj/bobo-test.git")

from llama_index import SimpleDirectoryReader, GPTListIndex, readers, GPTVectorStoreIndex, LLMPredictor, PromptHelper,ServiceContext
from llama_index import StorageContext, load_index_from_storage
from langchain import OpenAI
import sys
import os
from IPython.display import Markdown, display

openai_api_key = os.environ['OPENAI_API_KEY']

def construct_index(directory_path):
    # set maximum input size
    max_input_size = 4096
    # set number of output tokens
    num_outputs = 1000
    # set maximum chunk overlap
    max_chunk_overlap = 30
    # set chunk size limit
    chunk_size_limit = 600 

    # define LLM
    llm_predictor = LLMPredictor(llm=OpenAI(temperature=0.5, model_name="text-davinci-003", max_tokens=num_outputs))
    prompt_helper = PromptHelper(max_input_size, num_outputs, max_chunk_overlap, chunk_size_limit=chunk_size_limit)
 
    documents = SimpleDirectoryReader(directory_path).load_data()

    service_context = ServiceContext.from_defaults(llm_predictor=llm_predictor, prompt_helper=prompt_helper)
    
    index = GPTVectorStoreIndex.from_documents(
        documents, service_context=service_context
    )

    index.storage_context.persist('index.json')

    return index

def ask_ai(query):
    # set maximum input size
    max_input_size = 4096
    # set number of output tokens
    num_outputs = 1000
    # set maximum chunk overlap
    max_chunk_overlap = 30
    # set chunk size limit
    chunk_size_limit = 600 

    # define LLM
    llm_predictor = LLMPredictor(llm=OpenAI(temperature=0.5, model_name="text-davinci-003", max_tokens=num_outputs))
    prompt_helper = PromptHelper(max_input_size, num_outputs, max_chunk_overlap, chunk_size_limit=chunk_size_limit)
    
    service_context = ServiceContext.from_defaults(llm_predictor=llm_predictor, prompt_helper=prompt_helper)
    # rebuild storage context
    storage_context = StorageContext.from_defaults(persist_dir="index.json")
    # load index
    index = load_index_from_storage(storage_context, service_context=service_context)
    
    query_engine = index.as_query_engine()
    response = query_engine.query(query)
    return str(response)
    

construct_index('bobo-test')

iface = gr.Interface(fn=ask_ai, inputs="textbox", outputs="text")
iface.launch()
