import gradio as gr
import util
import process_image
from run_cmd import run_cmd

is_colab = util.is_google_colab()

css = '''
    .file-preview {
        overflow: hidden !important;
        margin: 5px 0 !important;
        padding: 0 10px !important;
    }

    .file-preview div div:nth-child(2) {
        flex-grow: 1 !important;
    }

    .file-preview div div:nth-child(3) {
        text-align: right !important;
        padding: 0.5rem 0;
        width: auto;
    }

    #preview_file .h-full.min-h-\[15rem\].flex.justify-center.items-center {
        min-height: initial !important;
        padding: 10px 0;
    }

    #preview_file a {
        border-radius: 0.5rem;
        padding-top: 0.5rem;
        padding-bottom: 0.5rem;
        padding-left: 1rem;
        padding-right: 1rem;
        font-size: 1rem;
        line-height: 1.5rem;
        font-weight: 600;
        color: white;
        background-color: gray;
    }

    .colab_img {
        margin: 10px 0;
        display: inline-block;
        margin: 0 10px;
    }
'''

title = "ESRGAN Upscaling With Custom Models"

with gr.Blocks(title=title, css=css) as demo:
    gr.Markdown(
    f"""
    # {title}
    This space uses old ESRGAN architecture to upscale images, using models made by the community.

    Once the photo upscaled (*it can take a long time, this space only uses CPU*).
    """)

    gr.HTML(value="For faster upscaling using GPU: <a href='https://colab.research.google.com/drive/1QfOA6BBdL4NrUmx-9d-pjacxNfu81HQo#scrollTo=H7qo-6AWFbLH' target='_blank'><img class='colab_img' src='https://colab.research.google.com/assets/colab-badge.svg' alt='Open In Colab'></a> buy me a coffee (beer) if this helped 🍺😁")

    gr.HTML(value="<a href='https://ko-fi.com/Y8Y7GVAAF' target='_blank' style='display:block;margin-bottom:5px'><img height='36' style='border:0px;height:36px;' src='https://storage.ko-fi.com/cdn/kofi1.png?v=3' border='0' alt='Buy Me a Coffee at ko-fi.com' /></a>")

    with gr.Box():
        with gr.Row():
            with gr.Column():
                input_image = gr.Image(type="pil", label="Input")
                upscale_size = gr.Radio(["x4", "x2"], label="Upscale by:", value="x4")
                upscale_type = gr.Radio(["Manga", "Anime", "Photo", "General"], label="Select the type of picture you want to upscale:", value="Manga")

                with gr.Row():
                    upscale_btn = gr.Button(value="Upscale", variant="primary")

            with gr.Column():
                output_image = gr.Image(type="filepath", interactive=False, label="Upscaled image", elem_id="preview_img")
                
                with gr.Row():
                    out_file = gr.File(interactive=False, show_label=False, elem_id="preview_file")

    gr.HTML(value="<p><a href='https://upscale.wiki/wiki/Model_Database'>Model Database</a></p>")
        
    upscale_btn.click(process_image.inference, inputs=[input_image, upscale_size, upscale_type], outputs=[output_image, out_file])

demo.queue()
demo.launch(debug=is_colab, share=is_colab, inline=is_colab)