import gradio as gr
from transformers import MBartTokenizer, MBartForConditionalGeneration

model_name = "IlyaGusev/mbart_ru_sum_gazeta"
tokenizer = MBartTokenizer.from_pretrained(model_name)
model = MBartForConditionalGeneration.from_pretrained(model_name)

def summarize(text):
  input_ids = tokenizer.batch_encode_plus([text], return_tensors="pt", max_length=1024)["input_ids"].to(model.device)
  summary_ids = model.generate(input_ids=input_ids, no_repeat_ngram_size=4)
  return tokenizer.decode(summary_ids[0], skip_special_tokens=True)

gr.Interface(fn=summarize, inputs="text", outputs="text", description="Russian Summarizer").launch()