// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: databricks_artifacts.proto

package com.databricks.api.proto.mlflow;

public final class DatabricksArtifacts {
  private DatabricksArtifacts() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   * <pre>
   * The type of a given artifact access credential
   * </pre>
   *
   * Protobuf enum {@code mlflow.ArtifactCredentialType}
   */
  public enum ArtifactCredentialType
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * The credential is an Azure Shared Access Signature URI. For more information, see
     * https://docs.microsoft.com/en-us/azure/storage/common/storage-sas-overview
     * </pre>
     *
     * <code>AZURE_SAS_URI = 1;</code>
     */
    AZURE_SAS_URI(1),
    /**
     * <pre>
     * The credential is an AWS Presigned URL. For more information, see
     * https://docs.aws.amazon.com/AmazonS3/latest/dev/ShareObjectPreSignedURL.html
     * </pre>
     *
     * <code>AWS_PRESIGNED_URL = 2;</code>
     */
    AWS_PRESIGNED_URL(2),
    /**
     * <pre>
     * The credential is a GCP Signed URL. For more information, see
     * https://cloud.google.com/storage/docs/access-control/signed-urls
     * </pre>
     *
     * <code>GCP_SIGNED_URL = 3;</code>
     */
    GCP_SIGNED_URL(3),
    ;

    /**
     * <pre>
     * The credential is an Azure Shared Access Signature URI. For more information, see
     * https://docs.microsoft.com/en-us/azure/storage/common/storage-sas-overview
     * </pre>
     *
     * <code>AZURE_SAS_URI = 1;</code>
     */
    public static final int AZURE_SAS_URI_VALUE = 1;
    /**
     * <pre>
     * The credential is an AWS Presigned URL. For more information, see
     * https://docs.aws.amazon.com/AmazonS3/latest/dev/ShareObjectPreSignedURL.html
     * </pre>
     *
     * <code>AWS_PRESIGNED_URL = 2;</code>
     */
    public static final int AWS_PRESIGNED_URL_VALUE = 2;
    /**
     * <pre>
     * The credential is a GCP Signed URL. For more information, see
     * https://cloud.google.com/storage/docs/access-control/signed-urls
     * </pre>
     *
     * <code>GCP_SIGNED_URL = 3;</code>
     */
    public static final int GCP_SIGNED_URL_VALUE = 3;


    public final int getNumber() {
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ArtifactCredentialType valueOf(int value) {
      return forNumber(value);
    }

    public static ArtifactCredentialType forNumber(int value) {
      switch (value) {
        case 1: return AZURE_SAS_URI;
        case 2: return AWS_PRESIGNED_URL;
        case 3: return GCP_SIGNED_URL;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ArtifactCredentialType>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        ArtifactCredentialType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ArtifactCredentialType>() {
            public ArtifactCredentialType findValueByNumber(int number) {
              return ArtifactCredentialType.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.databricks.api.proto.mlflow.DatabricksArtifacts.getDescriptor().getEnumTypes().get(0);
    }

    private static final ArtifactCredentialType[] VALUES = values();

    public static ArtifactCredentialType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ArtifactCredentialType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:mlflow.ArtifactCredentialType)
  }

  public interface ArtifactCredentialInfoOrBuilder extends
      // @@protoc_insertion_point(interface_extends:mlflow.ArtifactCredentialInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * The ID of the MLflow Run containing the artifact that can be accessed
     * with the credential
     * </pre>
     *
     * <code>optional string run_id = 1;</code>
     */
    boolean hasRunId();
    /**
     * <pre>
     * The ID of the MLflow Run containing the artifact that can be accessed
     * with the credential
     * </pre>
     *
     * <code>optional string run_id = 1;</code>
     */
    java.lang.String getRunId();
    /**
     * <pre>
     * The ID of the MLflow Run containing the artifact that can be accessed
     * with the credential
     * </pre>
     *
     * <code>optional string run_id = 1;</code>
     */
    com.google.protobuf.ByteString
        getRunIdBytes();

    /**
     * <pre>
     * The path, relative to the Run's artifact root location, of the artifact
     * that can be accessed with the credential
     * </pre>
     *
     * <code>optional string path = 2;</code>
     */
    boolean hasPath();
    /**
     * <pre>
     * The path, relative to the Run's artifact root location, of the artifact
     * that can be accessed with the credential
     * </pre>
     *
     * <code>optional string path = 2;</code>
     */
    java.lang.String getPath();
    /**
     * <pre>
     * The path, relative to the Run's artifact root location, of the artifact
     * that can be accessed with the credential
     * </pre>
     *
     * <code>optional string path = 2;</code>
     */
    com.google.protobuf.ByteString
        getPathBytes();

    /**
     * <pre>
     * The signed URI credential that provides access to the artifact
     * </pre>
     *
     * <code>optional string signed_uri = 3;</code>
     */
    boolean hasSignedUri();
    /**
     * <pre>
     * The signed URI credential that provides access to the artifact
     * </pre>
     *
     * <code>optional string signed_uri = 3;</code>
     */
    java.lang.String getSignedUri();
    /**
     * <pre>
     * The signed URI credential that provides access to the artifact
     * </pre>
     *
     * <code>optional string signed_uri = 3;</code>
     */
    com.google.protobuf.ByteString
        getSignedUriBytes();

    /**
     * <pre>
     * A collection of HTTP headers that should be specified when uploading to
     * or downloading from the specified `signed_uri`
     * </pre>
     *
     * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
     */
    java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader> 
        getHeadersList();
    /**
     * <pre>
     * A collection of HTTP headers that should be specified when uploading to
     * or downloading from the specified `signed_uri`
     * </pre>
     *
     * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
     */
    com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader getHeaders(int index);
    /**
     * <pre>
     * A collection of HTTP headers that should be specified when uploading to
     * or downloading from the specified `signed_uri`
     * </pre>
     *
     * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
     */
    int getHeadersCount();
    /**
     * <pre>
     * A collection of HTTP headers that should be specified when uploading to
     * or downloading from the specified `signed_uri`
     * </pre>
     *
     * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
     */
    java.util.List<? extends com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeaderOrBuilder> 
        getHeadersOrBuilderList();
    /**
     * <pre>
     * A collection of HTTP headers that should be specified when uploading to
     * or downloading from the specified `signed_uri`
     * </pre>
     *
     * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
     */
    com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeaderOrBuilder getHeadersOrBuilder(
        int index);

    /**
     * <pre>
     * The type of the signed credential URI (e.g., an AWS presigned URL
     * or an Azure Shared Access Signature URI)
     * </pre>
     *
     * <code>optional .mlflow.ArtifactCredentialType type = 5;</code>
     */
    boolean hasType();
    /**
     * <pre>
     * The type of the signed credential URI (e.g., an AWS presigned URL
     * or an Azure Shared Access Signature URI)
     * </pre>
     *
     * <code>optional .mlflow.ArtifactCredentialType type = 5;</code>
     */
    com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialType getType();
  }
  /**
   * Protobuf type {@code mlflow.ArtifactCredentialInfo}
   */
  public  static final class ArtifactCredentialInfo extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:mlflow.ArtifactCredentialInfo)
      ArtifactCredentialInfoOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use ArtifactCredentialInfo.newBuilder() to construct.
    private ArtifactCredentialInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private ArtifactCredentialInfo() {
      runId_ = "";
      path_ = "";
      signedUri_ = "";
      headers_ = java.util.Collections.emptyList();
      type_ = 1;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private ArtifactCredentialInfo(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              runId_ = bs;
              break;
            }
            case 18: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000002;
              path_ = bs;
              break;
            }
            case 26: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000004;
              signedUri_ = bs;
              break;
            }
            case 34: {
              if (!((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
                headers_ = new java.util.ArrayList<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader>();
                mutable_bitField0_ |= 0x00000008;
              }
              headers_.add(
                  input.readMessage(com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.PARSER, extensionRegistry));
              break;
            }
            case 40: {
              int rawValue = input.readEnum();
                @SuppressWarnings("deprecation")
              com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialType value = com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialType.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(5, rawValue);
              } else {
                bitField0_ |= 0x00000008;
                type_ = rawValue;
              }
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
          headers_ = java.util.Collections.unmodifiableList(headers_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_ArtifactCredentialInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_ArtifactCredentialInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder.class);
    }

    public interface HttpHeaderOrBuilder extends
        // @@protoc_insertion_point(interface_extends:mlflow.ArtifactCredentialInfo.HttpHeader)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * The HTTP header name
       * </pre>
       *
       * <code>optional string name = 1;</code>
       */
      boolean hasName();
      /**
       * <pre>
       * The HTTP header name
       * </pre>
       *
       * <code>optional string name = 1;</code>
       */
      java.lang.String getName();
      /**
       * <pre>
       * The HTTP header name
       * </pre>
       *
       * <code>optional string name = 1;</code>
       */
      com.google.protobuf.ByteString
          getNameBytes();

      /**
       * <pre>
       * The HTTP header value
       * </pre>
       *
       * <code>optional string value = 2;</code>
       */
      boolean hasValue();
      /**
       * <pre>
       * The HTTP header value
       * </pre>
       *
       * <code>optional string value = 2;</code>
       */
      java.lang.String getValue();
      /**
       * <pre>
       * The HTTP header value
       * </pre>
       *
       * <code>optional string value = 2;</code>
       */
      com.google.protobuf.ByteString
          getValueBytes();
    }
    /**
     * Protobuf type {@code mlflow.ArtifactCredentialInfo.HttpHeader}
     */
    public  static final class HttpHeader extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:mlflow.ArtifactCredentialInfo.HttpHeader)
        HttpHeaderOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use HttpHeader.newBuilder() to construct.
      private HttpHeader(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private HttpHeader() {
        name_ = "";
        value_ = "";
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private HttpHeader(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000001;
                name_ = bs;
                break;
              }
              case 18: {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000002;
                value_ = bs;
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_ArtifactCredentialInfo_HttpHeader_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_ArtifactCredentialInfo_HttpHeader_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.Builder.class);
      }

      private int bitField0_;
      public static final int NAME_FIELD_NUMBER = 1;
      private volatile java.lang.Object name_;
      /**
       * <pre>
       * The HTTP header name
       * </pre>
       *
       * <code>optional string name = 1;</code>
       */
      public boolean hasName() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <pre>
       * The HTTP header name
       * </pre>
       *
       * <code>optional string name = 1;</code>
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            name_ = s;
          }
          return s;
        }
      }
      /**
       * <pre>
       * The HTTP header name
       * </pre>
       *
       * <code>optional string name = 1;</code>
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int VALUE_FIELD_NUMBER = 2;
      private volatile java.lang.Object value_;
      /**
       * <pre>
       * The HTTP header value
       * </pre>
       *
       * <code>optional string value = 2;</code>
       */
      public boolean hasValue() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <pre>
       * The HTTP header value
       * </pre>
       *
       * <code>optional string value = 2;</code>
       */
      public java.lang.String getValue() {
        java.lang.Object ref = value_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            value_ = s;
          }
          return s;
        }
      }
      /**
       * <pre>
       * The HTTP header value
       * </pre>
       *
       * <code>optional string value = 2;</code>
       */
      public com.google.protobuf.ByteString
          getValueBytes() {
        java.lang.Object ref = value_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          value_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (((bitField0_ & 0x00000001) == 0x00000001)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
        }
        if (((bitField0_ & 0x00000002) == 0x00000002)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, value_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) == 0x00000001)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
        }
        if (((bitField0_ & 0x00000002) == 0x00000002)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, value_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader)) {
          return super.equals(obj);
        }
        com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader other = (com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader) obj;

        boolean result = true;
        result = result && (hasName() == other.hasName());
        if (hasName()) {
          result = result && getName()
              .equals(other.getName());
        }
        result = result && (hasValue() == other.hasValue());
        if (hasValue()) {
          result = result && getValue()
              .equals(other.getValue());
        }
        result = result && unknownFields.equals(other.unknownFields);
        return result;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasName()) {
          hash = (37 * hash) + NAME_FIELD_NUMBER;
          hash = (53 * hash) + getName().hashCode();
        }
        if (hasValue()) {
          hash = (37 * hash) + VALUE_FIELD_NUMBER;
          hash = (53 * hash) + getValue().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code mlflow.ArtifactCredentialInfo.HttpHeader}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:mlflow.ArtifactCredentialInfo.HttpHeader)
          com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeaderOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_ArtifactCredentialInfo_HttpHeader_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_ArtifactCredentialInfo_HttpHeader_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.Builder.class);
        }

        // Construct using com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          name_ = "";
          bitField0_ = (bitField0_ & ~0x00000001);
          value_ = "";
          bitField0_ = (bitField0_ & ~0x00000002);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_ArtifactCredentialInfo_HttpHeader_descriptor;
        }

        @java.lang.Override
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader getDefaultInstanceForType() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.getDefaultInstance();
        }

        @java.lang.Override
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader build() {
          com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader buildPartial() {
          com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader result = new com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader(this);
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
            to_bitField0_ |= 0x00000001;
          }
          result.name_ = name_;
          if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
            to_bitField0_ |= 0x00000002;
          }
          result.value_ = value_;
          result.bitField0_ = to_bitField0_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return (Builder) super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return (Builder) super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return (Builder) super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return (Builder) super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return (Builder) super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return (Builder) super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader) {
            return mergeFrom((com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader other) {
          if (other == com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.getDefaultInstance()) return this;
          if (other.hasName()) {
            bitField0_ |= 0x00000001;
            name_ = other.name_;
            onChanged();
          }
          if (other.hasValue()) {
            bitField0_ |= 0x00000002;
            value_ = other.value_;
            onChanged();
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        private int bitField0_;

        private java.lang.Object name_ = "";
        /**
         * <pre>
         * The HTTP header name
         * </pre>
         *
         * <code>optional string name = 1;</code>
         */
        public boolean hasName() {
          return ((bitField0_ & 0x00000001) == 0x00000001);
        }
        /**
         * <pre>
         * The HTTP header name
         * </pre>
         *
         * <code>optional string name = 1;</code>
         */
        public java.lang.String getName() {
          java.lang.Object ref = name_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              name_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * The HTTP header name
         * </pre>
         *
         * <code>optional string name = 1;</code>
         */
        public com.google.protobuf.ByteString
            getNameBytes() {
          java.lang.Object ref = name_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            name_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * The HTTP header name
         * </pre>
         *
         * <code>optional string name = 1;</code>
         */
        public Builder setName(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
          name_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * The HTTP header name
         * </pre>
         *
         * <code>optional string name = 1;</code>
         */
        public Builder clearName() {
          bitField0_ = (bitField0_ & ~0x00000001);
          name_ = getDefaultInstance().getName();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * The HTTP header name
         * </pre>
         *
         * <code>optional string name = 1;</code>
         */
        public Builder setNameBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
          name_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object value_ = "";
        /**
         * <pre>
         * The HTTP header value
         * </pre>
         *
         * <code>optional string value = 2;</code>
         */
        public boolean hasValue() {
          return ((bitField0_ & 0x00000002) == 0x00000002);
        }
        /**
         * <pre>
         * The HTTP header value
         * </pre>
         *
         * <code>optional string value = 2;</code>
         */
        public java.lang.String getValue() {
          java.lang.Object ref = value_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              value_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * The HTTP header value
         * </pre>
         *
         * <code>optional string value = 2;</code>
         */
        public com.google.protobuf.ByteString
            getValueBytes() {
          java.lang.Object ref = value_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            value_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * The HTTP header value
         * </pre>
         *
         * <code>optional string value = 2;</code>
         */
        public Builder setValue(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
          value_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * The HTTP header value
         * </pre>
         *
         * <code>optional string value = 2;</code>
         */
        public Builder clearValue() {
          bitField0_ = (bitField0_ & ~0x00000002);
          value_ = getDefaultInstance().getValue();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * The HTTP header value
         * </pre>
         *
         * <code>optional string value = 2;</code>
         */
        public Builder setValueBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
          value_ = value;
          onChanged();
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:mlflow.ArtifactCredentialInfo.HttpHeader)
      }

      // @@protoc_insertion_point(class_scope:mlflow.ArtifactCredentialInfo.HttpHeader)
      private static final com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader();
      }

      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      @java.lang.Deprecated public static final com.google.protobuf.Parser<HttpHeader>
          PARSER = new com.google.protobuf.AbstractParser<HttpHeader>() {
        @java.lang.Override
        public HttpHeader parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new HttpHeader(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<HttpHeader> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<HttpHeader> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    private int bitField0_;
    public static final int RUN_ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object runId_;
    /**
     * <pre>
     * The ID of the MLflow Run containing the artifact that can be accessed
     * with the credential
     * </pre>
     *
     * <code>optional string run_id = 1;</code>
     */
    public boolean hasRunId() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <pre>
     * The ID of the MLflow Run containing the artifact that can be accessed
     * with the credential
     * </pre>
     *
     * <code>optional string run_id = 1;</code>
     */
    public java.lang.String getRunId() {
      java.lang.Object ref = runId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          runId_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * The ID of the MLflow Run containing the artifact that can be accessed
     * with the credential
     * </pre>
     *
     * <code>optional string run_id = 1;</code>
     */
    public com.google.protobuf.ByteString
        getRunIdBytes() {
      java.lang.Object ref = runId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        runId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PATH_FIELD_NUMBER = 2;
    private volatile java.lang.Object path_;
    /**
     * <pre>
     * The path, relative to the Run's artifact root location, of the artifact
     * that can be accessed with the credential
     * </pre>
     *
     * <code>optional string path = 2;</code>
     */
    public boolean hasPath() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <pre>
     * The path, relative to the Run's artifact root location, of the artifact
     * that can be accessed with the credential
     * </pre>
     *
     * <code>optional string path = 2;</code>
     */
    public java.lang.String getPath() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          path_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * The path, relative to the Run's artifact root location, of the artifact
     * that can be accessed with the credential
     * </pre>
     *
     * <code>optional string path = 2;</code>
     */
    public com.google.protobuf.ByteString
        getPathBytes() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        path_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SIGNED_URI_FIELD_NUMBER = 3;
    private volatile java.lang.Object signedUri_;
    /**
     * <pre>
     * The signed URI credential that provides access to the artifact
     * </pre>
     *
     * <code>optional string signed_uri = 3;</code>
     */
    public boolean hasSignedUri() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <pre>
     * The signed URI credential that provides access to the artifact
     * </pre>
     *
     * <code>optional string signed_uri = 3;</code>
     */
    public java.lang.String getSignedUri() {
      java.lang.Object ref = signedUri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          signedUri_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * The signed URI credential that provides access to the artifact
     * </pre>
     *
     * <code>optional string signed_uri = 3;</code>
     */
    public com.google.protobuf.ByteString
        getSignedUriBytes() {
      java.lang.Object ref = signedUri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        signedUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int HEADERS_FIELD_NUMBER = 4;
    private java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader> headers_;
    /**
     * <pre>
     * A collection of HTTP headers that should be specified when uploading to
     * or downloading from the specified `signed_uri`
     * </pre>
     *
     * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
     */
    public java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader> getHeadersList() {
      return headers_;
    }
    /**
     * <pre>
     * A collection of HTTP headers that should be specified when uploading to
     * or downloading from the specified `signed_uri`
     * </pre>
     *
     * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
     */
    public java.util.List<? extends com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeaderOrBuilder> 
        getHeadersOrBuilderList() {
      return headers_;
    }
    /**
     * <pre>
     * A collection of HTTP headers that should be specified when uploading to
     * or downloading from the specified `signed_uri`
     * </pre>
     *
     * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
     */
    public int getHeadersCount() {
      return headers_.size();
    }
    /**
     * <pre>
     * A collection of HTTP headers that should be specified when uploading to
     * or downloading from the specified `signed_uri`
     * </pre>
     *
     * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
     */
    public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader getHeaders(int index) {
      return headers_.get(index);
    }
    /**
     * <pre>
     * A collection of HTTP headers that should be specified when uploading to
     * or downloading from the specified `signed_uri`
     * </pre>
     *
     * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
     */
    public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeaderOrBuilder getHeadersOrBuilder(
        int index) {
      return headers_.get(index);
    }

    public static final int TYPE_FIELD_NUMBER = 5;
    private int type_;
    /**
     * <pre>
     * The type of the signed credential URI (e.g., an AWS presigned URL
     * or an Azure Shared Access Signature URI)
     * </pre>
     *
     * <code>optional .mlflow.ArtifactCredentialType type = 5;</code>
     */
    public boolean hasType() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <pre>
     * The type of the signed credential URI (e.g., an AWS presigned URL
     * or an Azure Shared Access Signature URI)
     * </pre>
     *
     * <code>optional .mlflow.ArtifactCredentialType type = 5;</code>
     */
    public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialType getType() {
      @SuppressWarnings("deprecation")
      com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialType result = com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialType.valueOf(type_);
      return result == null ? com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialType.AZURE_SAS_URI : result;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, runId_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, path_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, signedUri_);
      }
      for (int i = 0; i < headers_.size(); i++) {
        output.writeMessage(4, headers_.get(i));
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeEnum(5, type_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, runId_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, path_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, signedUri_);
      }
      for (int i = 0; i < headers_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, headers_.get(i));
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(5, type_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo)) {
        return super.equals(obj);
      }
      com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo other = (com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo) obj;

      boolean result = true;
      result = result && (hasRunId() == other.hasRunId());
      if (hasRunId()) {
        result = result && getRunId()
            .equals(other.getRunId());
      }
      result = result && (hasPath() == other.hasPath());
      if (hasPath()) {
        result = result && getPath()
            .equals(other.getPath());
      }
      result = result && (hasSignedUri() == other.hasSignedUri());
      if (hasSignedUri()) {
        result = result && getSignedUri()
            .equals(other.getSignedUri());
      }
      result = result && getHeadersList()
          .equals(other.getHeadersList());
      result = result && (hasType() == other.hasType());
      if (hasType()) {
        result = result && type_ == other.type_;
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasRunId()) {
        hash = (37 * hash) + RUN_ID_FIELD_NUMBER;
        hash = (53 * hash) + getRunId().hashCode();
      }
      if (hasPath()) {
        hash = (37 * hash) + PATH_FIELD_NUMBER;
        hash = (53 * hash) + getPath().hashCode();
      }
      if (hasSignedUri()) {
        hash = (37 * hash) + SIGNED_URI_FIELD_NUMBER;
        hash = (53 * hash) + getSignedUri().hashCode();
      }
      if (getHeadersCount() > 0) {
        hash = (37 * hash) + HEADERS_FIELD_NUMBER;
        hash = (53 * hash) + getHeadersList().hashCode();
      }
      if (hasType()) {
        hash = (37 * hash) + TYPE_FIELD_NUMBER;
        hash = (53 * hash) + type_;
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code mlflow.ArtifactCredentialInfo}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:mlflow.ArtifactCredentialInfo)
        com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_ArtifactCredentialInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_ArtifactCredentialInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder.class);
      }

      // Construct using com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getHeadersFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        runId_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        path_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        signedUri_ = "";
        bitField0_ = (bitField0_ & ~0x00000004);
        if (headersBuilder_ == null) {
          headers_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          headersBuilder_.clear();
        }
        type_ = 1;
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_ArtifactCredentialInfo_descriptor;
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo getDefaultInstanceForType() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.getDefaultInstance();
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo build() {
        com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo buildPartial() {
        com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo result = new com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.runId_ = runId_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.path_ = path_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.signedUri_ = signedUri_;
        if (headersBuilder_ == null) {
          if (((bitField0_ & 0x00000008) == 0x00000008)) {
            headers_ = java.util.Collections.unmodifiableList(headers_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.headers_ = headers_;
        } else {
          result.headers_ = headersBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000008;
        }
        result.type_ = type_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo) {
          return mergeFrom((com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo other) {
        if (other == com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.getDefaultInstance()) return this;
        if (other.hasRunId()) {
          bitField0_ |= 0x00000001;
          runId_ = other.runId_;
          onChanged();
        }
        if (other.hasPath()) {
          bitField0_ |= 0x00000002;
          path_ = other.path_;
          onChanged();
        }
        if (other.hasSignedUri()) {
          bitField0_ |= 0x00000004;
          signedUri_ = other.signedUri_;
          onChanged();
        }
        if (headersBuilder_ == null) {
          if (!other.headers_.isEmpty()) {
            if (headers_.isEmpty()) {
              headers_ = other.headers_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureHeadersIsMutable();
              headers_.addAll(other.headers_);
            }
            onChanged();
          }
        } else {
          if (!other.headers_.isEmpty()) {
            if (headersBuilder_.isEmpty()) {
              headersBuilder_.dispose();
              headersBuilder_ = null;
              headers_ = other.headers_;
              bitField0_ = (bitField0_ & ~0x00000008);
              headersBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getHeadersFieldBuilder() : null;
            } else {
              headersBuilder_.addAllMessages(other.headers_);
            }
          }
        }
        if (other.hasType()) {
          setType(other.getType());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object runId_ = "";
      /**
       * <pre>
       * The ID of the MLflow Run containing the artifact that can be accessed
       * with the credential
       * </pre>
       *
       * <code>optional string run_id = 1;</code>
       */
      public boolean hasRunId() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <pre>
       * The ID of the MLflow Run containing the artifact that can be accessed
       * with the credential
       * </pre>
       *
       * <code>optional string run_id = 1;</code>
       */
      public java.lang.String getRunId() {
        java.lang.Object ref = runId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            runId_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * The ID of the MLflow Run containing the artifact that can be accessed
       * with the credential
       * </pre>
       *
       * <code>optional string run_id = 1;</code>
       */
      public com.google.protobuf.ByteString
          getRunIdBytes() {
        java.lang.Object ref = runId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          runId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * The ID of the MLflow Run containing the artifact that can be accessed
       * with the credential
       * </pre>
       *
       * <code>optional string run_id = 1;</code>
       */
      public Builder setRunId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        runId_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The ID of the MLflow Run containing the artifact that can be accessed
       * with the credential
       * </pre>
       *
       * <code>optional string run_id = 1;</code>
       */
      public Builder clearRunId() {
        bitField0_ = (bitField0_ & ~0x00000001);
        runId_ = getDefaultInstance().getRunId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The ID of the MLflow Run containing the artifact that can be accessed
       * with the credential
       * </pre>
       *
       * <code>optional string run_id = 1;</code>
       */
      public Builder setRunIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        runId_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object path_ = "";
      /**
       * <pre>
       * The path, relative to the Run's artifact root location, of the artifact
       * that can be accessed with the credential
       * </pre>
       *
       * <code>optional string path = 2;</code>
       */
      public boolean hasPath() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <pre>
       * The path, relative to the Run's artifact root location, of the artifact
       * that can be accessed with the credential
       * </pre>
       *
       * <code>optional string path = 2;</code>
       */
      public java.lang.String getPath() {
        java.lang.Object ref = path_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            path_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * The path, relative to the Run's artifact root location, of the artifact
       * that can be accessed with the credential
       * </pre>
       *
       * <code>optional string path = 2;</code>
       */
      public com.google.protobuf.ByteString
          getPathBytes() {
        java.lang.Object ref = path_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          path_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * The path, relative to the Run's artifact root location, of the artifact
       * that can be accessed with the credential
       * </pre>
       *
       * <code>optional string path = 2;</code>
       */
      public Builder setPath(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        path_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The path, relative to the Run's artifact root location, of the artifact
       * that can be accessed with the credential
       * </pre>
       *
       * <code>optional string path = 2;</code>
       */
      public Builder clearPath() {
        bitField0_ = (bitField0_ & ~0x00000002);
        path_ = getDefaultInstance().getPath();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The path, relative to the Run's artifact root location, of the artifact
       * that can be accessed with the credential
       * </pre>
       *
       * <code>optional string path = 2;</code>
       */
      public Builder setPathBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        path_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object signedUri_ = "";
      /**
       * <pre>
       * The signed URI credential that provides access to the artifact
       * </pre>
       *
       * <code>optional string signed_uri = 3;</code>
       */
      public boolean hasSignedUri() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <pre>
       * The signed URI credential that provides access to the artifact
       * </pre>
       *
       * <code>optional string signed_uri = 3;</code>
       */
      public java.lang.String getSignedUri() {
        java.lang.Object ref = signedUri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            signedUri_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * The signed URI credential that provides access to the artifact
       * </pre>
       *
       * <code>optional string signed_uri = 3;</code>
       */
      public com.google.protobuf.ByteString
          getSignedUriBytes() {
        java.lang.Object ref = signedUri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          signedUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * The signed URI credential that provides access to the artifact
       * </pre>
       *
       * <code>optional string signed_uri = 3;</code>
       */
      public Builder setSignedUri(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        signedUri_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The signed URI credential that provides access to the artifact
       * </pre>
       *
       * <code>optional string signed_uri = 3;</code>
       */
      public Builder clearSignedUri() {
        bitField0_ = (bitField0_ & ~0x00000004);
        signedUri_ = getDefaultInstance().getSignedUri();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The signed URI credential that provides access to the artifact
       * </pre>
       *
       * <code>optional string signed_uri = 3;</code>
       */
      public Builder setSignedUriBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        signedUri_ = value;
        onChanged();
        return this;
      }

      private java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader> headers_ =
        java.util.Collections.emptyList();
      private void ensureHeadersIsMutable() {
        if (!((bitField0_ & 0x00000008) == 0x00000008)) {
          headers_ = new java.util.ArrayList<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader>(headers_);
          bitField0_ |= 0x00000008;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.Builder, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeaderOrBuilder> headersBuilder_;

      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader> getHeadersList() {
        if (headersBuilder_ == null) {
          return java.util.Collections.unmodifiableList(headers_);
        } else {
          return headersBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public int getHeadersCount() {
        if (headersBuilder_ == null) {
          return headers_.size();
        } else {
          return headersBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader getHeaders(int index) {
        if (headersBuilder_ == null) {
          return headers_.get(index);
        } else {
          return headersBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public Builder setHeaders(
          int index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader value) {
        if (headersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureHeadersIsMutable();
          headers_.set(index, value);
          onChanged();
        } else {
          headersBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public Builder setHeaders(
          int index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.Builder builderForValue) {
        if (headersBuilder_ == null) {
          ensureHeadersIsMutable();
          headers_.set(index, builderForValue.build());
          onChanged();
        } else {
          headersBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public Builder addHeaders(com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader value) {
        if (headersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureHeadersIsMutable();
          headers_.add(value);
          onChanged();
        } else {
          headersBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public Builder addHeaders(
          int index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader value) {
        if (headersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureHeadersIsMutable();
          headers_.add(index, value);
          onChanged();
        } else {
          headersBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public Builder addHeaders(
          com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.Builder builderForValue) {
        if (headersBuilder_ == null) {
          ensureHeadersIsMutable();
          headers_.add(builderForValue.build());
          onChanged();
        } else {
          headersBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public Builder addHeaders(
          int index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.Builder builderForValue) {
        if (headersBuilder_ == null) {
          ensureHeadersIsMutable();
          headers_.add(index, builderForValue.build());
          onChanged();
        } else {
          headersBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public Builder addAllHeaders(
          java.lang.Iterable<? extends com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader> values) {
        if (headersBuilder_ == null) {
          ensureHeadersIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, headers_);
          onChanged();
        } else {
          headersBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public Builder clearHeaders() {
        if (headersBuilder_ == null) {
          headers_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          headersBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public Builder removeHeaders(int index) {
        if (headersBuilder_ == null) {
          ensureHeadersIsMutable();
          headers_.remove(index);
          onChanged();
        } else {
          headersBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.Builder getHeadersBuilder(
          int index) {
        return getHeadersFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeaderOrBuilder getHeadersOrBuilder(
          int index) {
        if (headersBuilder_ == null) {
          return headers_.get(index);  } else {
          return headersBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public java.util.List<? extends com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeaderOrBuilder> 
           getHeadersOrBuilderList() {
        if (headersBuilder_ != null) {
          return headersBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(headers_);
        }
      }
      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.Builder addHeadersBuilder() {
        return getHeadersFieldBuilder().addBuilder(
            com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.getDefaultInstance());
      }
      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.Builder addHeadersBuilder(
          int index) {
        return getHeadersFieldBuilder().addBuilder(
            index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.getDefaultInstance());
      }
      /**
       * <pre>
       * A collection of HTTP headers that should be specified when uploading to
       * or downloading from the specified `signed_uri`
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo.HttpHeader headers = 4;</code>
       */
      public java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.Builder> 
           getHeadersBuilderList() {
        return getHeadersFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.Builder, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeaderOrBuilder> 
          getHeadersFieldBuilder() {
        if (headersBuilder_ == null) {
          headersBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeader.Builder, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.HttpHeaderOrBuilder>(
                  headers_,
                  ((bitField0_ & 0x00000008) == 0x00000008),
                  getParentForChildren(),
                  isClean());
          headers_ = null;
        }
        return headersBuilder_;
      }

      private int type_ = 1;
      /**
       * <pre>
       * The type of the signed credential URI (e.g., an AWS presigned URL
       * or an Azure Shared Access Signature URI)
       * </pre>
       *
       * <code>optional .mlflow.ArtifactCredentialType type = 5;</code>
       */
      public boolean hasType() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       * <pre>
       * The type of the signed credential URI (e.g., an AWS presigned URL
       * or an Azure Shared Access Signature URI)
       * </pre>
       *
       * <code>optional .mlflow.ArtifactCredentialType type = 5;</code>
       */
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialType getType() {
        @SuppressWarnings("deprecation")
        com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialType result = com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialType.valueOf(type_);
        return result == null ? com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialType.AZURE_SAS_URI : result;
      }
      /**
       * <pre>
       * The type of the signed credential URI (e.g., an AWS presigned URL
       * or an Azure Shared Access Signature URI)
       * </pre>
       *
       * <code>optional .mlflow.ArtifactCredentialType type = 5;</code>
       */
      public Builder setType(com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000010;
        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The type of the signed credential URI (e.g., an AWS presigned URL
       * or an Azure Shared Access Signature URI)
       * </pre>
       *
       * <code>optional .mlflow.ArtifactCredentialType type = 5;</code>
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000010);
        type_ = 1;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:mlflow.ArtifactCredentialInfo)
    }

    // @@protoc_insertion_point(class_scope:mlflow.ArtifactCredentialInfo)
    private static final com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo();
    }

    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<ArtifactCredentialInfo>
        PARSER = new com.google.protobuf.AbstractParser<ArtifactCredentialInfo>() {
      @java.lang.Override
      public ArtifactCredentialInfo parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new ArtifactCredentialInfo(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<ArtifactCredentialInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ArtifactCredentialInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface GetCredentialsForReadOrBuilder extends
      // @@protoc_insertion_point(interface_extends:mlflow.GetCredentialsForRead)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * The ID of the MLflow Run for which to fetch artifact read credentials
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     */
    boolean hasRunId();
    /**
     * <pre>
     * The ID of the MLflow Run for which to fetch artifact read credentials
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     */
    java.lang.String getRunId();
    /**
     * <pre>
     * The ID of the MLflow Run for which to fetch artifact read credentials
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     */
    com.google.protobuf.ByteString
        getRunIdBytes();

    /**
     * <pre>
     * The artifact paths, relative to the Run's artifact root location, for which to
     * fetch artifact read credentials. Must not be empty.
     * </pre>
     *
     * <code>repeated string path = 2;</code>
     */
    java.util.List<java.lang.String>
        getPathList();
    /**
     * <pre>
     * The artifact paths, relative to the Run's artifact root location, for which to
     * fetch artifact read credentials. Must not be empty.
     * </pre>
     *
     * <code>repeated string path = 2;</code>
     */
    int getPathCount();
    /**
     * <pre>
     * The artifact paths, relative to the Run's artifact root location, for which to
     * fetch artifact read credentials. Must not be empty.
     * </pre>
     *
     * <code>repeated string path = 2;</code>
     */
    java.lang.String getPath(int index);
    /**
     * <pre>
     * The artifact paths, relative to the Run's artifact root location, for which to
     * fetch artifact read credentials. Must not be empty.
     * </pre>
     *
     * <code>repeated string path = 2;</code>
     */
    com.google.protobuf.ByteString
        getPathBytes(int index);

    /**
     * <pre>
     * Token specifying the page of credentials to fetch for large requests that require pagination
     * </pre>
     *
     * <code>optional string page_token = 3;</code>
     */
    boolean hasPageToken();
    /**
     * <pre>
     * Token specifying the page of credentials to fetch for large requests that require pagination
     * </pre>
     *
     * <code>optional string page_token = 3;</code>
     */
    java.lang.String getPageToken();
    /**
     * <pre>
     * Token specifying the page of credentials to fetch for large requests that require pagination
     * </pre>
     *
     * <code>optional string page_token = 3;</code>
     */
    com.google.protobuf.ByteString
        getPageTokenBytes();
  }
  /**
   * Protobuf type {@code mlflow.GetCredentialsForRead}
   */
  public  static final class GetCredentialsForRead extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:mlflow.GetCredentialsForRead)
      GetCredentialsForReadOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use GetCredentialsForRead.newBuilder() to construct.
    private GetCredentialsForRead(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private GetCredentialsForRead() {
      runId_ = "";
      path_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      pageToken_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private GetCredentialsForRead(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              runId_ = bs;
              break;
            }
            case 18: {
              com.google.protobuf.ByteString bs = input.readBytes();
              if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                path_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000002;
              }
              path_.add(bs);
              break;
            }
            case 26: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000002;
              pageToken_ = bs;
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
          path_ = path_.getUnmodifiableView();
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForRead_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForRead_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Builder.class);
    }

    public interface ResponseOrBuilder extends
        // @@protoc_insertion_point(interface_extends:mlflow.GetCredentialsForRead.Response)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * Credentials for reading from the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo> 
          getCredentialInfosList();
      /**
       * <pre>
       * Credentials for reading from the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo getCredentialInfos(int index);
      /**
       * <pre>
       * Credentials for reading from the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      int getCredentialInfosCount();
      /**
       * <pre>
       * Credentials for reading from the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      java.util.List<? extends com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder> 
          getCredentialInfosOrBuilderList();
      /**
       * <pre>
       * Credentials for reading from the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder getCredentialInfosOrBuilder(
          int index);

      /**
       * <pre>
       * Token used to fetch the next page of credentials for large requests that require pagination
       * </pre>
       *
       * <code>optional string next_page_token = 3;</code>
       */
      boolean hasNextPageToken();
      /**
       * <pre>
       * Token used to fetch the next page of credentials for large requests that require pagination
       * </pre>
       *
       * <code>optional string next_page_token = 3;</code>
       */
      java.lang.String getNextPageToken();
      /**
       * <pre>
       * Token used to fetch the next page of credentials for large requests that require pagination
       * </pre>
       *
       * <code>optional string next_page_token = 3;</code>
       */
      com.google.protobuf.ByteString
          getNextPageTokenBytes();
    }
    /**
     * Protobuf type {@code mlflow.GetCredentialsForRead.Response}
     */
    public  static final class Response extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:mlflow.GetCredentialsForRead.Response)
        ResponseOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Response.newBuilder() to construct.
      private Response(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Response() {
        credentialInfos_ = java.util.Collections.emptyList();
        nextPageToken_ = "";
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private Response(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18: {
                if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                  credentialInfos_ = new java.util.ArrayList<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo>();
                  mutable_bitField0_ |= 0x00000001;
                }
                credentialInfos_.add(
                    input.readMessage(com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.PARSER, extensionRegistry));
                break;
              }
              case 26: {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000001;
                nextPageToken_ = bs;
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
            credentialInfos_ = java.util.Collections.unmodifiableList(credentialInfos_);
          }
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForRead_Response_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForRead_Response_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response.Builder.class);
      }

      private int bitField0_;
      public static final int CREDENTIAL_INFOS_FIELD_NUMBER = 2;
      private java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo> credentialInfos_;
      /**
       * <pre>
       * Credentials for reading from the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      public java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo> getCredentialInfosList() {
        return credentialInfos_;
      }
      /**
       * <pre>
       * Credentials for reading from the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      public java.util.List<? extends com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder> 
          getCredentialInfosOrBuilderList() {
        return credentialInfos_;
      }
      /**
       * <pre>
       * Credentials for reading from the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      public int getCredentialInfosCount() {
        return credentialInfos_.size();
      }
      /**
       * <pre>
       * Credentials for reading from the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo getCredentialInfos(int index) {
        return credentialInfos_.get(index);
      }
      /**
       * <pre>
       * Credentials for reading from the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder getCredentialInfosOrBuilder(
          int index) {
        return credentialInfos_.get(index);
      }

      public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 3;
      private volatile java.lang.Object nextPageToken_;
      /**
       * <pre>
       * Token used to fetch the next page of credentials for large requests that require pagination
       * </pre>
       *
       * <code>optional string next_page_token = 3;</code>
       */
      public boolean hasNextPageToken() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <pre>
       * Token used to fetch the next page of credentials for large requests that require pagination
       * </pre>
       *
       * <code>optional string next_page_token = 3;</code>
       */
      public java.lang.String getNextPageToken() {
        java.lang.Object ref = nextPageToken_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            nextPageToken_ = s;
          }
          return s;
        }
      }
      /**
       * <pre>
       * Token used to fetch the next page of credentials for large requests that require pagination
       * </pre>
       *
       * <code>optional string next_page_token = 3;</code>
       */
      public com.google.protobuf.ByteString
          getNextPageTokenBytes() {
        java.lang.Object ref = nextPageToken_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          nextPageToken_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        for (int i = 0; i < credentialInfos_.size(); i++) {
          output.writeMessage(2, credentialInfos_.get(i));
        }
        if (((bitField0_ & 0x00000001) == 0x00000001)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, nextPageToken_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        for (int i = 0; i < credentialInfos_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(2, credentialInfos_.get(i));
        }
        if (((bitField0_ & 0x00000001) == 0x00000001)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, nextPageToken_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response)) {
          return super.equals(obj);
        }
        com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response other = (com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response) obj;

        boolean result = true;
        result = result && getCredentialInfosList()
            .equals(other.getCredentialInfosList());
        result = result && (hasNextPageToken() == other.hasNextPageToken());
        if (hasNextPageToken()) {
          result = result && getNextPageToken()
              .equals(other.getNextPageToken());
        }
        result = result && unknownFields.equals(other.unknownFields);
        return result;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getCredentialInfosCount() > 0) {
          hash = (37 * hash) + CREDENTIAL_INFOS_FIELD_NUMBER;
          hash = (53 * hash) + getCredentialInfosList().hashCode();
        }
        if (hasNextPageToken()) {
          hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
          hash = (53 * hash) + getNextPageToken().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code mlflow.GetCredentialsForRead.Response}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:mlflow.GetCredentialsForRead.Response)
          com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.ResponseOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForRead_Response_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForRead_Response_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response.Builder.class);
        }

        // Construct using com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
            getCredentialInfosFieldBuilder();
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          if (credentialInfosBuilder_ == null) {
            credentialInfos_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            credentialInfosBuilder_.clear();
          }
          nextPageToken_ = "";
          bitField0_ = (bitField0_ & ~0x00000002);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForRead_Response_descriptor;
        }

        @java.lang.Override
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response getDefaultInstanceForType() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response.getDefaultInstance();
        }

        @java.lang.Override
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response build() {
          com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response buildPartial() {
          com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response result = new com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response(this);
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (credentialInfosBuilder_ == null) {
            if (((bitField0_ & 0x00000001) == 0x00000001)) {
              credentialInfos_ = java.util.Collections.unmodifiableList(credentialInfos_);
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.credentialInfos_ = credentialInfos_;
          } else {
            result.credentialInfos_ = credentialInfosBuilder_.build();
          }
          if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
            to_bitField0_ |= 0x00000001;
          }
          result.nextPageToken_ = nextPageToken_;
          result.bitField0_ = to_bitField0_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return (Builder) super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return (Builder) super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return (Builder) super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return (Builder) super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return (Builder) super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return (Builder) super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response) {
            return mergeFrom((com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response other) {
          if (other == com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response.getDefaultInstance()) return this;
          if (credentialInfosBuilder_ == null) {
            if (!other.credentialInfos_.isEmpty()) {
              if (credentialInfos_.isEmpty()) {
                credentialInfos_ = other.credentialInfos_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureCredentialInfosIsMutable();
                credentialInfos_.addAll(other.credentialInfos_);
              }
              onChanged();
            }
          } else {
            if (!other.credentialInfos_.isEmpty()) {
              if (credentialInfosBuilder_.isEmpty()) {
                credentialInfosBuilder_.dispose();
                credentialInfosBuilder_ = null;
                credentialInfos_ = other.credentialInfos_;
                bitField0_ = (bitField0_ & ~0x00000001);
                credentialInfosBuilder_ = 
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                     getCredentialInfosFieldBuilder() : null;
              } else {
                credentialInfosBuilder_.addAllMessages(other.credentialInfos_);
              }
            }
          }
          if (other.hasNextPageToken()) {
            bitField0_ |= 0x00000002;
            nextPageToken_ = other.nextPageToken_;
            onChanged();
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        private int bitField0_;

        private java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo> credentialInfos_ =
          java.util.Collections.emptyList();
        private void ensureCredentialInfosIsMutable() {
          if (!((bitField0_ & 0x00000001) == 0x00000001)) {
            credentialInfos_ = new java.util.ArrayList<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo>(credentialInfos_);
            bitField0_ |= 0x00000001;
           }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
            com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder> credentialInfosBuilder_;

        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo> getCredentialInfosList() {
          if (credentialInfosBuilder_ == null) {
            return java.util.Collections.unmodifiableList(credentialInfos_);
          } else {
            return credentialInfosBuilder_.getMessageList();
          }
        }
        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public int getCredentialInfosCount() {
          if (credentialInfosBuilder_ == null) {
            return credentialInfos_.size();
          } else {
            return credentialInfosBuilder_.getCount();
          }
        }
        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo getCredentialInfos(int index) {
          if (credentialInfosBuilder_ == null) {
            return credentialInfos_.get(index);
          } else {
            return credentialInfosBuilder_.getMessage(index);
          }
        }
        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder setCredentialInfos(
            int index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo value) {
          if (credentialInfosBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureCredentialInfosIsMutable();
            credentialInfos_.set(index, value);
            onChanged();
          } else {
            credentialInfosBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder setCredentialInfos(
            int index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder builderForValue) {
          if (credentialInfosBuilder_ == null) {
            ensureCredentialInfosIsMutable();
            credentialInfos_.set(index, builderForValue.build());
            onChanged();
          } else {
            credentialInfosBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder addCredentialInfos(com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo value) {
          if (credentialInfosBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureCredentialInfosIsMutable();
            credentialInfos_.add(value);
            onChanged();
          } else {
            credentialInfosBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder addCredentialInfos(
            int index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo value) {
          if (credentialInfosBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureCredentialInfosIsMutable();
            credentialInfos_.add(index, value);
            onChanged();
          } else {
            credentialInfosBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder addCredentialInfos(
            com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder builderForValue) {
          if (credentialInfosBuilder_ == null) {
            ensureCredentialInfosIsMutable();
            credentialInfos_.add(builderForValue.build());
            onChanged();
          } else {
            credentialInfosBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder addCredentialInfos(
            int index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder builderForValue) {
          if (credentialInfosBuilder_ == null) {
            ensureCredentialInfosIsMutable();
            credentialInfos_.add(index, builderForValue.build());
            onChanged();
          } else {
            credentialInfosBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder addAllCredentialInfos(
            java.lang.Iterable<? extends com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo> values) {
          if (credentialInfosBuilder_ == null) {
            ensureCredentialInfosIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(
                values, credentialInfos_);
            onChanged();
          } else {
            credentialInfosBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder clearCredentialInfos() {
          if (credentialInfosBuilder_ == null) {
            credentialInfos_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
          } else {
            credentialInfosBuilder_.clear();
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder removeCredentialInfos(int index) {
          if (credentialInfosBuilder_ == null) {
            ensureCredentialInfosIsMutable();
            credentialInfos_.remove(index);
            onChanged();
          } else {
            credentialInfosBuilder_.remove(index);
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder getCredentialInfosBuilder(
            int index) {
          return getCredentialInfosFieldBuilder().getBuilder(index);
        }
        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder getCredentialInfosOrBuilder(
            int index) {
          if (credentialInfosBuilder_ == null) {
            return credentialInfos_.get(index);  } else {
            return credentialInfosBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public java.util.List<? extends com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder> 
             getCredentialInfosOrBuilderList() {
          if (credentialInfosBuilder_ != null) {
            return credentialInfosBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(credentialInfos_);
          }
        }
        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder addCredentialInfosBuilder() {
          return getCredentialInfosFieldBuilder().addBuilder(
              com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.getDefaultInstance());
        }
        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder addCredentialInfosBuilder(
            int index) {
          return getCredentialInfosFieldBuilder().addBuilder(
              index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.getDefaultInstance());
        }
        /**
         * <pre>
         * Credentials for reading from the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder> 
             getCredentialInfosBuilderList() {
          return getCredentialInfosFieldBuilder().getBuilderList();
        }
        private com.google.protobuf.RepeatedFieldBuilderV3<
            com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder> 
            getCredentialInfosFieldBuilder() {
          if (credentialInfosBuilder_ == null) {
            credentialInfosBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
                com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder>(
                    credentialInfos_,
                    ((bitField0_ & 0x00000001) == 0x00000001),
                    getParentForChildren(),
                    isClean());
            credentialInfos_ = null;
          }
          return credentialInfosBuilder_;
        }

        private java.lang.Object nextPageToken_ = "";
        /**
         * <pre>
         * Token used to fetch the next page of credentials for large requests that require pagination
         * </pre>
         *
         * <code>optional string next_page_token = 3;</code>
         */
        public boolean hasNextPageToken() {
          return ((bitField0_ & 0x00000002) == 0x00000002);
        }
        /**
         * <pre>
         * Token used to fetch the next page of credentials for large requests that require pagination
         * </pre>
         *
         * <code>optional string next_page_token = 3;</code>
         */
        public java.lang.String getNextPageToken() {
          java.lang.Object ref = nextPageToken_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              nextPageToken_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * Token used to fetch the next page of credentials for large requests that require pagination
         * </pre>
         *
         * <code>optional string next_page_token = 3;</code>
         */
        public com.google.protobuf.ByteString
            getNextPageTokenBytes() {
          java.lang.Object ref = nextPageToken_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            nextPageToken_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * Token used to fetch the next page of credentials for large requests that require pagination
         * </pre>
         *
         * <code>optional string next_page_token = 3;</code>
         */
        public Builder setNextPageToken(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
          nextPageToken_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Token used to fetch the next page of credentials for large requests that require pagination
         * </pre>
         *
         * <code>optional string next_page_token = 3;</code>
         */
        public Builder clearNextPageToken() {
          bitField0_ = (bitField0_ & ~0x00000002);
          nextPageToken_ = getDefaultInstance().getNextPageToken();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Token used to fetch the next page of credentials for large requests that require pagination
         * </pre>
         *
         * <code>optional string next_page_token = 3;</code>
         */
        public Builder setNextPageTokenBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
          nextPageToken_ = value;
          onChanged();
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:mlflow.GetCredentialsForRead.Response)
      }

      // @@protoc_insertion_point(class_scope:mlflow.GetCredentialsForRead.Response)
      private static final com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response();
      }

      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      @java.lang.Deprecated public static final com.google.protobuf.Parser<Response>
          PARSER = new com.google.protobuf.AbstractParser<Response>() {
        @java.lang.Override
        public Response parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Response(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<Response> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Response> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Response getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    private int bitField0_;
    public static final int RUN_ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object runId_;
    /**
     * <pre>
     * The ID of the MLflow Run for which to fetch artifact read credentials
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     */
    public boolean hasRunId() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <pre>
     * The ID of the MLflow Run for which to fetch artifact read credentials
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     */
    public java.lang.String getRunId() {
      java.lang.Object ref = runId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          runId_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * The ID of the MLflow Run for which to fetch artifact read credentials
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     */
    public com.google.protobuf.ByteString
        getRunIdBytes() {
      java.lang.Object ref = runId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        runId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PATH_FIELD_NUMBER = 2;
    private com.google.protobuf.LazyStringList path_;
    /**
     * <pre>
     * The artifact paths, relative to the Run's artifact root location, for which to
     * fetch artifact read credentials. Must not be empty.
     * </pre>
     *
     * <code>repeated string path = 2;</code>
     */
    public com.google.protobuf.ProtocolStringList
        getPathList() {
      return path_;
    }
    /**
     * <pre>
     * The artifact paths, relative to the Run's artifact root location, for which to
     * fetch artifact read credentials. Must not be empty.
     * </pre>
     *
     * <code>repeated string path = 2;</code>
     */
    public int getPathCount() {
      return path_.size();
    }
    /**
     * <pre>
     * The artifact paths, relative to the Run's artifact root location, for which to
     * fetch artifact read credentials. Must not be empty.
     * </pre>
     *
     * <code>repeated string path = 2;</code>
     */
    public java.lang.String getPath(int index) {
      return path_.get(index);
    }
    /**
     * <pre>
     * The artifact paths, relative to the Run's artifact root location, for which to
     * fetch artifact read credentials. Must not be empty.
     * </pre>
     *
     * <code>repeated string path = 2;</code>
     */
    public com.google.protobuf.ByteString
        getPathBytes(int index) {
      return path_.getByteString(index);
    }

    public static final int PAGE_TOKEN_FIELD_NUMBER = 3;
    private volatile java.lang.Object pageToken_;
    /**
     * <pre>
     * Token specifying the page of credentials to fetch for large requests that require pagination
     * </pre>
     *
     * <code>optional string page_token = 3;</code>
     */
    public boolean hasPageToken() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <pre>
     * Token specifying the page of credentials to fetch for large requests that require pagination
     * </pre>
     *
     * <code>optional string page_token = 3;</code>
     */
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          pageToken_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * Token specifying the page of credentials to fetch for large requests that require pagination
     * </pre>
     *
     * <code>optional string page_token = 3;</code>
     */
    public com.google.protobuf.ByteString
        getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, runId_);
      }
      for (int i = 0; i < path_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, path_.getRaw(i));
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, pageToken_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, runId_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < path_.size(); i++) {
          dataSize += computeStringSizeNoTag(path_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getPathList().size();
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, pageToken_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead)) {
        return super.equals(obj);
      }
      com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead other = (com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead) obj;

      boolean result = true;
      result = result && (hasRunId() == other.hasRunId());
      if (hasRunId()) {
        result = result && getRunId()
            .equals(other.getRunId());
      }
      result = result && getPathList()
          .equals(other.getPathList());
      result = result && (hasPageToken() == other.hasPageToken());
      if (hasPageToken()) {
        result = result && getPageToken()
            .equals(other.getPageToken());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasRunId()) {
        hash = (37 * hash) + RUN_ID_FIELD_NUMBER;
        hash = (53 * hash) + getRunId().hashCode();
      }
      if (getPathCount() > 0) {
        hash = (37 * hash) + PATH_FIELD_NUMBER;
        hash = (53 * hash) + getPathList().hashCode();
      }
      if (hasPageToken()) {
        hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
        hash = (53 * hash) + getPageToken().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code mlflow.GetCredentialsForRead}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:mlflow.GetCredentialsForRead)
        com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForReadOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForRead_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForRead_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.Builder.class);
      }

      // Construct using com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        runId_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        path_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        pageToken_ = "";
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForRead_descriptor;
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead getDefaultInstanceForType() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.getDefaultInstance();
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead build() {
        com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead buildPartial() {
        com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead result = new com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.runId_ = runId_;
        if (((bitField0_ & 0x00000002) == 0x00000002)) {
          path_ = path_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.path_ = path_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000002;
        }
        result.pageToken_ = pageToken_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead) {
          return mergeFrom((com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead other) {
        if (other == com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead.getDefaultInstance()) return this;
        if (other.hasRunId()) {
          bitField0_ |= 0x00000001;
          runId_ = other.runId_;
          onChanged();
        }
        if (!other.path_.isEmpty()) {
          if (path_.isEmpty()) {
            path_ = other.path_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensurePathIsMutable();
            path_.addAll(other.path_);
          }
          onChanged();
        }
        if (other.hasPageToken()) {
          bitField0_ |= 0x00000004;
          pageToken_ = other.pageToken_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object runId_ = "";
      /**
       * <pre>
       * The ID of the MLflow Run for which to fetch artifact read credentials
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       */
      public boolean hasRunId() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <pre>
       * The ID of the MLflow Run for which to fetch artifact read credentials
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       */
      public java.lang.String getRunId() {
        java.lang.Object ref = runId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            runId_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * The ID of the MLflow Run for which to fetch artifact read credentials
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       */
      public com.google.protobuf.ByteString
          getRunIdBytes() {
        java.lang.Object ref = runId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          runId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * The ID of the MLflow Run for which to fetch artifact read credentials
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       */
      public Builder setRunId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        runId_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The ID of the MLflow Run for which to fetch artifact read credentials
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       */
      public Builder clearRunId() {
        bitField0_ = (bitField0_ & ~0x00000001);
        runId_ = getDefaultInstance().getRunId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The ID of the MLflow Run for which to fetch artifact read credentials
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       */
      public Builder setRunIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        runId_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList path_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensurePathIsMutable() {
        if (!((bitField0_ & 0x00000002) == 0x00000002)) {
          path_ = new com.google.protobuf.LazyStringArrayList(path_);
          bitField0_ |= 0x00000002;
         }
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact read credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       */
      public com.google.protobuf.ProtocolStringList
          getPathList() {
        return path_.getUnmodifiableView();
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact read credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       */
      public int getPathCount() {
        return path_.size();
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact read credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       */
      public java.lang.String getPath(int index) {
        return path_.get(index);
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact read credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       */
      public com.google.protobuf.ByteString
          getPathBytes(int index) {
        return path_.getByteString(index);
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact read credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       */
      public Builder setPath(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensurePathIsMutable();
        path_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact read credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       */
      public Builder addPath(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensurePathIsMutable();
        path_.add(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact read credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       */
      public Builder addAllPath(
          java.lang.Iterable<java.lang.String> values) {
        ensurePathIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, path_);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact read credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       */
      public Builder clearPath() {
        path_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact read credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       */
      public Builder addPathBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensurePathIsMutable();
        path_.add(value);
        onChanged();
        return this;
      }

      private java.lang.Object pageToken_ = "";
      /**
       * <pre>
       * Token specifying the page of credentials to fetch for large requests that require pagination
       * </pre>
       *
       * <code>optional string page_token = 3;</code>
       */
      public boolean hasPageToken() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <pre>
       * Token specifying the page of credentials to fetch for large requests that require pagination
       * </pre>
       *
       * <code>optional string page_token = 3;</code>
       */
      public java.lang.String getPageToken() {
        java.lang.Object ref = pageToken_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            pageToken_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Token specifying the page of credentials to fetch for large requests that require pagination
       * </pre>
       *
       * <code>optional string page_token = 3;</code>
       */
      public com.google.protobuf.ByteString
          getPageTokenBytes() {
        java.lang.Object ref = pageToken_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          pageToken_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Token specifying the page of credentials to fetch for large requests that require pagination
       * </pre>
       *
       * <code>optional string page_token = 3;</code>
       */
      public Builder setPageToken(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        pageToken_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Token specifying the page of credentials to fetch for large requests that require pagination
       * </pre>
       *
       * <code>optional string page_token = 3;</code>
       */
      public Builder clearPageToken() {
        bitField0_ = (bitField0_ & ~0x00000004);
        pageToken_ = getDefaultInstance().getPageToken();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Token specifying the page of credentials to fetch for large requests that require pagination
       * </pre>
       *
       * <code>optional string page_token = 3;</code>
       */
      public Builder setPageTokenBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        pageToken_ = value;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:mlflow.GetCredentialsForRead)
    }

    // @@protoc_insertion_point(class_scope:mlflow.GetCredentialsForRead)
    private static final com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead();
    }

    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<GetCredentialsForRead>
        PARSER = new com.google.protobuf.AbstractParser<GetCredentialsForRead>() {
      @java.lang.Override
      public GetCredentialsForRead parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new GetCredentialsForRead(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<GetCredentialsForRead> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GetCredentialsForRead> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForRead getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface GetCredentialsForWriteOrBuilder extends
      // @@protoc_insertion_point(interface_extends:mlflow.GetCredentialsForWrite)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * The ID of the MLflow Run for which to fetch artifact write credentials
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     */
    boolean hasRunId();
    /**
     * <pre>
     * The ID of the MLflow Run for which to fetch artifact write credentials
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     */
    java.lang.String getRunId();
    /**
     * <pre>
     * The ID of the MLflow Run for which to fetch artifact write credentials
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     */
    com.google.protobuf.ByteString
        getRunIdBytes();

    /**
     * <pre>
     * The artifact paths, relative to the Run's artifact root location, for which to
     * fetch artifact write credentials. Must not be empty.
     * </pre>
     *
     * <code>repeated string path = 2;</code>
     */
    java.util.List<java.lang.String>
        getPathList();
    /**
     * <pre>
     * The artifact paths, relative to the Run's artifact root location, for which to
     * fetch artifact write credentials. Must not be empty.
     * </pre>
     *
     * <code>repeated string path = 2;</code>
     */
    int getPathCount();
    /**
     * <pre>
     * The artifact paths, relative to the Run's artifact root location, for which to
     * fetch artifact write credentials. Must not be empty.
     * </pre>
     *
     * <code>repeated string path = 2;</code>
     */
    java.lang.String getPath(int index);
    /**
     * <pre>
     * The artifact paths, relative to the Run's artifact root location, for which to
     * fetch artifact write credentials. Must not be empty.
     * </pre>
     *
     * <code>repeated string path = 2;</code>
     */
    com.google.protobuf.ByteString
        getPathBytes(int index);

    /**
     * <pre>
     * Token specifying the page of credentials to fetch for large requests that require pagination
     * </pre>
     *
     * <code>optional string page_token = 3;</code>
     */
    boolean hasPageToken();
    /**
     * <pre>
     * Token specifying the page of credentials to fetch for large requests that require pagination
     * </pre>
     *
     * <code>optional string page_token = 3;</code>
     */
    java.lang.String getPageToken();
    /**
     * <pre>
     * Token specifying the page of credentials to fetch for large requests that require pagination
     * </pre>
     *
     * <code>optional string page_token = 3;</code>
     */
    com.google.protobuf.ByteString
        getPageTokenBytes();
  }
  /**
   * Protobuf type {@code mlflow.GetCredentialsForWrite}
   */
  public  static final class GetCredentialsForWrite extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:mlflow.GetCredentialsForWrite)
      GetCredentialsForWriteOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use GetCredentialsForWrite.newBuilder() to construct.
    private GetCredentialsForWrite(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private GetCredentialsForWrite() {
      runId_ = "";
      path_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      pageToken_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private GetCredentialsForWrite(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              runId_ = bs;
              break;
            }
            case 18: {
              com.google.protobuf.ByteString bs = input.readBytes();
              if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                path_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000002;
              }
              path_.add(bs);
              break;
            }
            case 26: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000002;
              pageToken_ = bs;
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
          path_ = path_.getUnmodifiableView();
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForWrite_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForWrite_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Builder.class);
    }

    public interface ResponseOrBuilder extends
        // @@protoc_insertion_point(interface_extends:mlflow.GetCredentialsForWrite.Response)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <pre>
       * Credentials for writing to the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo> 
          getCredentialInfosList();
      /**
       * <pre>
       * Credentials for writing to the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo getCredentialInfos(int index);
      /**
       * <pre>
       * Credentials for writing to the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      int getCredentialInfosCount();
      /**
       * <pre>
       * Credentials for writing to the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      java.util.List<? extends com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder> 
          getCredentialInfosOrBuilderList();
      /**
       * <pre>
       * Credentials for writing to the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder getCredentialInfosOrBuilder(
          int index);

      /**
       * <pre>
       * Token used to fetch the next page of credentials for large requests that require pagination
       * </pre>
       *
       * <code>optional string next_page_token = 3;</code>
       */
      boolean hasNextPageToken();
      /**
       * <pre>
       * Token used to fetch the next page of credentials for large requests that require pagination
       * </pre>
       *
       * <code>optional string next_page_token = 3;</code>
       */
      java.lang.String getNextPageToken();
      /**
       * <pre>
       * Token used to fetch the next page of credentials for large requests that require pagination
       * </pre>
       *
       * <code>optional string next_page_token = 3;</code>
       */
      com.google.protobuf.ByteString
          getNextPageTokenBytes();
    }
    /**
     * Protobuf type {@code mlflow.GetCredentialsForWrite.Response}
     */
    public  static final class Response extends
        com.google.protobuf.GeneratedMessageV3 implements
        // @@protoc_insertion_point(message_implements:mlflow.GetCredentialsForWrite.Response)
        ResponseOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use Response.newBuilder() to construct.
      private Response(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }
      private Response() {
        credentialInfos_ = java.util.Collections.emptyList();
        nextPageToken_ = "";
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private Response(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18: {
                if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                  credentialInfos_ = new java.util.ArrayList<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo>();
                  mutable_bitField0_ |= 0x00000001;
                }
                credentialInfos_.add(
                    input.readMessage(com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.PARSER, extensionRegistry));
                break;
              }
              case 26: {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000001;
                nextPageToken_ = bs;
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
            credentialInfos_ = java.util.Collections.unmodifiableList(credentialInfos_);
          }
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForWrite_Response_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForWrite_Response_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response.Builder.class);
      }

      private int bitField0_;
      public static final int CREDENTIAL_INFOS_FIELD_NUMBER = 2;
      private java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo> credentialInfos_;
      /**
       * <pre>
       * Credentials for writing to the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      public java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo> getCredentialInfosList() {
        return credentialInfos_;
      }
      /**
       * <pre>
       * Credentials for writing to the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      public java.util.List<? extends com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder> 
          getCredentialInfosOrBuilderList() {
        return credentialInfos_;
      }
      /**
       * <pre>
       * Credentials for writing to the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      public int getCredentialInfosCount() {
        return credentialInfos_.size();
      }
      /**
       * <pre>
       * Credentials for writing to the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo getCredentialInfos(int index) {
        return credentialInfos_.get(index);
      }
      /**
       * <pre>
       * Credentials for writing to the specified artifact locations
       * </pre>
       *
       * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
       */
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder getCredentialInfosOrBuilder(
          int index) {
        return credentialInfos_.get(index);
      }

      public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 3;
      private volatile java.lang.Object nextPageToken_;
      /**
       * <pre>
       * Token used to fetch the next page of credentials for large requests that require pagination
       * </pre>
       *
       * <code>optional string next_page_token = 3;</code>
       */
      public boolean hasNextPageToken() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <pre>
       * Token used to fetch the next page of credentials for large requests that require pagination
       * </pre>
       *
       * <code>optional string next_page_token = 3;</code>
       */
      public java.lang.String getNextPageToken() {
        java.lang.Object ref = nextPageToken_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            nextPageToken_ = s;
          }
          return s;
        }
      }
      /**
       * <pre>
       * Token used to fetch the next page of credentials for large requests that require pagination
       * </pre>
       *
       * <code>optional string next_page_token = 3;</code>
       */
      public com.google.protobuf.ByteString
          getNextPageTokenBytes() {
        java.lang.Object ref = nextPageToken_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          nextPageToken_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        for (int i = 0; i < credentialInfos_.size(); i++) {
          output.writeMessage(2, credentialInfos_.get(i));
        }
        if (((bitField0_ & 0x00000001) == 0x00000001)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, nextPageToken_);
        }
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        for (int i = 0; i < credentialInfos_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(2, credentialInfos_.get(i));
        }
        if (((bitField0_ & 0x00000001) == 0x00000001)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, nextPageToken_);
        }
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response)) {
          return super.equals(obj);
        }
        com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response other = (com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response) obj;

        boolean result = true;
        result = result && getCredentialInfosList()
            .equals(other.getCredentialInfosList());
        result = result && (hasNextPageToken() == other.hasNextPageToken());
        if (hasNextPageToken()) {
          result = result && getNextPageToken()
              .equals(other.getNextPageToken());
        }
        result = result && unknownFields.equals(other.unknownFields);
        return result;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getCredentialInfosCount() > 0) {
          hash = (37 * hash) + CREDENTIAL_INFOS_FIELD_NUMBER;
          hash = (53 * hash) + getCredentialInfosList().hashCode();
        }
        if (hasNextPageToken()) {
          hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
          hash = (53 * hash) + getNextPageToken().hashCode();
        }
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code mlflow.GetCredentialsForWrite.Response}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:mlflow.GetCredentialsForWrite.Response)
          com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.ResponseOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForWrite_Response_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForWrite_Response_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response.Builder.class);
        }

        // Construct using com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
            getCredentialInfosFieldBuilder();
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          if (credentialInfosBuilder_ == null) {
            credentialInfos_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            credentialInfosBuilder_.clear();
          }
          nextPageToken_ = "";
          bitField0_ = (bitField0_ & ~0x00000002);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForWrite_Response_descriptor;
        }

        @java.lang.Override
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response getDefaultInstanceForType() {
          return com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response.getDefaultInstance();
        }

        @java.lang.Override
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response build() {
          com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response buildPartial() {
          com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response result = new com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response(this);
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (credentialInfosBuilder_ == null) {
            if (((bitField0_ & 0x00000001) == 0x00000001)) {
              credentialInfos_ = java.util.Collections.unmodifiableList(credentialInfos_);
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.credentialInfos_ = credentialInfos_;
          } else {
            result.credentialInfos_ = credentialInfosBuilder_.build();
          }
          if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
            to_bitField0_ |= 0x00000001;
          }
          result.nextPageToken_ = nextPageToken_;
          result.bitField0_ = to_bitField0_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return (Builder) super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return (Builder) super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return (Builder) super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return (Builder) super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return (Builder) super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return (Builder) super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response) {
            return mergeFrom((com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response other) {
          if (other == com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response.getDefaultInstance()) return this;
          if (credentialInfosBuilder_ == null) {
            if (!other.credentialInfos_.isEmpty()) {
              if (credentialInfos_.isEmpty()) {
                credentialInfos_ = other.credentialInfos_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureCredentialInfosIsMutable();
                credentialInfos_.addAll(other.credentialInfos_);
              }
              onChanged();
            }
          } else {
            if (!other.credentialInfos_.isEmpty()) {
              if (credentialInfosBuilder_.isEmpty()) {
                credentialInfosBuilder_.dispose();
                credentialInfosBuilder_ = null;
                credentialInfos_ = other.credentialInfos_;
                bitField0_ = (bitField0_ & ~0x00000001);
                credentialInfosBuilder_ = 
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                     getCredentialInfosFieldBuilder() : null;
              } else {
                credentialInfosBuilder_.addAllMessages(other.credentialInfos_);
              }
            }
          }
          if (other.hasNextPageToken()) {
            bitField0_ |= 0x00000002;
            nextPageToken_ = other.nextPageToken_;
            onChanged();
          }
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        private int bitField0_;

        private java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo> credentialInfos_ =
          java.util.Collections.emptyList();
        private void ensureCredentialInfosIsMutable() {
          if (!((bitField0_ & 0x00000001) == 0x00000001)) {
            credentialInfos_ = new java.util.ArrayList<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo>(credentialInfos_);
            bitField0_ |= 0x00000001;
           }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
            com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder> credentialInfosBuilder_;

        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo> getCredentialInfosList() {
          if (credentialInfosBuilder_ == null) {
            return java.util.Collections.unmodifiableList(credentialInfos_);
          } else {
            return credentialInfosBuilder_.getMessageList();
          }
        }
        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public int getCredentialInfosCount() {
          if (credentialInfosBuilder_ == null) {
            return credentialInfos_.size();
          } else {
            return credentialInfosBuilder_.getCount();
          }
        }
        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo getCredentialInfos(int index) {
          if (credentialInfosBuilder_ == null) {
            return credentialInfos_.get(index);
          } else {
            return credentialInfosBuilder_.getMessage(index);
          }
        }
        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder setCredentialInfos(
            int index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo value) {
          if (credentialInfosBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureCredentialInfosIsMutable();
            credentialInfos_.set(index, value);
            onChanged();
          } else {
            credentialInfosBuilder_.setMessage(index, value);
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder setCredentialInfos(
            int index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder builderForValue) {
          if (credentialInfosBuilder_ == null) {
            ensureCredentialInfosIsMutable();
            credentialInfos_.set(index, builderForValue.build());
            onChanged();
          } else {
            credentialInfosBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder addCredentialInfos(com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo value) {
          if (credentialInfosBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureCredentialInfosIsMutable();
            credentialInfos_.add(value);
            onChanged();
          } else {
            credentialInfosBuilder_.addMessage(value);
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder addCredentialInfos(
            int index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo value) {
          if (credentialInfosBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureCredentialInfosIsMutable();
            credentialInfos_.add(index, value);
            onChanged();
          } else {
            credentialInfosBuilder_.addMessage(index, value);
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder addCredentialInfos(
            com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder builderForValue) {
          if (credentialInfosBuilder_ == null) {
            ensureCredentialInfosIsMutable();
            credentialInfos_.add(builderForValue.build());
            onChanged();
          } else {
            credentialInfosBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder addCredentialInfos(
            int index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder builderForValue) {
          if (credentialInfosBuilder_ == null) {
            ensureCredentialInfosIsMutable();
            credentialInfos_.add(index, builderForValue.build());
            onChanged();
          } else {
            credentialInfosBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder addAllCredentialInfos(
            java.lang.Iterable<? extends com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo> values) {
          if (credentialInfosBuilder_ == null) {
            ensureCredentialInfosIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(
                values, credentialInfos_);
            onChanged();
          } else {
            credentialInfosBuilder_.addAllMessages(values);
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder clearCredentialInfos() {
          if (credentialInfosBuilder_ == null) {
            credentialInfos_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
          } else {
            credentialInfosBuilder_.clear();
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public Builder removeCredentialInfos(int index) {
          if (credentialInfosBuilder_ == null) {
            ensureCredentialInfosIsMutable();
            credentialInfos_.remove(index);
            onChanged();
          } else {
            credentialInfosBuilder_.remove(index);
          }
          return this;
        }
        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder getCredentialInfosBuilder(
            int index) {
          return getCredentialInfosFieldBuilder().getBuilder(index);
        }
        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder getCredentialInfosOrBuilder(
            int index) {
          if (credentialInfosBuilder_ == null) {
            return credentialInfos_.get(index);  } else {
            return credentialInfosBuilder_.getMessageOrBuilder(index);
          }
        }
        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public java.util.List<? extends com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder> 
             getCredentialInfosOrBuilderList() {
          if (credentialInfosBuilder_ != null) {
            return credentialInfosBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(credentialInfos_);
          }
        }
        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder addCredentialInfosBuilder() {
          return getCredentialInfosFieldBuilder().addBuilder(
              com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.getDefaultInstance());
        }
        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder addCredentialInfosBuilder(
            int index) {
          return getCredentialInfosFieldBuilder().addBuilder(
              index, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.getDefaultInstance());
        }
        /**
         * <pre>
         * Credentials for writing to the specified artifact locations
         * </pre>
         *
         * <code>repeated .mlflow.ArtifactCredentialInfo credential_infos = 2;</code>
         */
        public java.util.List<com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder> 
             getCredentialInfosBuilderList() {
          return getCredentialInfosFieldBuilder().getBuilderList();
        }
        private com.google.protobuf.RepeatedFieldBuilderV3<
            com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder> 
            getCredentialInfosFieldBuilder() {
          if (credentialInfosBuilder_ == null) {
            credentialInfosBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
                com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfo.Builder, com.databricks.api.proto.mlflow.DatabricksArtifacts.ArtifactCredentialInfoOrBuilder>(
                    credentialInfos_,
                    ((bitField0_ & 0x00000001) == 0x00000001),
                    getParentForChildren(),
                    isClean());
            credentialInfos_ = null;
          }
          return credentialInfosBuilder_;
        }

        private java.lang.Object nextPageToken_ = "";
        /**
         * <pre>
         * Token used to fetch the next page of credentials for large requests that require pagination
         * </pre>
         *
         * <code>optional string next_page_token = 3;</code>
         */
        public boolean hasNextPageToken() {
          return ((bitField0_ & 0x00000002) == 0x00000002);
        }
        /**
         * <pre>
         * Token used to fetch the next page of credentials for large requests that require pagination
         * </pre>
         *
         * <code>optional string next_page_token = 3;</code>
         */
        public java.lang.String getNextPageToken() {
          java.lang.Object ref = nextPageToken_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              nextPageToken_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * Token used to fetch the next page of credentials for large requests that require pagination
         * </pre>
         *
         * <code>optional string next_page_token = 3;</code>
         */
        public com.google.protobuf.ByteString
            getNextPageTokenBytes() {
          java.lang.Object ref = nextPageToken_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            nextPageToken_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * Token used to fetch the next page of credentials for large requests that require pagination
         * </pre>
         *
         * <code>optional string next_page_token = 3;</code>
         */
        public Builder setNextPageToken(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
          nextPageToken_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Token used to fetch the next page of credentials for large requests that require pagination
         * </pre>
         *
         * <code>optional string next_page_token = 3;</code>
         */
        public Builder clearNextPageToken() {
          bitField0_ = (bitField0_ & ~0x00000002);
          nextPageToken_ = getDefaultInstance().getNextPageToken();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Token used to fetch the next page of credentials for large requests that require pagination
         * </pre>
         *
         * <code>optional string next_page_token = 3;</code>
         */
        public Builder setNextPageTokenBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
          nextPageToken_ = value;
          onChanged();
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:mlflow.GetCredentialsForWrite.Response)
      }

      // @@protoc_insertion_point(class_scope:mlflow.GetCredentialsForWrite.Response)
      private static final com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response();
      }

      public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      @java.lang.Deprecated public static final com.google.protobuf.Parser<Response>
          PARSER = new com.google.protobuf.AbstractParser<Response>() {
        @java.lang.Override
        public Response parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Response(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<Response> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Response> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Response getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    private int bitField0_;
    public static final int RUN_ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object runId_;
    /**
     * <pre>
     * The ID of the MLflow Run for which to fetch artifact write credentials
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     */
    public boolean hasRunId() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <pre>
     * The ID of the MLflow Run for which to fetch artifact write credentials
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     */
    public java.lang.String getRunId() {
      java.lang.Object ref = runId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          runId_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * The ID of the MLflow Run for which to fetch artifact write credentials
     * </pre>
     *
     * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
     */
    public com.google.protobuf.ByteString
        getRunIdBytes() {
      java.lang.Object ref = runId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        runId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PATH_FIELD_NUMBER = 2;
    private com.google.protobuf.LazyStringList path_;
    /**
     * <pre>
     * The artifact paths, relative to the Run's artifact root location, for which to
     * fetch artifact write credentials. Must not be empty.
     * </pre>
     *
     * <code>repeated string path = 2;</code>
     */
    public com.google.protobuf.ProtocolStringList
        getPathList() {
      return path_;
    }
    /**
     * <pre>
     * The artifact paths, relative to the Run's artifact root location, for which to
     * fetch artifact write credentials. Must not be empty.
     * </pre>
     *
     * <code>repeated string path = 2;</code>
     */
    public int getPathCount() {
      return path_.size();
    }
    /**
     * <pre>
     * The artifact paths, relative to the Run's artifact root location, for which to
     * fetch artifact write credentials. Must not be empty.
     * </pre>
     *
     * <code>repeated string path = 2;</code>
     */
    public java.lang.String getPath(int index) {
      return path_.get(index);
    }
    /**
     * <pre>
     * The artifact paths, relative to the Run's artifact root location, for which to
     * fetch artifact write credentials. Must not be empty.
     * </pre>
     *
     * <code>repeated string path = 2;</code>
     */
    public com.google.protobuf.ByteString
        getPathBytes(int index) {
      return path_.getByteString(index);
    }

    public static final int PAGE_TOKEN_FIELD_NUMBER = 3;
    private volatile java.lang.Object pageToken_;
    /**
     * <pre>
     * Token specifying the page of credentials to fetch for large requests that require pagination
     * </pre>
     *
     * <code>optional string page_token = 3;</code>
     */
    public boolean hasPageToken() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <pre>
     * Token specifying the page of credentials to fetch for large requests that require pagination
     * </pre>
     *
     * <code>optional string page_token = 3;</code>
     */
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          pageToken_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * Token specifying the page of credentials to fetch for large requests that require pagination
     * </pre>
     *
     * <code>optional string page_token = 3;</code>
     */
    public com.google.protobuf.ByteString
        getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, runId_);
      }
      for (int i = 0; i < path_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, path_.getRaw(i));
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, pageToken_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, runId_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < path_.size(); i++) {
          dataSize += computeStringSizeNoTag(path_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getPathList().size();
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, pageToken_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite)) {
        return super.equals(obj);
      }
      com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite other = (com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite) obj;

      boolean result = true;
      result = result && (hasRunId() == other.hasRunId());
      if (hasRunId()) {
        result = result && getRunId()
            .equals(other.getRunId());
      }
      result = result && getPathList()
          .equals(other.getPathList());
      result = result && (hasPageToken() == other.hasPageToken());
      if (hasPageToken()) {
        result = result && getPageToken()
            .equals(other.getPageToken());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasRunId()) {
        hash = (37 * hash) + RUN_ID_FIELD_NUMBER;
        hash = (53 * hash) + getRunId().hashCode();
      }
      if (getPathCount() > 0) {
        hash = (37 * hash) + PATH_FIELD_NUMBER;
        hash = (53 * hash) + getPathList().hashCode();
      }
      if (hasPageToken()) {
        hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
        hash = (53 * hash) + getPageToken().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code mlflow.GetCredentialsForWrite}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:mlflow.GetCredentialsForWrite)
        com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWriteOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForWrite_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForWrite_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.class, com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.Builder.class);
      }

      // Construct using com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        runId_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        path_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        pageToken_ = "";
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.internal_static_mlflow_GetCredentialsForWrite_descriptor;
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite getDefaultInstanceForType() {
        return com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.getDefaultInstance();
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite build() {
        com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite buildPartial() {
        com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite result = new com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.runId_ = runId_;
        if (((bitField0_ & 0x00000002) == 0x00000002)) {
          path_ = path_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.path_ = path_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000002;
        }
        result.pageToken_ = pageToken_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite) {
          return mergeFrom((com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite other) {
        if (other == com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite.getDefaultInstance()) return this;
        if (other.hasRunId()) {
          bitField0_ |= 0x00000001;
          runId_ = other.runId_;
          onChanged();
        }
        if (!other.path_.isEmpty()) {
          if (path_.isEmpty()) {
            path_ = other.path_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensurePathIsMutable();
            path_.addAll(other.path_);
          }
          onChanged();
        }
        if (other.hasPageToken()) {
          bitField0_ |= 0x00000004;
          pageToken_ = other.pageToken_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object runId_ = "";
      /**
       * <pre>
       * The ID of the MLflow Run for which to fetch artifact write credentials
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       */
      public boolean hasRunId() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <pre>
       * The ID of the MLflow Run for which to fetch artifact write credentials
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       */
      public java.lang.String getRunId() {
        java.lang.Object ref = runId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            runId_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * The ID of the MLflow Run for which to fetch artifact write credentials
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       */
      public com.google.protobuf.ByteString
          getRunIdBytes() {
        java.lang.Object ref = runId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          runId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * The ID of the MLflow Run for which to fetch artifact write credentials
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       */
      public Builder setRunId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        runId_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The ID of the MLflow Run for which to fetch artifact write credentials
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       */
      public Builder clearRunId() {
        bitField0_ = (bitField0_ & ~0x00000001);
        runId_ = getDefaultInstance().getRunId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The ID of the MLflow Run for which to fetch artifact write credentials
       * </pre>
       *
       * <code>optional string run_id = 1 [(.mlflow.validate_required) = true];</code>
       */
      public Builder setRunIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        runId_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList path_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensurePathIsMutable() {
        if (!((bitField0_ & 0x00000002) == 0x00000002)) {
          path_ = new com.google.protobuf.LazyStringArrayList(path_);
          bitField0_ |= 0x00000002;
         }
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact write credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       */
      public com.google.protobuf.ProtocolStringList
          getPathList() {
        return path_.getUnmodifiableView();
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact write credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       */
      public int getPathCount() {
        return path_.size();
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact write credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       */
      public java.lang.String getPath(int index) {
        return path_.get(index);
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact write credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       */
      public com.google.protobuf.ByteString
          getPathBytes(int index) {
        return path_.getByteString(index);
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact write credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       */
      public Builder setPath(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensurePathIsMutable();
        path_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact write credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       */
      public Builder addPath(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensurePathIsMutable();
        path_.add(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact write credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       */
      public Builder addAllPath(
          java.lang.Iterable<java.lang.String> values) {
        ensurePathIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, path_);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact write credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       */
      public Builder clearPath() {
        path_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The artifact paths, relative to the Run's artifact root location, for which to
       * fetch artifact write credentials. Must not be empty.
       * </pre>
       *
       * <code>repeated string path = 2;</code>
       */
      public Builder addPathBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensurePathIsMutable();
        path_.add(value);
        onChanged();
        return this;
      }

      private java.lang.Object pageToken_ = "";
      /**
       * <pre>
       * Token specifying the page of credentials to fetch for large requests that require pagination
       * </pre>
       *
       * <code>optional string page_token = 3;</code>
       */
      public boolean hasPageToken() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <pre>
       * Token specifying the page of credentials to fetch for large requests that require pagination
       * </pre>
       *
       * <code>optional string page_token = 3;</code>
       */
      public java.lang.String getPageToken() {
        java.lang.Object ref = pageToken_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            pageToken_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Token specifying the page of credentials to fetch for large requests that require pagination
       * </pre>
       *
       * <code>optional string page_token = 3;</code>
       */
      public com.google.protobuf.ByteString
          getPageTokenBytes() {
        java.lang.Object ref = pageToken_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          pageToken_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Token specifying the page of credentials to fetch for large requests that require pagination
       * </pre>
       *
       * <code>optional string page_token = 3;</code>
       */
      public Builder setPageToken(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        pageToken_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Token specifying the page of credentials to fetch for large requests that require pagination
       * </pre>
       *
       * <code>optional string page_token = 3;</code>
       */
      public Builder clearPageToken() {
        bitField0_ = (bitField0_ & ~0x00000004);
        pageToken_ = getDefaultInstance().getPageToken();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Token specifying the page of credentials to fetch for large requests that require pagination
       * </pre>
       *
       * <code>optional string page_token = 3;</code>
       */
      public Builder setPageTokenBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        pageToken_ = value;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:mlflow.GetCredentialsForWrite)
    }

    // @@protoc_insertion_point(class_scope:mlflow.GetCredentialsForWrite)
    private static final com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite();
    }

    public static com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<GetCredentialsForWrite>
        PARSER = new com.google.protobuf.AbstractParser<GetCredentialsForWrite>() {
      @java.lang.Override
      public GetCredentialsForWrite parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new GetCredentialsForWrite(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<GetCredentialsForWrite> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GetCredentialsForWrite> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.databricks.api.proto.mlflow.DatabricksArtifacts.GetCredentialsForWrite getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_mlflow_ArtifactCredentialInfo_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_mlflow_ArtifactCredentialInfo_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_mlflow_ArtifactCredentialInfo_HttpHeader_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_mlflow_ArtifactCredentialInfo_HttpHeader_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_mlflow_GetCredentialsForRead_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_mlflow_GetCredentialsForRead_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_mlflow_GetCredentialsForRead_Response_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_mlflow_GetCredentialsForRead_Response_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_mlflow_GetCredentialsForWrite_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_mlflow_GetCredentialsForWrite_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_mlflow_GetCredentialsForWrite_Response_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_mlflow_GetCredentialsForWrite_Response_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\032databricks_artifacts.proto\022\006mlflow\032\025sc" +
      "alapb/scalapb.proto\032\020databricks.proto\"\337\001" +
      "\n\026ArtifactCredentialInfo\022\016\n\006run_id\030\001 \001(\t" +
      "\022\014\n\004path\030\002 \001(\t\022\022\n\nsigned_uri\030\003 \001(\t\022:\n\007he" +
      "aders\030\004 \003(\0132).mlflow.ArtifactCredentialI" +
      "nfo.HttpHeader\022,\n\004type\030\005 \001(\0162\036.mlflow.Ar" +
      "tifactCredentialType\032)\n\nHttpHeader\022\014\n\004na" +
      "me\030\001 \001(\t\022\r\n\005value\030\002 \001(\t\"\225\002\n\025GetCredentia" +
      "lsForRead\022\024\n\006run_id\030\001 \001(\tB\004\370\206\031\001\022\014\n\004path\030" +
      "\002 \003(\t\022\022\n\npage_token\030\003 \001(\t\032c\n\010Response\0228\n" +
      "\020credential_infos\030\002 \003(\0132\036.mlflow.Artifac" +
      "tCredentialInfo\022\027\n\017next_page_token\030\003 \001(\t" +
      "J\004\010\001\020\002:_\342?(\n&com.databricks.rpc.RPC[$thi" +
      "s.Response]\342?1\n/com.databricks.mlflow.ap" +
      "i.MlflowTrackingMessage\"\226\002\n\026GetCredentia" +
      "lsForWrite\022\024\n\006run_id\030\001 \001(\tB\004\370\206\031\001\022\014\n\004path" +
      "\030\002 \003(\t\022\022\n\npage_token\030\003 \001(\t\032c\n\010Response\0228" +
      "\n\020credential_infos\030\002 \003(\0132\036.mlflow.Artifa" +
      "ctCredentialInfo\022\027\n\017next_page_token\030\003 \001(" +
      "\tJ\004\010\001\020\002:_\342?(\n&com.databricks.rpc.RPC[$th" +
      "is.Response]\342?1\n/com.databricks.mlflow.a" +
      "pi.MlflowTrackingMessage*V\n\026ArtifactCred" +
      "entialType\022\021\n\rAZURE_SAS_URI\020\001\022\025\n\021AWS_PRE" +
      "SIGNED_URL\020\002\022\022\n\016GCP_SIGNED_URL\020\0032\344\002\n Dat" +
      "abricksMlflowArtifactsService\022\234\001\n\025getCre" +
      "dentialsForRead\022\035.mlflow.GetCredentialsF" +
      "orRead\032&.mlflow.GetCredentialsForRead.Re" +
      "sponse\"<\362\206\0318\n4\n\004POST\022&/mlflow/artifacts/" +
      "credentials-for-read\032\004\010\002\020\000\020\003\022\240\001\n\026getCred" +
      "entialsForWrite\022\036.mlflow.GetCredentialsF" +
      "orWrite\032\'.mlflow.GetCredentialsForWrite." +
      "Response\"=\362\206\0319\n5\n\004POST\022\'/mlflow/artifact" +
      "s/credentials-for-write\032\004\010\002\020\000\020\003B,\n\037com.d" +
      "atabricks.api.proto.mlflow\220\001\001\240\001\001\342?\002\020\001"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          org.mlflow.scalapb_interface.Scalapb.getDescriptor(),
          com.databricks.api.proto.databricks.Databricks.getDescriptor(),
        }, assigner);
    internal_static_mlflow_ArtifactCredentialInfo_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_mlflow_ArtifactCredentialInfo_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_mlflow_ArtifactCredentialInfo_descriptor,
        new java.lang.String[] { "RunId", "Path", "SignedUri", "Headers", "Type", });
    internal_static_mlflow_ArtifactCredentialInfo_HttpHeader_descriptor =
      internal_static_mlflow_ArtifactCredentialInfo_descriptor.getNestedTypes().get(0);
    internal_static_mlflow_ArtifactCredentialInfo_HttpHeader_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_mlflow_ArtifactCredentialInfo_HttpHeader_descriptor,
        new java.lang.String[] { "Name", "Value", });
    internal_static_mlflow_GetCredentialsForRead_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_mlflow_GetCredentialsForRead_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_mlflow_GetCredentialsForRead_descriptor,
        new java.lang.String[] { "RunId", "Path", "PageToken", });
    internal_static_mlflow_GetCredentialsForRead_Response_descriptor =
      internal_static_mlflow_GetCredentialsForRead_descriptor.getNestedTypes().get(0);
    internal_static_mlflow_GetCredentialsForRead_Response_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_mlflow_GetCredentialsForRead_Response_descriptor,
        new java.lang.String[] { "CredentialInfos", "NextPageToken", });
    internal_static_mlflow_GetCredentialsForWrite_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_mlflow_GetCredentialsForWrite_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_mlflow_GetCredentialsForWrite_descriptor,
        new java.lang.String[] { "RunId", "Path", "PageToken", });
    internal_static_mlflow_GetCredentialsForWrite_Response_descriptor =
      internal_static_mlflow_GetCredentialsForWrite_descriptor.getNestedTypes().get(0);
    internal_static_mlflow_GetCredentialsForWrite_Response_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_mlflow_GetCredentialsForWrite_Response_descriptor,
        new java.lang.String[] { "CredentialInfos", "NextPageToken", });
    com.google.protobuf.ExtensionRegistry registry =
        com.google.protobuf.ExtensionRegistry.newInstance();
    registry.add(com.databricks.api.proto.databricks.Databricks.rpc);
    registry.add(com.databricks.api.proto.databricks.Databricks.validateRequired);
    registry.add(org.mlflow.scalapb_interface.Scalapb.message);
    registry.add(org.mlflow.scalapb_interface.Scalapb.options);
    com.google.protobuf.Descriptors.FileDescriptor
        .internalUpdateFileDescriptor(descriptor, registry);
    org.mlflow.scalapb_interface.Scalapb.getDescriptor();
    com.databricks.api.proto.databricks.Databricks.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
