# Generate docs as markdown into a per-session tempdir that's automatically cleaned up when
# the R session terminates.
Rd2md::ReferenceManual(outdir = tempdir())

# Remove markdown package description
markdown_doc <- readLines(file.path(tempdir(), "Reference_Manual_mlflow.md"))
# Somewhat of a hack: find the second occurrence of "```", which delimits the TOC generated by
# Rd2md, and remove all preceding lines to delete the TOC.
toc_delimiter = "```"
first_function <- which(grepl(toc_delimiter, markdown_doc))[[2]] + 1
markdown_fixed <- markdown_doc[first_function:length(markdown_doc)]

# Remove function name from section
markdown_fixed <- gsub("# `[^`]+`:", "#", markdown_fixed)

# Remove description and usage headers
markdown_fixed <- gsub("## Description", "", markdown_fixed)
markdown_fixed <- gsub("## Usage", "", markdown_fixed)

# Remove objects exported from other packages section
last_section <- which(grepl("reexports", markdown_fixed))[[1]]
markdown_fixed <- markdown_fixed[1:last_section - 1]

# Write fixed markdown file
writeLines(markdown_fixed, "Reference_Manual_mlflow.md")

# Clear Sphinx docs and tree to correctly generate sections
if (dir.exists("../../../docs/build")) {
  unlink("../../../docs/build", recursive = TRUE)
}

# Generate reStructuredText documentation
rmarkdown::pandoc_convert("Reference_Manual_mlflow.md", output = "../../../docs/source/R-api.rst")

# Add R API header to RST docs
rst_header <- ".. _R-api:

========
R API
========

The MLflow `R <https://www.r-project.org/about.html>`_ API allows you to use MLflow :doc:`Tracking <tracking/>`, :doc:`Projects <projects/>` and :doc:`Models <models/>`.

You can use the R API to `install MLflow <install_mlflow_>`_, start the `user interface <mlflow_ui>`_, `create <mlflow_create_experiment>`_ and `list experiments <mlflow_list_experiments_>`_, `save models <mlflow_save_model>`_, `run projects <mlflow_run_>`_ and `serve models <mlflow_rfunc_serve_>`_ among many other functions available in the R API.

.. contents:: Table of Contents
    :local:
    :depth: 1
"
rst_doc <- readLines("../../../docs/source/R-api.rst")
# Convert non-breaking spaces inserted by pandoc to regular spaces
rst_doc <- gsub("\302\240", " ", rst_doc)
rst_doc <- c(rst_header, rst_doc)
writeLines(rst_doc, "../../../docs/source/R-api.rst")

# Generate docs by using an mlflow virtualenv and running `make` from `mlflow/docs`
