### MLflow evaluation Examples

The examples in this directory illustrate how you can use the `mlflow.evaluate` API to evaluate a PyFunc model on the
specified dataset using builtin default evaluator, and log resulting metrics & artifacts to MLflow Tracking.

- Example `evaluate_on_binary_classifier.py` evaluates an xgboost `XGBClassifier` model on dataset loaded by
  `shap.datasets.adult`.
- Example `evaluate_on_multiclass_classifier.py` evaluates a scikit-learn `LogisticRegression` model on dataset
  generated by `sklearn.datasets.make_classification`.
- Example `evaluate_on_regressor.py` evaluate as scikit-learn `LinearRegression` model on dataset loaded by
  `sklearn.datasets.fetch_california_housing`
- Example `evaluate_with_custom_metrics.py` evaluates a scikit-learn `LinearRegression`
  model with a custom metric function on dataset loaded by `sklearn.datasets.fetch_california_housing`
- Example `evaluate_with_custom_metrics_comprehensive.py` evaluates a scikit-learn `LinearRegression` model 
  with a comprehensive list of custom metric functions on dataset loaded by `sklearn.datasets.fetch_california_housing`

#### Prerequisites

```
pip install scikit-learn xgboost shap>=0.40 matplotlib
```

#### How to run the examples

Run in this directory with Python.

```
python evaluate_on_binary_classifier.py
python evaluate_on_multiclass_classifier.py
python evaluate_on_regressor.py
python evaluate_with_custom_metrics.py
python evaluate_with_custom_metrics_comprehensive.py
```
