from typing import Any, List

import formatters


# Some useful interfaces from https://github.com/llvm/llvm-project/tree/main/lldb/bindings/interface

class SBType:
    def __init__(self) -> None: ...

    def IsValid(self) -> bool: ...

    def GetByteSize(self) -> int: ...

    def IsPointerType(self) -> bool: ...

    def IsReferenceType(self) -> bool: ...

    def IsFunctionType(self) -> bool: ...

    def IsPolymorphicClass(self) -> bool: ...

    def IsArrayType(self) -> bool: ...

    def IsVectorType(self) -> bool: ...

    def IsTypedefType(self) -> bool: ...

    def IsAnonymousType(self) -> bool: ...

    def GetPointerType(self) -> SBType: ...

    def GetPointeeType(self) -> SBType: ...

    def GetReferenceType(self) -> SBType: ...

    def GetTypedefedType(self) -> SBType: ...

    def GetDereferencedType(self) -> SBType: ...

    def GetUnqualifiedType(self) -> SBType: ...

    def GetCanonicalType(self) -> SBType: ...

    def GetArrayElementType(self) -> SBType: ...

    def GetArrayType(self, size: int) -> SBType: ...

    def GetVectorElementType(self) -> SBType: ...

    def GetBasicType(self) -> BasicType: ...

    def GetNumberOfFields(self) -> int: ...

    def GetNumberOfDirectBaseClasses(self) -> int: ...

    def GetNumberOfVirtualBaseClasses(self) -> int: ...

    def GetFieldAtIndex(self, index: int) -> SBTypeMember: ...

    def GetDirectBaseClassAtIndex(self, index: int) -> SBTypeMember: ...

    def GetVirtualBaseClassAtIndex(self, index: int) -> SBTypeMember: ...

    def GetEnumMembers(self) -> SBTypeEnumMemberList: ...

    def GetName(self) -> str: ...

    def GetDisplayTypeName(self) -> str: ...

    def GetTypeClass(self) -> TypeClass: ...

    def GetNumberOfTemplateArguments(self) -> int: ...

    def GetTemplateArgumentType(self, index: int) -> SBType: ...

    def GetTemplateArgumentKind(self, index: int) -> TemplateArgumentKind: ...

    def GetFunctionReturnType(self) -> SBType: ...

    def GetFunctionArgumentTypes(self) -> SBTypeList: ...

    def GetNumberOfMemberFunctions(self) -> int: ...

    def GetMemberFunctionAtIndex(self, index: int) -> SBTypeMemberFunction: ...

    def IsTypeComplete(self) -> bool: ...

    def GetTypeFlags(self) -> int: ...

    def __eq__(self, rhs: SBType) -> bool: ...

    def __ne__(self, rhs: SBType) -> bool: ...

    def __str__(self) -> str: ...

    name: str
    size: int
    is_pointer: int
    is_reference: int
    is_function: int
    num_fields: int
    num_bases: int
    num_vbases: int
    num_template_args: int
    bases: int
    vbases: int
    fields: List[SBTypeMember]
    template_args: List[SBType]


class SBValue:
    def __init__(self) -> None: ...

    def IsValid(self) -> bool: ...

    def Clear(self): ...

    def GetError(self) -> SBError: ...

    def GetName(self) -> str: ...

    def GetTypeName(self) -> str: ...

    def GetDisplayTypeName(self) -> str: ...

    def GetByteSize(self) -> int: ...

    def IsInScope(self) -> bool: ...

    def GetFormat(self) -> Format: ...

    def SetFormat(self, format: Format): ...

    def GetValue(self) -> str: ...

    def GetValueAsSigned(self) -> int: ...

    def GetValueAsUnsigned(self) -> int: ...

    def GetValueType(self) -> ValueType: ...

    def GetValueDidChange(self) -> bool: ...

    def GetSummary(self) -> str: ...

    def GetObjectDescription(self) -> str: ...

    def GetDynamicValue(self) -> SBValue: ...

    def GetStaticValue(self) -> SBValue: ...

    def GetNonSyntheticValue(self) -> SBValue: ...

    def GetPreferDynamicValue(self) -> DynamicValueType: ...

    def SetPreferDynamicValue(self, value: bool): ...

    def GetPreferSyntheticValue(self) -> bool: ...

    def SetPreferSyntheticValue(self, value: bool): ...

    def IsDynamic(self) -> bool: ...

    def IsSynthetic(self) -> bool: ...

    def IsSyntheticChildrenGenerated(self) -> bool: ...

    def SetSyntheticChildrenGenerated(self, value: bool): ...

    def GetLocation(self) -> str: ...

    def SetValueFromCString(self, s: str) -> bool: ...

    def GetTypeFormat(self, s: str) -> SBTypeFormat: ...

    def GetTypeSummary(self, s: str) -> SBTypeSummary: ...

    def GetTypeFilter(self, s: str) -> SBTypeFilter: ...

    def GetTypeSynthetic(self, s: str) -> SBTypeSynthetic: ...

    def GetChildAtIndex(self, index: int) -> SBValue: ...

    def CreateChildAtOffset(self, name: str, offset: int, type: SBType) -> SBValue: ...

    def Cast(self, type: SBType) -> SBValue: ...

    def CreateValueFromExpression(self, name: str, expr: str) -> SBValue: ...

    def CreateValueFromAddress(self, name: str, address: int, type: SBType) -> SBValue: ...

    def CreateValueFromData(self, name: str, data: SBData, type: SBType) -> SBValue: ...

    def GetType(self) -> SBType: ...

    def GetIndexOfChildWithName(self, name: str) -> int: ...

    def GetChildMemberWithName(self, name: str) -> SBValue: ...

    def GetValueForExpressionPath(self, path: str) -> SBValue: ...

    def GetDeclaration(self) -> SBDeclaration: ...

    def MightHaveChildren(self) -> bool: ...

    def IsRuntimeSupportValue(self) -> bool: ...

    def GetNumChildren(self) -> int: ...

    def GetOpaqueType(self) -> Any: ...

    def Dereference(self) -> SBValue: ...

    def AddressOf(self) -> SBValue: ...

    def TypeIsPointerType(self) -> bool: ...

    def GetTarget(self) -> SBTarget: ...

    def GetProcess(self) -> SBProcess: ...

    def GetThread(self) -> SBThread: ...

    def GetFrame(self) -> SBFrame: ...

    def GetDescription(self, description: SBStream) -> bool: ...

    def GetPointeeData(self) -> SBData: ...

    def GetData(self) -> SBData: ...

    def SetData(self, data: SBData, error: SBError) -> bool: ...

    def GetLoadAddress(self) -> int: ...

    def GetAddress(self) -> SBAddress: ...

    def Persist(self) -> SBValue: ...

    def GetExpressionPath(self, description: SBStream) -> bool: ...

    def EvaluateExpression(self, expr: str) -> SBValue: ...

    def __str__(self) -> str: ...

    children: List[SBValue]
    child: Any
    name: str
    type: SBType
    size: int
    is_in_scope: bool
    value: str
    deref: SBValue
    unsigned: int
    signed: int


class SBTypeMember:
    name: str
    type: SBType

    ...


class SBError:
    def Success(self) -> bool: ...

    def GetCString(self) -> str: ...

    def SetErrorString(self, s: str): ...

    ...


class SBData:
    def GetAddressByteSize(self) -> int: ...

    def SetData(self, err: SBError, buffer: Any, endian: ByteOrder, size: int): ...

    def decode(self, encoding: str) -> SBData: ...

    @staticmethod
    def CreateDataFromSInt64Array(endianness: int, pointer_size: int, arr: List[int]) -> SBData: ...

    @staticmethod
    def CreateDataFromUInt64Array(endianness: int, pointer_size: int, arr: List[int]) -> SBData: ...

    ...


class SBTarget:
    def GetAddressByteSize(self) -> int: ...

    def GetBasicType(self, basic_type: BasicType) -> SBBasicType: ...

    def FindTypes(self, type: str) -> SBTypeList: ...

    ...


class SBProcess:
    def ReadMemory(self, start: int, length: int, error: SBError) -> SBData: ...

    def GetByteOrder(self) -> ByteOrder: ...

    def GetAddressByteSize(self) -> int: ...

    def ReadPointerFromMemory(self, address: int, error: SBError) -> int: ...

    ...


class SBBasicType(SBType):
    ...

class SBTypeList:
    def GetTypeAtIndex(self, index: int) -> SBType: ...

BasicType = int
TypeClass = int
TemplateArgumentKind = int
ByteOrder = int
SBTypeEnumMemberList = Any
SBTypeMemberFunction = Any
SBTypeSynthetic = Any
SBTypeSummary = Any
SBTypeNameSpecifier = Any
Format = Any
ValueType = Any
DynamicValueType = Any
SBTypeFormat = Any
SBTypeFilter = Any
SBDeclaration = Any
SBThread = Any
SBFrame = Any
SBStream = Any
SBAddress = Any
SBExecutionContext = Any
SBModule = Any

eBasicTypeInvalid: int
eBasicTypeVoid: int
eBasicTypeChar: int
eBasicTypeSignedChar: int
eBasicTypeUnsignedChar: int
eBasicTypeWChar: int
eBasicTypeSignedWChar: int
eBasicTypeUnsignedWChar: int
eBasicTypeChar16: int
eBasicTypeChar32: int
eBasicTypeShort: int
eBasicTypeUnsignedShort: int
eBasicTypeInt: int
eBasicTypeUnsignedInt: int
eBasicTypeLong: int
eBasicTypeUnsignedLong: int
eBasicTypeLongLong: int
eBasicTypeUnsignedLongLong: int
eBasicTypeInt128: int
eBasicTypeUnsignedInt128: int
eBasicTypeBool: int
eBasicTypeHalf: int
eBasicTypeFloat: int
eBasicTypeDouble: int
eBasicTypeLongDouble: int
eBasicTypeFloatComplex: int
eBasicTypeDoubleComplex: int
eBasicTypeLongDoubleComplex: int
eBasicTypeObjCID: int
eBasicTypeObjCClass: int
eBasicTypeObjCSel: int
eBasicTypeNullPtr: int

eFormatChar: int
eFormatBinary: int
eFormatBytes: int
eFormatEnum: int
eFormatPointer: int

eTypeClassStruct: int
eTypeClassUnion: int
eTypeClassPointer: int
eTypeClassTypedef: int
eTypeClassVector: int
eTypeClassOther: int
eTypeClassAny: int

LLDB_INVALID_ADDRESS: int
